package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_ownerid_value", 
    "description", 
    "userformid", 
    "name", 
    "formjson", 
    "_owningbusinessunit_value", 
    "_createdby_value", 
    "_modifiedby_value", 
    "_createdonbehalfby_value", 
    "modifiedon", 
    "formxml", 
    "objecttypecode", 
    "_modifiedonbehalfby_value", 
    "type", 
    "versionnumber", 
    "createdon", 
    "_owningteam_value", 
    "_owninguser_value", 
    "istabletenabled"})
@JsonInclude(Include.NON_NULL)
public class Userform extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.userform";
    }

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("userformid")
    protected UUID userformid;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("formjson")
    protected String formjson;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("formxml")
    protected String formxml;

    @JsonProperty("objecttypecode")
    protected String objecttypecode;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("type")
    protected Integer type;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("istabletenabled")
    protected Boolean istabletenabled;

    protected Userform() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserform() {
        return new Builder();
    }

    public static final class Builder {
        private UUID _ownerid_value;
        private String description;
        private UUID userformid;
        private String name;
        private String formjson;
        private UUID _owningbusinessunit_value;
        private UUID _createdby_value;
        private UUID _modifiedby_value;
        private UUID _createdonbehalfby_value;
        private OffsetDateTime modifiedon;
        private String formxml;
        private String objecttypecode;
        private UUID _modifiedonbehalfby_value;
        private Integer type;
        private Long versionnumber;
        private OffsetDateTime createdon;
        private UUID _owningteam_value;
        private UUID _owninguser_value;
        private Boolean istabletenabled;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder userformid(UUID userformid) {
            this.userformid = userformid;
            this.changedFields = changedFields.add("userformid");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder formjson(String formjson) {
            this.formjson = formjson;
            this.changedFields = changedFields.add("formjson");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder formxml(String formxml) {
            this.formxml = formxml;
            this.changedFields = changedFields.add("formxml");
            return this;
        }

        public Builder objecttypecode(String objecttypecode) {
            this.objecttypecode = objecttypecode;
            this.changedFields = changedFields.add("objecttypecode");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder type(Integer type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder istabletenabled(Boolean istabletenabled) {
            this.istabletenabled = istabletenabled;
            this.changedFields = changedFields.add("istabletenabled");
            return this;
        }

        public Userform build() {
            Userform _x = new Userform();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.userform";
            _x._ownerid_value = _ownerid_value;
            _x.description = description;
            _x.userformid = userformid;
            _x.name = name;
            _x.formjson = formjson;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x._createdby_value = _createdby_value;
            _x._modifiedby_value = _modifiedby_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.modifiedon = modifiedon;
            _x.formxml = formxml;
            _x.objecttypecode = objecttypecode;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.type = type;
            _x.versionnumber = versionnumber;
            _x.createdon = createdon;
            _x._owningteam_value = _owningteam_value;
            _x._owninguser_value = _owninguser_value;
            _x.istabletenabled = istabletenabled;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && userformid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(userformid, UUID.class));
        }
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Userform with_ownerid_value(UUID _ownerid_value) {
        Userform _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userform");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Userform withDescription(String description) {
        Userform _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userform");
        _x.description = description;
        return _x;
    }

    @Property(name="userformid")
    @JsonIgnore
    public Optional<UUID> getUserformid() {
        return Optional.ofNullable(userformid);
    }

    public Userform withUserformid(UUID userformid) {
        Userform _x = _copy();
        _x.changedFields = changedFields.add("userformid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userform");
        _x.userformid = userformid;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Userform withName(String name) {
        Userform _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userform");
        _x.name = name;
        return _x;
    }

    @Property(name="formjson")
    @JsonIgnore
    public Optional<String> getFormjson() {
        return Optional.ofNullable(formjson);
    }

    public Userform withFormjson(String formjson) {
        Userform _x = _copy();
        _x.changedFields = changedFields.add("formjson");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userform");
        _x.formjson = formjson;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Userform with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Userform _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userform");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Userform with_createdby_value(UUID _createdby_value) {
        Userform _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userform");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Userform with_modifiedby_value(UUID _modifiedby_value) {
        Userform _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userform");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Userform with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Userform _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userform");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Userform withModifiedon(OffsetDateTime modifiedon) {
        Userform _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userform");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="formxml")
    @JsonIgnore
    public Optional<String> getFormxml() {
        return Optional.ofNullable(formxml);
    }

    public Userform withFormxml(String formxml) {
        Userform _x = _copy();
        _x.changedFields = changedFields.add("formxml");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userform");
        _x.formxml = formxml;
        return _x;
    }

    @Property(name="objecttypecode")
    @JsonIgnore
    public Optional<String> getObjecttypecode() {
        return Optional.ofNullable(objecttypecode);
    }

    public Userform withObjecttypecode(String objecttypecode) {
        Userform _x = _copy();
        _x.changedFields = changedFields.add("objecttypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userform");
        _x.objecttypecode = objecttypecode;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Userform with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Userform _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userform");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<Integer> getType() {
        return Optional.ofNullable(type);
    }

    public Userform withType(Integer type) {
        Userform _x = _copy();
        _x.changedFields = changedFields.add("type");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userform");
        _x.type = type;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Userform withVersionnumber(Long versionnumber) {
        Userform _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userform");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Userform withCreatedon(OffsetDateTime createdon) {
        Userform _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userform");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Userform with_owningteam_value(UUID _owningteam_value) {
        Userform _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userform");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Userform with_owninguser_value(UUID _owninguser_value) {
        Userform _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userform");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="istabletenabled")
    @JsonIgnore
    public Optional<Boolean> getIstabletenabled() {
        return Optional.ofNullable(istabletenabled);
    }

    public Userform withIstabletenabled(Boolean istabletenabled) {
        Userform _x = _copy();
        _x.changedFields = changedFields.add("istabletenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userform");
        _x.istabletenabled = istabletenabled;
        return _x;
    }

    public Userform withUnmappedField(String name, Object value) {
        Userform _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="UserForm_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getUserForm_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("UserForm_AsyncOperations"), RequestHelper.getValue(unmappedFields, "UserForm_AsyncOperations"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="UserForm_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getUserForm_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("UserForm_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "UserForm_BulkDeleteFailures"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Userform patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Userform _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Userform put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Userform _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Userform _copy() {
        Userform _x = new Userform();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._ownerid_value = _ownerid_value;
        _x.description = description;
        _x.userformid = userformid;
        _x.name = name;
        _x.formjson = formjson;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x._createdby_value = _createdby_value;
        _x._modifiedby_value = _modifiedby_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.modifiedon = modifiedon;
        _x.formxml = formxml;
        _x.objecttypecode = objecttypecode;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.type = type;
        _x.versionnumber = versionnumber;
        _x.createdon = createdon;
        _x._owningteam_value = _owningteam_value;
        _x._owninguser_value = _owninguser_value;
        _x.istabletenabled = istabletenabled;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Userform[");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("userformid=");
        b.append(this.userformid);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("formjson=");
        b.append(this.formjson);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("formxml=");
        b.append(this.formxml);
        b.append(", ");
        b.append("objecttypecode=");
        b.append(this.objecttypecode);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("istabletenabled=");
        b.append(this.istabletenabled);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
