package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "versionnumber", 
    "teamid", 
    "teamroleid", 
    "roleid"})
@JsonInclude(Include.NON_NULL)
public class Teamroles extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.teamroles";
    }

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("teamid")
    protected UUID teamid;

    @JsonProperty("teamroleid")
    protected UUID teamroleid;

    @JsonProperty("roleid")
    protected UUID roleid;

    protected Teamroles() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeamroles() {
        return new Builder();
    }

    public static final class Builder {
        private Long versionnumber;
        private UUID teamid;
        private UUID teamroleid;
        private UUID roleid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder teamid(UUID teamid) {
            this.teamid = teamid;
            this.changedFields = changedFields.add("teamid");
            return this;
        }

        public Builder teamroleid(UUID teamroleid) {
            this.teamroleid = teamroleid;
            this.changedFields = changedFields.add("teamroleid");
            return this;
        }

        public Builder roleid(UUID roleid) {
            this.roleid = roleid;
            this.changedFields = changedFields.add("roleid");
            return this;
        }

        public Teamroles build() {
            Teamroles _x = new Teamroles();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.teamroles";
            _x.versionnumber = versionnumber;
            _x.teamid = teamid;
            _x.teamroleid = teamroleid;
            _x.roleid = roleid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && teamroleid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(teamroleid, UUID.class));
        }
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Teamroles withVersionnumber(Long versionnumber) {
        Teamroles _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teamroles");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="teamid")
    @JsonIgnore
    public Optional<UUID> getTeamid() {
        return Optional.ofNullable(teamid);
    }

    public Teamroles withTeamid(UUID teamid) {
        Teamroles _x = _copy();
        _x.changedFields = changedFields.add("teamid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teamroles");
        _x.teamid = teamid;
        return _x;
    }

    @Property(name="teamroleid")
    @JsonIgnore
    public Optional<UUID> getTeamroleid() {
        return Optional.ofNullable(teamroleid);
    }

    public Teamroles withTeamroleid(UUID teamroleid) {
        Teamroles _x = _copy();
        _x.changedFields = changedFields.add("teamroleid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teamroles");
        _x.teamroleid = teamroleid;
        return _x;
    }

    @Property(name="roleid")
    @JsonIgnore
    public Optional<UUID> getRoleid() {
        return Optional.ofNullable(roleid);
    }

    public Teamroles withRoleid(UUID roleid) {
        Teamroles _x = _copy();
        _x.changedFields = changedFields.add("roleid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teamroles");
        _x.roleid = roleid;
        return _x;
    }

    public Teamroles withUnmappedField(String name, Object value) {
        Teamroles _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Teamroles patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Teamroles _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Teamroles put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Teamroles _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Teamroles _copy() {
        Teamroles _x = new Teamroles();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.versionnumber = versionnumber;
        _x.teamid = teamid;
        _x.teamroleid = teamroleid;
        _x.roleid = roleid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Teamroles[");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("teamid=");
        b.append(this.teamid);
        b.append(", ");
        b.append("teamroleid=");
        b.append(this.teamroleid);
        b.append(", ");
        b.append("roleid=");
        b.append(this.roleid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
