package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.entity.collection.request.AppmoduleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "createdon", 
    "_createdonbehalfby_value", 
    "_createdby_value", 
    "versionnumber", 
    "overriddencreatedon", 
    "solutionid", 
    "accessmode", 
    "componentstate", 
    "importsequencenumber", 
    "componentidunique", 
    "_modifiedby_value", 
    "name", 
    "iscustomizable", 
    "ismanaged", 
    "overwritetime", 
    "_modifiedonbehalfby_value", 
    "displayname", 
    "modifiedon", 
    "serviceplanid", 
    "utcconversiontimezonecode", 
    "timezoneruleversionnumber"})
@JsonInclude(Include.NON_NULL)
public class Serviceplan extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.serviceplan";
    }

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("accessmode")
    protected Integer accessmode;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("componentidunique")
    protected UUID componentidunique;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("displayname")
    protected String displayname;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("serviceplanid")
    protected UUID serviceplanid;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    protected Serviceplan() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderServiceplan() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime createdon;
        private UUID _createdonbehalfby_value;
        private UUID _createdby_value;
        private Long versionnumber;
        private OffsetDateTime overriddencreatedon;
        private UUID solutionid;
        private Integer accessmode;
        private Integer componentstate;
        private Integer importsequencenumber;
        private UUID componentidunique;
        private UUID _modifiedby_value;
        private String name;
        private BooleanManagedProperty iscustomizable;
        private Boolean ismanaged;
        private OffsetDateTime overwritetime;
        private UUID _modifiedonbehalfby_value;
        private String displayname;
        private OffsetDateTime modifiedon;
        private UUID serviceplanid;
        private Integer utcconversiontimezonecode;
        private Integer timezoneruleversionnumber;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder accessmode(Integer accessmode) {
            this.accessmode = accessmode;
            this.changedFields = changedFields.add("accessmode");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder componentidunique(UUID componentidunique) {
            this.componentidunique = componentidunique;
            this.changedFields = changedFields.add("componentidunique");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder displayname(String displayname) {
            this.displayname = displayname;
            this.changedFields = changedFields.add("displayname");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder serviceplanid(UUID serviceplanid) {
            this.serviceplanid = serviceplanid;
            this.changedFields = changedFields.add("serviceplanid");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Serviceplan build() {
            Serviceplan _x = new Serviceplan();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.serviceplan";
            _x.createdon = createdon;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._createdby_value = _createdby_value;
            _x.versionnumber = versionnumber;
            _x.overriddencreatedon = overriddencreatedon;
            _x.solutionid = solutionid;
            _x.accessmode = accessmode;
            _x.componentstate = componentstate;
            _x.importsequencenumber = importsequencenumber;
            _x.componentidunique = componentidunique;
            _x._modifiedby_value = _modifiedby_value;
            _x.name = name;
            _x.iscustomizable = iscustomizable;
            _x.ismanaged = ismanaged;
            _x.overwritetime = overwritetime;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.displayname = displayname;
            _x.modifiedon = modifiedon;
            _x.serviceplanid = serviceplanid;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && serviceplanid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(serviceplanid, UUID.class));
        }
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Serviceplan withCreatedon(OffsetDateTime createdon) {
        Serviceplan _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplan");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Serviceplan with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Serviceplan _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplan");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Serviceplan with_createdby_value(UUID _createdby_value) {
        Serviceplan _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplan");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Serviceplan withVersionnumber(Long versionnumber) {
        Serviceplan _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplan");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Serviceplan withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Serviceplan _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplan");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Serviceplan withSolutionid(UUID solutionid) {
        Serviceplan _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplan");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="accessmode")
    @JsonIgnore
    public Optional<Integer> getAccessmode() {
        return Optional.ofNullable(accessmode);
    }

    public Serviceplan withAccessmode(Integer accessmode) {
        Serviceplan _x = _copy();
        _x.changedFields = changedFields.add("accessmode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplan");
        _x.accessmode = accessmode;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Serviceplan withComponentstate(Integer componentstate) {
        Serviceplan _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplan");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Serviceplan withImportsequencenumber(Integer importsequencenumber) {
        Serviceplan _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplan");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="componentidunique")
    @JsonIgnore
    public Optional<UUID> getComponentidunique() {
        return Optional.ofNullable(componentidunique);
    }

    public Serviceplan withComponentidunique(UUID componentidunique) {
        Serviceplan _x = _copy();
        _x.changedFields = changedFields.add("componentidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplan");
        _x.componentidunique = componentidunique;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Serviceplan with_modifiedby_value(UUID _modifiedby_value) {
        Serviceplan _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplan");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Serviceplan withName(String name) {
        Serviceplan _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplan");
        _x.name = name;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Serviceplan withIscustomizable(BooleanManagedProperty iscustomizable) {
        Serviceplan _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplan");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Serviceplan withIsmanaged(Boolean ismanaged) {
        Serviceplan _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplan");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Serviceplan withOverwritetime(OffsetDateTime overwritetime) {
        Serviceplan _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplan");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Serviceplan with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Serviceplan _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplan");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="displayname")
    @JsonIgnore
    public Optional<String> getDisplayname() {
        return Optional.ofNullable(displayname);
    }

    public Serviceplan withDisplayname(String displayname) {
        Serviceplan _x = _copy();
        _x.changedFields = changedFields.add("displayname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplan");
        _x.displayname = displayname;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Serviceplan withModifiedon(OffsetDateTime modifiedon) {
        Serviceplan _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplan");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="serviceplanid")
    @JsonIgnore
    public Optional<UUID> getServiceplanid() {
        return Optional.ofNullable(serviceplanid);
    }

    public Serviceplan withServiceplanid(UUID serviceplanid) {
        Serviceplan _x = _copy();
        _x.changedFields = changedFields.add("serviceplanid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplan");
        _x.serviceplanid = serviceplanid;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Serviceplan withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Serviceplan _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplan");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Serviceplan withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Serviceplan _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceplan");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    public Serviceplan withUnmappedField(String name, Object value) {
        Serviceplan _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="serviceplan_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getServiceplan_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("serviceplan_SyncErrors"), RequestHelper.getValue(unmappedFields, "serviceplan_SyncErrors"));
    }

    @NavigationProperty(name="serviceplan_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getServiceplan_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("serviceplan_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "serviceplan_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="serviceplan_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getServiceplan_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("serviceplan_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "serviceplan_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="serviceplan_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getServiceplan_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("serviceplan_AsyncOperations"), RequestHelper.getValue(unmappedFields, "serviceplan_AsyncOperations"));
    }

    @NavigationProperty(name="serviceplan_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getServiceplan_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("serviceplan_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "serviceplan_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="serviceplan_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getServiceplan_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("serviceplan_ProcessSession"), RequestHelper.getValue(unmappedFields, "serviceplan_ProcessSession"));
    }

    @NavigationProperty(name="serviceplan_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getServiceplan_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("serviceplan_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "serviceplan_BulkDeleteFailures"));
    }

    @NavigationProperty(name="serviceplan_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getServiceplan_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("serviceplan_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "serviceplan_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="serviceplan_appmodule_association")
    @JsonIgnore
    public AppmoduleCollectionRequest getServiceplan_appmodule_association() {
        return new AppmoduleCollectionRequest(
                        contextPath.addSegment("serviceplan_appmodule_association"), RequestHelper.getValue(unmappedFields, "serviceplan_appmodule_association"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Serviceplan patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Serviceplan _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Serviceplan put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Serviceplan _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Serviceplan _copy() {
        Serviceplan _x = new Serviceplan();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.createdon = createdon;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._createdby_value = _createdby_value;
        _x.versionnumber = versionnumber;
        _x.overriddencreatedon = overriddencreatedon;
        _x.solutionid = solutionid;
        _x.accessmode = accessmode;
        _x.componentstate = componentstate;
        _x.importsequencenumber = importsequencenumber;
        _x.componentidunique = componentidunique;
        _x._modifiedby_value = _modifiedby_value;
        _x.name = name;
        _x.iscustomizable = iscustomizable;
        _x.ismanaged = ismanaged;
        _x.overwritetime = overwritetime;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.displayname = displayname;
        _x.modifiedon = modifiedon;
        _x.serviceplanid = serviceplanid;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Serviceplan[");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("accessmode=");
        b.append(this.accessmode);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("componentidunique=");
        b.append(this.componentidunique);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("displayname=");
        b.append(this.displayname);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("serviceplanid=");
        b.append(this.serviceplanid);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
