package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.entity.collection.request.SdkmessageprocessingstepCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "serviceendpointid", 
    "sastoken", 
    "overwritetime", 
    "solutionid", 
    "url", 
    "_createdonbehalfby_value", 
    "modifiedon", 
    "authvalue", 
    "ismanaged", 
    "iscustomizable", 
    "userclaim", 
    "name", 
    "issaskeyset", 
    "connectionmode", 
    "serviceendpointidunique", 
    "issastokenset", 
    "messageformat", 
    "saskey", 
    "namespaceformat", 
    "_createdby_value", 
    "introducedversion", 
    "createdon", 
    "namespaceaddress", 
    "authtype", 
    "_modifiedby_value", 
    "componentstate", 
    "_modifiedonbehalfby_value", 
    "contract", 
    "description", 
    "_organizationid_value", 
    "isauthvalueset", 
    "path", 
    "solutionnamespace", 
    "saskeyname"})
@JsonInclude(Include.NON_NULL)
public class Serviceendpoint extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.serviceendpoint";
    }

    @JsonProperty("serviceendpointid")
    protected UUID serviceendpointid;

    @JsonProperty("sastoken")
    protected String sastoken;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("url")
    protected String url;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("authvalue")
    protected String authvalue;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("userclaim")
    protected Integer userclaim;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("issaskeyset")
    protected Boolean issaskeyset;

    @JsonProperty("connectionmode")
    protected Integer connectionmode;

    @JsonProperty("serviceendpointidunique")
    protected UUID serviceendpointidunique;

    @JsonProperty("issastokenset")
    protected Boolean issastokenset;

    @JsonProperty("messageformat")
    protected Integer messageformat;

    @JsonProperty("saskey")
    protected String saskey;

    @JsonProperty("namespaceformat")
    protected Integer namespaceformat;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("namespaceaddress")
    protected String namespaceaddress;

    @JsonProperty("authtype")
    protected Integer authtype;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("contract")
    protected Integer contract;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("_organizationid_value")
    protected UUID _organizationid_value;

    @JsonProperty("isauthvalueset")
    protected Boolean isauthvalueset;

    @JsonProperty("path")
    protected String path;

    @JsonProperty("solutionnamespace")
    protected String solutionnamespace;

    @JsonProperty("saskeyname")
    protected String saskeyname;

    protected Serviceendpoint() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderServiceendpoint() {
        return new Builder();
    }

    public static final class Builder {
        private UUID serviceendpointid;
        private String sastoken;
        private OffsetDateTime overwritetime;
        private UUID solutionid;
        private String url;
        private UUID _createdonbehalfby_value;
        private OffsetDateTime modifiedon;
        private String authvalue;
        private Boolean ismanaged;
        private BooleanManagedProperty iscustomizable;
        private Integer userclaim;
        private String name;
        private Boolean issaskeyset;
        private Integer connectionmode;
        private UUID serviceendpointidunique;
        private Boolean issastokenset;
        private Integer messageformat;
        private String saskey;
        private Integer namespaceformat;
        private UUID _createdby_value;
        private String introducedversion;
        private OffsetDateTime createdon;
        private String namespaceaddress;
        private Integer authtype;
        private UUID _modifiedby_value;
        private Integer componentstate;
        private UUID _modifiedonbehalfby_value;
        private Integer contract;
        private String description;
        private UUID _organizationid_value;
        private Boolean isauthvalueset;
        private String path;
        private String solutionnamespace;
        private String saskeyname;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder serviceendpointid(UUID serviceendpointid) {
            this.serviceendpointid = serviceendpointid;
            this.changedFields = changedFields.add("serviceendpointid");
            return this;
        }

        public Builder sastoken(String sastoken) {
            this.sastoken = sastoken;
            this.changedFields = changedFields.add("sastoken");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            this.changedFields = changedFields.add("url");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder authvalue(String authvalue) {
            this.authvalue = authvalue;
            this.changedFields = changedFields.add("authvalue");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder userclaim(Integer userclaim) {
            this.userclaim = userclaim;
            this.changedFields = changedFields.add("userclaim");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder issaskeyset(Boolean issaskeyset) {
            this.issaskeyset = issaskeyset;
            this.changedFields = changedFields.add("issaskeyset");
            return this;
        }

        public Builder connectionmode(Integer connectionmode) {
            this.connectionmode = connectionmode;
            this.changedFields = changedFields.add("connectionmode");
            return this;
        }

        public Builder serviceendpointidunique(UUID serviceendpointidunique) {
            this.serviceendpointidunique = serviceendpointidunique;
            this.changedFields = changedFields.add("serviceendpointidunique");
            return this;
        }

        public Builder issastokenset(Boolean issastokenset) {
            this.issastokenset = issastokenset;
            this.changedFields = changedFields.add("issastokenset");
            return this;
        }

        public Builder messageformat(Integer messageformat) {
            this.messageformat = messageformat;
            this.changedFields = changedFields.add("messageformat");
            return this;
        }

        public Builder saskey(String saskey) {
            this.saskey = saskey;
            this.changedFields = changedFields.add("saskey");
            return this;
        }

        public Builder namespaceformat(Integer namespaceformat) {
            this.namespaceformat = namespaceformat;
            this.changedFields = changedFields.add("namespaceformat");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder namespaceaddress(String namespaceaddress) {
            this.namespaceaddress = namespaceaddress;
            this.changedFields = changedFields.add("namespaceaddress");
            return this;
        }

        public Builder authtype(Integer authtype) {
            this.authtype = authtype;
            this.changedFields = changedFields.add("authtype");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder contract(Integer contract) {
            this.contract = contract;
            this.changedFields = changedFields.add("contract");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder _organizationid_value(UUID _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder isauthvalueset(Boolean isauthvalueset) {
            this.isauthvalueset = isauthvalueset;
            this.changedFields = changedFields.add("isauthvalueset");
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            this.changedFields = changedFields.add("path");
            return this;
        }

        public Builder solutionnamespace(String solutionnamespace) {
            this.solutionnamespace = solutionnamespace;
            this.changedFields = changedFields.add("solutionnamespace");
            return this;
        }

        public Builder saskeyname(String saskeyname) {
            this.saskeyname = saskeyname;
            this.changedFields = changedFields.add("saskeyname");
            return this;
        }

        public Serviceendpoint build() {
            Serviceendpoint _x = new Serviceendpoint();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.serviceendpoint";
            _x.serviceendpointid = serviceendpointid;
            _x.sastoken = sastoken;
            _x.overwritetime = overwritetime;
            _x.solutionid = solutionid;
            _x.url = url;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.modifiedon = modifiedon;
            _x.authvalue = authvalue;
            _x.ismanaged = ismanaged;
            _x.iscustomizable = iscustomizable;
            _x.userclaim = userclaim;
            _x.name = name;
            _x.issaskeyset = issaskeyset;
            _x.connectionmode = connectionmode;
            _x.serviceendpointidunique = serviceendpointidunique;
            _x.issastokenset = issastokenset;
            _x.messageformat = messageformat;
            _x.saskey = saskey;
            _x.namespaceformat = namespaceformat;
            _x._createdby_value = _createdby_value;
            _x.introducedversion = introducedversion;
            _x.createdon = createdon;
            _x.namespaceaddress = namespaceaddress;
            _x.authtype = authtype;
            _x._modifiedby_value = _modifiedby_value;
            _x.componentstate = componentstate;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.contract = contract;
            _x.description = description;
            _x._organizationid_value = _organizationid_value;
            _x.isauthvalueset = isauthvalueset;
            _x.path = path;
            _x.solutionnamespace = solutionnamespace;
            _x.saskeyname = saskeyname;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && serviceendpointid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(serviceendpointid, UUID.class));
        }
    }

    @Property(name="serviceendpointid")
    @JsonIgnore
    public Optional<UUID> getServiceendpointid() {
        return Optional.ofNullable(serviceendpointid);
    }

    public Serviceendpoint withServiceendpointid(UUID serviceendpointid) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("serviceendpointid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.serviceendpointid = serviceendpointid;
        return _x;
    }

    @Property(name="sastoken")
    @JsonIgnore
    public Optional<String> getSastoken() {
        return Optional.ofNullable(sastoken);
    }

    public Serviceendpoint withSastoken(String sastoken) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("sastoken");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.sastoken = sastoken;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Serviceendpoint withOverwritetime(OffsetDateTime overwritetime) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Serviceendpoint withSolutionid(UUID solutionid) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="url")
    @JsonIgnore
    public Optional<String> getUrl() {
        return Optional.ofNullable(url);
    }

    public Serviceendpoint withUrl(String url) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("url");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.url = url;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Serviceendpoint with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Serviceendpoint withModifiedon(OffsetDateTime modifiedon) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="authvalue")
    @JsonIgnore
    public Optional<String> getAuthvalue() {
        return Optional.ofNullable(authvalue);
    }

    public Serviceendpoint withAuthvalue(String authvalue) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("authvalue");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.authvalue = authvalue;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Serviceendpoint withIsmanaged(Boolean ismanaged) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Serviceendpoint withIscustomizable(BooleanManagedProperty iscustomizable) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="userclaim")
    @JsonIgnore
    public Optional<Integer> getUserclaim() {
        return Optional.ofNullable(userclaim);
    }

    public Serviceendpoint withUserclaim(Integer userclaim) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("userclaim");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.userclaim = userclaim;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Serviceendpoint withName(String name) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.name = name;
        return _x;
    }

    @Property(name="issaskeyset")
    @JsonIgnore
    public Optional<Boolean> getIssaskeyset() {
        return Optional.ofNullable(issaskeyset);
    }

    public Serviceendpoint withIssaskeyset(Boolean issaskeyset) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("issaskeyset");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.issaskeyset = issaskeyset;
        return _x;
    }

    @Property(name="connectionmode")
    @JsonIgnore
    public Optional<Integer> getConnectionmode() {
        return Optional.ofNullable(connectionmode);
    }

    public Serviceendpoint withConnectionmode(Integer connectionmode) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("connectionmode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.connectionmode = connectionmode;
        return _x;
    }

    @Property(name="serviceendpointidunique")
    @JsonIgnore
    public Optional<UUID> getServiceendpointidunique() {
        return Optional.ofNullable(serviceendpointidunique);
    }

    public Serviceendpoint withServiceendpointidunique(UUID serviceendpointidunique) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("serviceendpointidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.serviceendpointidunique = serviceendpointidunique;
        return _x;
    }

    @Property(name="issastokenset")
    @JsonIgnore
    public Optional<Boolean> getIssastokenset() {
        return Optional.ofNullable(issastokenset);
    }

    public Serviceendpoint withIssastokenset(Boolean issastokenset) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("issastokenset");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.issastokenset = issastokenset;
        return _x;
    }

    @Property(name="messageformat")
    @JsonIgnore
    public Optional<Integer> getMessageformat() {
        return Optional.ofNullable(messageformat);
    }

    public Serviceendpoint withMessageformat(Integer messageformat) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("messageformat");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.messageformat = messageformat;
        return _x;
    }

    @Property(name="saskey")
    @JsonIgnore
    public Optional<String> getSaskey() {
        return Optional.ofNullable(saskey);
    }

    public Serviceendpoint withSaskey(String saskey) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("saskey");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.saskey = saskey;
        return _x;
    }

    @Property(name="namespaceformat")
    @JsonIgnore
    public Optional<Integer> getNamespaceformat() {
        return Optional.ofNullable(namespaceformat);
    }

    public Serviceendpoint withNamespaceformat(Integer namespaceformat) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("namespaceformat");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.namespaceformat = namespaceformat;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Serviceendpoint with_createdby_value(UUID _createdby_value) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Serviceendpoint withIntroducedversion(String introducedversion) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Serviceendpoint withCreatedon(OffsetDateTime createdon) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="namespaceaddress")
    @JsonIgnore
    public Optional<String> getNamespaceaddress() {
        return Optional.ofNullable(namespaceaddress);
    }

    public Serviceendpoint withNamespaceaddress(String namespaceaddress) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("namespaceaddress");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.namespaceaddress = namespaceaddress;
        return _x;
    }

    @Property(name="authtype")
    @JsonIgnore
    public Optional<Integer> getAuthtype() {
        return Optional.ofNullable(authtype);
    }

    public Serviceendpoint withAuthtype(Integer authtype) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("authtype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.authtype = authtype;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Serviceendpoint with_modifiedby_value(UUID _modifiedby_value) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Serviceendpoint withComponentstate(Integer componentstate) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Serviceendpoint with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="contract")
    @JsonIgnore
    public Optional<Integer> getContract() {
        return Optional.ofNullable(contract);
    }

    public Serviceendpoint withContract(Integer contract) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("contract");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.contract = contract;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Serviceendpoint withDescription(String description) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.description = description;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<UUID> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Serviceendpoint with_organizationid_value(UUID _organizationid_value) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="isauthvalueset")
    @JsonIgnore
    public Optional<Boolean> getIsauthvalueset() {
        return Optional.ofNullable(isauthvalueset);
    }

    public Serviceendpoint withIsauthvalueset(Boolean isauthvalueset) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("isauthvalueset");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.isauthvalueset = isauthvalueset;
        return _x;
    }

    @Property(name="path")
    @JsonIgnore
    public Optional<String> getPath() {
        return Optional.ofNullable(path);
    }

    public Serviceendpoint withPath(String path) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("path");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.path = path;
        return _x;
    }

    @Property(name="solutionnamespace")
    @JsonIgnore
    public Optional<String> getSolutionnamespace() {
        return Optional.ofNullable(solutionnamespace);
    }

    public Serviceendpoint withSolutionnamespace(String solutionnamespace) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("solutionnamespace");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.solutionnamespace = solutionnamespace;
        return _x;
    }

    @Property(name="saskeyname")
    @JsonIgnore
    public Optional<String> getSaskeyname() {
        return Optional.ofNullable(saskeyname);
    }

    public Serviceendpoint withSaskeyname(String saskeyname) {
        Serviceendpoint _x = _copy();
        _x.changedFields = changedFields.add("saskeyname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.serviceendpoint");
        _x.saskeyname = saskeyname;
        return _x;
    }

    public Serviceendpoint withUnmappedField(String name, Object value) {
        Serviceendpoint _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="serviceendpoint_sdkmessageprocessingstep")
    @JsonIgnore
    public SdkmessageprocessingstepCollectionRequest getServiceendpoint_sdkmessageprocessingstep() {
        return new SdkmessageprocessingstepCollectionRequest(
                        contextPath.addSegment("serviceendpoint_sdkmessageprocessingstep"), RequestHelper.getValue(unmappedFields, "serviceendpoint_sdkmessageprocessingstep"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Serviceendpoint patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Serviceendpoint _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Serviceendpoint put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Serviceendpoint _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Serviceendpoint _copy() {
        Serviceendpoint _x = new Serviceendpoint();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.serviceendpointid = serviceendpointid;
        _x.sastoken = sastoken;
        _x.overwritetime = overwritetime;
        _x.solutionid = solutionid;
        _x.url = url;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.modifiedon = modifiedon;
        _x.authvalue = authvalue;
        _x.ismanaged = ismanaged;
        _x.iscustomizable = iscustomizable;
        _x.userclaim = userclaim;
        _x.name = name;
        _x.issaskeyset = issaskeyset;
        _x.connectionmode = connectionmode;
        _x.serviceendpointidunique = serviceendpointidunique;
        _x.issastokenset = issastokenset;
        _x.messageformat = messageformat;
        _x.saskey = saskey;
        _x.namespaceformat = namespaceformat;
        _x._createdby_value = _createdby_value;
        _x.introducedversion = introducedversion;
        _x.createdon = createdon;
        _x.namespaceaddress = namespaceaddress;
        _x.authtype = authtype;
        _x._modifiedby_value = _modifiedby_value;
        _x.componentstate = componentstate;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.contract = contract;
        _x.description = description;
        _x._organizationid_value = _organizationid_value;
        _x.isauthvalueset = isauthvalueset;
        _x.path = path;
        _x.solutionnamespace = solutionnamespace;
        _x.saskeyname = saskeyname;
        return _x;
    }

    @Action(name = "TriggerServiceEndpointCheck")
    @JsonIgnore
    public ActionRequestNoReturn triggerServiceEndpointCheck() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.TriggerServiceEndpointCheck"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Serviceendpoint[");
        b.append("serviceendpointid=");
        b.append(this.serviceendpointid);
        b.append(", ");
        b.append("sastoken=");
        b.append(this.sastoken);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("url=");
        b.append(this.url);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("authvalue=");
        b.append(this.authvalue);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("userclaim=");
        b.append(this.userclaim);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("issaskeyset=");
        b.append(this.issaskeyset);
        b.append(", ");
        b.append("connectionmode=");
        b.append(this.connectionmode);
        b.append(", ");
        b.append("serviceendpointidunique=");
        b.append(this.serviceendpointidunique);
        b.append(", ");
        b.append("issastokenset=");
        b.append(this.issastokenset);
        b.append(", ");
        b.append("messageformat=");
        b.append(this.messageformat);
        b.append(", ");
        b.append("saskey=");
        b.append(this.saskey);
        b.append(", ");
        b.append("namespaceformat=");
        b.append(this.namespaceformat);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("namespaceaddress=");
        b.append(this.namespaceaddress);
        b.append(", ");
        b.append("authtype=");
        b.append(this.authtype);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("contract=");
        b.append(this.contract);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("isauthvalueset=");
        b.append(this.isauthvalueset);
        b.append(", ");
        b.append("path=");
        b.append(this.path);
        b.append(", ");
        b.append("solutionnamespace=");
        b.append(this.solutionnamespace);
        b.append(", ");
        b.append("saskeyname=");
        b.append(this.saskeyname);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
