package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;

@JsonPropertyOrder({
    "@odata.type", 
    "requiredcomponenttype", 
    "dependentcomponenttype", 
    "requiredcomponentnodeid", 
    "dependentcomponentnodeid", 
    "requiredcomponentmodifiedtime", 
    "ispublished", 
    "createdtime", 
    "dependencyid"})
@JsonInclude(Include.NON_NULL)
public class Runtimedependency extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.runtimedependency";
    }

    @JsonProperty("requiredcomponenttype")
    protected Integer requiredcomponenttype;

    @JsonProperty("dependentcomponenttype")
    protected Integer dependentcomponenttype;

    @JsonProperty("requiredcomponentnodeid")
    protected String requiredcomponentnodeid;

    @JsonProperty("dependentcomponentnodeid")
    protected UUID dependentcomponentnodeid;

    @JsonProperty("requiredcomponentmodifiedtime")
    protected OffsetDateTime requiredcomponentmodifiedtime;

    @JsonProperty("ispublished")
    protected BooleanManagedProperty ispublished;

    @JsonProperty("createdtime")
    protected OffsetDateTime createdtime;

    @JsonProperty("dependencyid")
    protected UUID dependencyid;

    protected Runtimedependency() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRuntimedependency() {
        return new Builder();
    }

    public static final class Builder {
        private Integer requiredcomponenttype;
        private Integer dependentcomponenttype;
        private String requiredcomponentnodeid;
        private UUID dependentcomponentnodeid;
        private OffsetDateTime requiredcomponentmodifiedtime;
        private BooleanManagedProperty ispublished;
        private OffsetDateTime createdtime;
        private UUID dependencyid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder requiredcomponenttype(Integer requiredcomponenttype) {
            this.requiredcomponenttype = requiredcomponenttype;
            this.changedFields = changedFields.add("requiredcomponenttype");
            return this;
        }

        public Builder dependentcomponenttype(Integer dependentcomponenttype) {
            this.dependentcomponenttype = dependentcomponenttype;
            this.changedFields = changedFields.add("dependentcomponenttype");
            return this;
        }

        public Builder requiredcomponentnodeid(String requiredcomponentnodeid) {
            this.requiredcomponentnodeid = requiredcomponentnodeid;
            this.changedFields = changedFields.add("requiredcomponentnodeid");
            return this;
        }

        public Builder dependentcomponentnodeid(UUID dependentcomponentnodeid) {
            this.dependentcomponentnodeid = dependentcomponentnodeid;
            this.changedFields = changedFields.add("dependentcomponentnodeid");
            return this;
        }

        public Builder requiredcomponentmodifiedtime(OffsetDateTime requiredcomponentmodifiedtime) {
            this.requiredcomponentmodifiedtime = requiredcomponentmodifiedtime;
            this.changedFields = changedFields.add("requiredcomponentmodifiedtime");
            return this;
        }

        public Builder ispublished(BooleanManagedProperty ispublished) {
            this.ispublished = ispublished;
            this.changedFields = changedFields.add("ispublished");
            return this;
        }

        public Builder createdtime(OffsetDateTime createdtime) {
            this.createdtime = createdtime;
            this.changedFields = changedFields.add("createdtime");
            return this;
        }

        public Builder dependencyid(UUID dependencyid) {
            this.dependencyid = dependencyid;
            this.changedFields = changedFields.add("dependencyid");
            return this;
        }

        public Runtimedependency build() {
            Runtimedependency _x = new Runtimedependency();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.runtimedependency";
            _x.requiredcomponenttype = requiredcomponenttype;
            _x.dependentcomponenttype = dependentcomponenttype;
            _x.requiredcomponentnodeid = requiredcomponentnodeid;
            _x.dependentcomponentnodeid = dependentcomponentnodeid;
            _x.requiredcomponentmodifiedtime = requiredcomponentmodifiedtime;
            _x.ispublished = ispublished;
            _x.createdtime = createdtime;
            _x.dependencyid = dependencyid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && dependencyid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(dependencyid, UUID.class));
        }
    }

    @Property(name="requiredcomponenttype")
    @JsonIgnore
    public Optional<Integer> getRequiredcomponenttype() {
        return Optional.ofNullable(requiredcomponenttype);
    }

    public Runtimedependency withRequiredcomponenttype(Integer requiredcomponenttype) {
        Runtimedependency _x = _copy();
        _x.changedFields = changedFields.add("requiredcomponenttype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.runtimedependency");
        _x.requiredcomponenttype = requiredcomponenttype;
        return _x;
    }

    @Property(name="dependentcomponenttype")
    @JsonIgnore
    public Optional<Integer> getDependentcomponenttype() {
        return Optional.ofNullable(dependentcomponenttype);
    }

    public Runtimedependency withDependentcomponenttype(Integer dependentcomponenttype) {
        Runtimedependency _x = _copy();
        _x.changedFields = changedFields.add("dependentcomponenttype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.runtimedependency");
        _x.dependentcomponenttype = dependentcomponenttype;
        return _x;
    }

    @Property(name="requiredcomponentnodeid")
    @JsonIgnore
    public Optional<String> getRequiredcomponentnodeid() {
        return Optional.ofNullable(requiredcomponentnodeid);
    }

    public Runtimedependency withRequiredcomponentnodeid(String requiredcomponentnodeid) {
        Runtimedependency _x = _copy();
        _x.changedFields = changedFields.add("requiredcomponentnodeid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.runtimedependency");
        _x.requiredcomponentnodeid = requiredcomponentnodeid;
        return _x;
    }

    @Property(name="dependentcomponentnodeid")
    @JsonIgnore
    public Optional<UUID> getDependentcomponentnodeid() {
        return Optional.ofNullable(dependentcomponentnodeid);
    }

    public Runtimedependency withDependentcomponentnodeid(UUID dependentcomponentnodeid) {
        Runtimedependency _x = _copy();
        _x.changedFields = changedFields.add("dependentcomponentnodeid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.runtimedependency");
        _x.dependentcomponentnodeid = dependentcomponentnodeid;
        return _x;
    }

    @Property(name="requiredcomponentmodifiedtime")
    @JsonIgnore
    public Optional<OffsetDateTime> getRequiredcomponentmodifiedtime() {
        return Optional.ofNullable(requiredcomponentmodifiedtime);
    }

    public Runtimedependency withRequiredcomponentmodifiedtime(OffsetDateTime requiredcomponentmodifiedtime) {
        Runtimedependency _x = _copy();
        _x.changedFields = changedFields.add("requiredcomponentmodifiedtime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.runtimedependency");
        _x.requiredcomponentmodifiedtime = requiredcomponentmodifiedtime;
        return _x;
    }

    @Property(name="ispublished")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIspublished() {
        return Optional.ofNullable(ispublished);
    }

    public Runtimedependency withIspublished(BooleanManagedProperty ispublished) {
        Runtimedependency _x = _copy();
        _x.changedFields = changedFields.add("ispublished");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.runtimedependency");
        _x.ispublished = ispublished;
        return _x;
    }

    @Property(name="createdtime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedtime() {
        return Optional.ofNullable(createdtime);
    }

    public Runtimedependency withCreatedtime(OffsetDateTime createdtime) {
        Runtimedependency _x = _copy();
        _x.changedFields = changedFields.add("createdtime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.runtimedependency");
        _x.createdtime = createdtime;
        return _x;
    }

    @Property(name="dependencyid")
    @JsonIgnore
    public Optional<UUID> getDependencyid() {
        return Optional.ofNullable(dependencyid);
    }

    public Runtimedependency withDependencyid(UUID dependencyid) {
        Runtimedependency _x = _copy();
        _x.changedFields = changedFields.add("dependencyid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.runtimedependency");
        _x.dependencyid = dependencyid;
        return _x;
    }

    public Runtimedependency withUnmappedField(String name, Object value) {
        Runtimedependency _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Runtimedependency patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Runtimedependency _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Runtimedependency put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Runtimedependency _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Runtimedependency _copy() {
        Runtimedependency _x = new Runtimedependency();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.requiredcomponenttype = requiredcomponenttype;
        _x.dependentcomponenttype = dependentcomponenttype;
        _x.requiredcomponentnodeid = requiredcomponentnodeid;
        _x.dependentcomponentnodeid = dependentcomponentnodeid;
        _x.requiredcomponentmodifiedtime = requiredcomponentmodifiedtime;
        _x.ispublished = ispublished;
        _x.createdtime = createdtime;
        _x.dependencyid = dependencyid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Runtimedependency[");
        b.append("requiredcomponenttype=");
        b.append(this.requiredcomponenttype);
        b.append(", ");
        b.append("dependentcomponenttype=");
        b.append(this.dependentcomponenttype);
        b.append(", ");
        b.append("requiredcomponentnodeid=");
        b.append(this.requiredcomponentnodeid);
        b.append(", ");
        b.append("dependentcomponentnodeid=");
        b.append(this.dependentcomponentnodeid);
        b.append(", ");
        b.append("requiredcomponentmodifiedtime=");
        b.append(this.requiredcomponentmodifiedtime);
        b.append(", ");
        b.append("ispublished=");
        b.append(this.ispublished);
        b.append(", ");
        b.append("createdtime=");
        b.append(this.createdtime);
        b.append(", ");
        b.append("dependencyid=");
        b.append(this.dependencyid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
