package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.PrivilegeCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RoleCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "name", 
    "roletemplateid"})
@JsonInclude(Include.NON_NULL)
public class Roletemplate extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.roletemplate";
    }

    @JsonProperty("name")
    protected String name;

    @JsonProperty("roletemplateid")
    protected UUID roletemplateid;

    protected Roletemplate() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRoletemplate() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private UUID roletemplateid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder roletemplateid(UUID roletemplateid) {
            this.roletemplateid = roletemplateid;
            this.changedFields = changedFields.add("roletemplateid");
            return this;
        }

        public Roletemplate build() {
            Roletemplate _x = new Roletemplate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.roletemplate";
            _x.name = name;
            _x.roletemplateid = roletemplateid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && roletemplateid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(roletemplateid, UUID.class));
        }
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Roletemplate withName(String name) {
        Roletemplate _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.roletemplate");
        _x.name = name;
        return _x;
    }

    @Property(name="roletemplateid")
    @JsonIgnore
    public Optional<UUID> getRoletemplateid() {
        return Optional.ofNullable(roletemplateid);
    }

    public Roletemplate withRoletemplateid(UUID roletemplateid) {
        Roletemplate _x = _copy();
        _x.changedFields = changedFields.add("roletemplateid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.roletemplate");
        _x.roletemplateid = roletemplateid;
        return _x;
    }

    public Roletemplate withUnmappedField(String name, Object value) {
        Roletemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="roletemplateprivileges_association")
    @JsonIgnore
    public PrivilegeCollectionRequest getRoletemplateprivileges_association() {
        return new PrivilegeCollectionRequest(
                        contextPath.addSegment("roletemplateprivileges_association"), RequestHelper.getValue(unmappedFields, "roletemplateprivileges_association"));
    }

    @NavigationProperty(name="role_template_roles")
    @JsonIgnore
    public RoleCollectionRequest getRole_template_roles() {
        return new RoleCollectionRequest(
                        contextPath.addSegment("role_template_roles"), RequestHelper.getValue(unmappedFields, "role_template_roles"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Roletemplate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Roletemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Roletemplate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Roletemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Roletemplate _copy() {
        Roletemplate _x = new Roletemplate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.name = name;
        _x.roletemplateid = roletemplateid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Roletemplate[");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("roletemplateid=");
        b.append(this.roletemplateid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
