package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.ActivitypointerRequest;
import microsoft.dynamics.crm.entity.request.AppointmentRequest;
import microsoft.dynamics.crm.entity.request.EmailRequest;
import microsoft.dynamics.crm.entity.request.FaxRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleRequest;
import microsoft.dynamics.crm.entity.request.LetterRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_knowledgearticletemplateRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.PhonecallRequest;
import microsoft.dynamics.crm.entity.request.QueueRequest;
import microsoft.dynamics.crm.entity.request.RecurringappointmentmasterRequest;
import microsoft.dynamics.crm.entity.request.SocialactivityRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TaskRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_transactioncurrencyid_value", 
    "_workerid_value", 
    "_createdby_value", 
    "_modifiedby_value", 
    "_owningbusinessunit_value", 
    "modifiedon", 
    "title", 
    "workeridmodifiedon", 
    "_modifiedonbehalfby_value", 
    "versionnumber", 
    "utcconversiontimezonecode", 
    "_queueid_value", 
    "statecode", 
    "enteredon", 
    "overriddencreatedon", 
    "_ownerid_value", 
    "importsequencenumber", 
    "queueitemid", 
    "statuscode", 
    "_objectid_value", 
    "_owninguser_value", 
    "exchangerate", 
    "timezoneruleversionnumber", 
    "_createdonbehalfby_value", 
    "objecttypecode", 
    "_organizationid_value", 
    "createdon"})
@JsonInclude(Include.NON_NULL)
public class Queueitem extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.queueitem";
    }

    @JsonProperty("_transactioncurrencyid_value")
    protected UUID _transactioncurrencyid_value;

    @JsonProperty("_workerid_value")
    protected UUID _workerid_value;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("title")
    protected String title;

    @JsonProperty("workeridmodifiedon")
    protected OffsetDateTime workeridmodifiedon;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("_queueid_value")
    protected UUID _queueid_value;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("enteredon")
    protected OffsetDateTime enteredon;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("queueitemid")
    protected UUID queueitemid;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_objectid_value")
    protected UUID _objectid_value;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("objecttypecode")
    protected Integer objecttypecode;

    @JsonProperty("_organizationid_value")
    protected UUID _organizationid_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    protected Queueitem() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderQueueitem() {
        return new Builder();
    }

    public static final class Builder {
        private UUID _transactioncurrencyid_value;
        private UUID _workerid_value;
        private UUID _createdby_value;
        private UUID _modifiedby_value;
        private UUID _owningbusinessunit_value;
        private OffsetDateTime modifiedon;
        private String title;
        private OffsetDateTime workeridmodifiedon;
        private UUID _modifiedonbehalfby_value;
        private Long versionnumber;
        private Integer utcconversiontimezonecode;
        private UUID _queueid_value;
        private Integer statecode;
        private OffsetDateTime enteredon;
        private OffsetDateTime overriddencreatedon;
        private UUID _ownerid_value;
        private Integer importsequencenumber;
        private UUID queueitemid;
        private Integer statuscode;
        private UUID _objectid_value;
        private UUID _owninguser_value;
        private BigDecimal exchangerate;
        private Integer timezoneruleversionnumber;
        private UUID _createdonbehalfby_value;
        private Integer objecttypecode;
        private UUID _organizationid_value;
        private OffsetDateTime createdon;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder _workerid_value(UUID _workerid_value) {
            this._workerid_value = _workerid_value;
            this.changedFields = changedFields.add("_workerid_value");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public Builder workeridmodifiedon(OffsetDateTime workeridmodifiedon) {
            this.workeridmodifiedon = workeridmodifiedon;
            this.changedFields = changedFields.add("workeridmodifiedon");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder _queueid_value(UUID _queueid_value) {
            this._queueid_value = _queueid_value;
            this.changedFields = changedFields.add("_queueid_value");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder enteredon(OffsetDateTime enteredon) {
            this.enteredon = enteredon;
            this.changedFields = changedFields.add("enteredon");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder queueitemid(UUID queueitemid) {
            this.queueitemid = queueitemid;
            this.changedFields = changedFields.add("queueitemid");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _objectid_value(UUID _objectid_value) {
            this._objectid_value = _objectid_value;
            this.changedFields = changedFields.add("_objectid_value");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder objecttypecode(Integer objecttypecode) {
            this.objecttypecode = objecttypecode;
            this.changedFields = changedFields.add("objecttypecode");
            return this;
        }

        public Builder _organizationid_value(UUID _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Queueitem build() {
            Queueitem _x = new Queueitem();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.queueitem";
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x._workerid_value = _workerid_value;
            _x._createdby_value = _createdby_value;
            _x._modifiedby_value = _modifiedby_value;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.modifiedon = modifiedon;
            _x.title = title;
            _x.workeridmodifiedon = workeridmodifiedon;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.versionnumber = versionnumber;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x._queueid_value = _queueid_value;
            _x.statecode = statecode;
            _x.enteredon = enteredon;
            _x.overriddencreatedon = overriddencreatedon;
            _x._ownerid_value = _ownerid_value;
            _x.importsequencenumber = importsequencenumber;
            _x.queueitemid = queueitemid;
            _x.statuscode = statuscode;
            _x._objectid_value = _objectid_value;
            _x._owninguser_value = _owninguser_value;
            _x.exchangerate = exchangerate;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.objecttypecode = objecttypecode;
            _x._organizationid_value = _organizationid_value;
            _x.createdon = createdon;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && queueitemid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(queueitemid, UUID.class));
        }
    }

    @Property(name="_transactioncurrencyid_value")
    @JsonIgnore
    public Optional<UUID> get_transactioncurrencyid_value() {
        return Optional.ofNullable(_transactioncurrencyid_value);
    }

    public Queueitem with_transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
        Queueitem _x = _copy();
        _x.changedFields = changedFields.add("_transactioncurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queueitem");
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    @Property(name="_workerid_value")
    @JsonIgnore
    public Optional<UUID> get_workerid_value() {
        return Optional.ofNullable(_workerid_value);
    }

    public Queueitem with_workerid_value(UUID _workerid_value) {
        Queueitem _x = _copy();
        _x.changedFields = changedFields.add("_workerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queueitem");
        _x._workerid_value = _workerid_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Queueitem with_createdby_value(UUID _createdby_value) {
        Queueitem _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queueitem");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Queueitem with_modifiedby_value(UUID _modifiedby_value) {
        Queueitem _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queueitem");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Queueitem with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Queueitem _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queueitem");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Queueitem withModifiedon(OffsetDateTime modifiedon) {
        Queueitem _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queueitem");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public Queueitem withTitle(String title) {
        Queueitem _x = _copy();
        _x.changedFields = changedFields.add("title");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queueitem");
        _x.title = title;
        return _x;
    }

    @Property(name="workeridmodifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getWorkeridmodifiedon() {
        return Optional.ofNullable(workeridmodifiedon);
    }

    public Queueitem withWorkeridmodifiedon(OffsetDateTime workeridmodifiedon) {
        Queueitem _x = _copy();
        _x.changedFields = changedFields.add("workeridmodifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queueitem");
        _x.workeridmodifiedon = workeridmodifiedon;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Queueitem with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Queueitem _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queueitem");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Queueitem withVersionnumber(Long versionnumber) {
        Queueitem _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queueitem");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Queueitem withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Queueitem _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queueitem");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="_queueid_value")
    @JsonIgnore
    public Optional<UUID> get_queueid_value() {
        return Optional.ofNullable(_queueid_value);
    }

    public Queueitem with_queueid_value(UUID _queueid_value) {
        Queueitem _x = _copy();
        _x.changedFields = changedFields.add("_queueid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queueitem");
        _x._queueid_value = _queueid_value;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Queueitem withStatecode(Integer statecode) {
        Queueitem _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queueitem");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="enteredon")
    @JsonIgnore
    public Optional<OffsetDateTime> getEnteredon() {
        return Optional.ofNullable(enteredon);
    }

    public Queueitem withEnteredon(OffsetDateTime enteredon) {
        Queueitem _x = _copy();
        _x.changedFields = changedFields.add("enteredon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queueitem");
        _x.enteredon = enteredon;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Queueitem withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Queueitem _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queueitem");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Queueitem with_ownerid_value(UUID _ownerid_value) {
        Queueitem _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queueitem");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Queueitem withImportsequencenumber(Integer importsequencenumber) {
        Queueitem _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queueitem");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="queueitemid")
    @JsonIgnore
    public Optional<UUID> getQueueitemid() {
        return Optional.ofNullable(queueitemid);
    }

    public Queueitem withQueueitemid(UUID queueitemid) {
        Queueitem _x = _copy();
        _x.changedFields = changedFields.add("queueitemid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queueitem");
        _x.queueitemid = queueitemid;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Queueitem withStatuscode(Integer statuscode) {
        Queueitem _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queueitem");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_objectid_value")
    @JsonIgnore
    public Optional<UUID> get_objectid_value() {
        return Optional.ofNullable(_objectid_value);
    }

    public Queueitem with_objectid_value(UUID _objectid_value) {
        Queueitem _x = _copy();
        _x.changedFields = changedFields.add("_objectid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queueitem");
        _x._objectid_value = _objectid_value;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Queueitem with_owninguser_value(UUID _owninguser_value) {
        Queueitem _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queueitem");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Queueitem withExchangerate(BigDecimal exchangerate) {
        Queueitem _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queueitem");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Queueitem withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Queueitem _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queueitem");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Queueitem with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Queueitem _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queueitem");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="objecttypecode")
    @JsonIgnore
    public Optional<Integer> getObjecttypecode() {
        return Optional.ofNullable(objecttypecode);
    }

    public Queueitem withObjecttypecode(Integer objecttypecode) {
        Queueitem _x = _copy();
        _x.changedFields = changedFields.add("objecttypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queueitem");
        _x.objecttypecode = objecttypecode;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<UUID> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Queueitem with_organizationid_value(UUID _organizationid_value) {
        Queueitem _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queueitem");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Queueitem withCreatedon(OffsetDateTime createdon) {
        Queueitem _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.queueitem");
        _x.createdon = createdon;
        return _x;
    }

    public Queueitem withUnmappedField(String name, Object value) {
        Queueitem _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="objectid_knowledgearticle")
    @JsonIgnore
    public KnowledgearticleRequest getObjectid_knowledgearticle() {
        return new KnowledgearticleRequest(contextPath.addSegment("objectid_knowledgearticle"), RequestHelper.getValue(unmappedFields, "objectid_knowledgearticle"));
    }

    @NavigationProperty(name="QueueItem_ProcessSessions")
    @JsonIgnore
    public ProcesssessionCollectionRequest getQueueItem_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("QueueItem_ProcessSessions"), RequestHelper.getValue(unmappedFields, "QueueItem_ProcessSessions"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="objectid_appointment")
    @JsonIgnore
    public AppointmentRequest getObjectid_appointment() {
        return new AppointmentRequest(contextPath.addSegment("objectid_appointment"), RequestHelper.getValue(unmappedFields, "objectid_appointment"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="workerid_systemuser")
    @JsonIgnore
    public SystemuserRequest getWorkerid_systemuser() {
        return new SystemuserRequest(contextPath.addSegment("workerid_systemuser"), RequestHelper.getValue(unmappedFields, "workerid_systemuser"));
    }

    @NavigationProperty(name="objectid_activitypointer")
    @JsonIgnore
    public ActivitypointerRequest getObjectid_activitypointer() {
        return new ActivitypointerRequest(contextPath.addSegment("objectid_activitypointer"), RequestHelper.getValue(unmappedFields, "objectid_activitypointer"));
    }

    @NavigationProperty(name="queueid")
    @JsonIgnore
    public QueueRequest getQueueid() {
        return new QueueRequest(contextPath.addSegment("queueid"), RequestHelper.getValue(unmappedFields, "queueid"));
    }

    @NavigationProperty(name="QueueItem_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getQueueItem_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("QueueItem_AsyncOperations"), RequestHelper.getValue(unmappedFields, "QueueItem_AsyncOperations"));
    }

    @NavigationProperty(name="workerid_team")
    @JsonIgnore
    public TeamRequest getWorkerid_team() {
        return new TeamRequest(contextPath.addSegment("workerid_team"), RequestHelper.getValue(unmappedFields, "workerid_team"));
    }

    @NavigationProperty(name="objectid_fax")
    @JsonIgnore
    public FaxRequest getObjectid_fax() {
        return new FaxRequest(contextPath.addSegment("objectid_fax"), RequestHelper.getValue(unmappedFields, "objectid_fax"));
    }

    @NavigationProperty(name="objectid_recurringappointmentmaster")
    @JsonIgnore
    public RecurringappointmentmasterRequest getObjectid_recurringappointmentmaster() {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("objectid_recurringappointmentmaster"), RequestHelper.getValue(unmappedFields, "objectid_recurringappointmentmaster"));
    }

    @NavigationProperty(name="QueueItem_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getQueueItem_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("QueueItem_SyncErrors"), RequestHelper.getValue(unmappedFields, "QueueItem_SyncErrors"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="objectid_letter")
    @JsonIgnore
    public LetterRequest getObjectid_letter() {
        return new LetterRequest(contextPath.addSegment("objectid_letter"), RequestHelper.getValue(unmappedFields, "objectid_letter"));
    }

    @NavigationProperty(name="objectid_socialactivity")
    @JsonIgnore
    public SocialactivityRequest getObjectid_socialactivity() {
        return new SocialactivityRequest(contextPath.addSegment("objectid_socialactivity"), RequestHelper.getValue(unmappedFields, "objectid_socialactivity"));
    }

    @NavigationProperty(name="objectid_phonecall")
    @JsonIgnore
    public PhonecallRequest getObjectid_phonecall() {
        return new PhonecallRequest(contextPath.addSegment("objectid_phonecall"), RequestHelper.getValue(unmappedFields, "objectid_phonecall"));
    }

    @NavigationProperty(name="transactioncurrencyid")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid"));
    }

    @NavigationProperty(name="objectid_task")
    @JsonIgnore
    public TaskRequest getObjectid_task() {
        return new TaskRequest(contextPath.addSegment("objectid_task"), RequestHelper.getValue(unmappedFields, "objectid_task"));
    }

    @NavigationProperty(name="queueitem_principalobjectattributeaccess")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getQueueitem_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("queueitem_principalobjectattributeaccess"), RequestHelper.getValue(unmappedFields, "queueitem_principalobjectattributeaccess"));
    }

    @NavigationProperty(name="QueueItem_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getQueueItem_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("QueueItem_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "QueueItem_BulkDeleteFailures"));
    }

    @NavigationProperty(name="objectid_email")
    @JsonIgnore
    public EmailRequest getObjectid_email() {
        return new EmailRequest(contextPath.addSegment("objectid_email"), RequestHelper.getValue(unmappedFields, "objectid_email"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="objectid_msdyn_knowledgearticletemplate")
    @JsonIgnore
    public Msdyn_knowledgearticletemplateRequest getObjectid_msdyn_knowledgearticletemplate() {
        return new Msdyn_knowledgearticletemplateRequest(contextPath.addSegment("objectid_msdyn_knowledgearticletemplate"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_knowledgearticletemplate"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Queueitem patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Queueitem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Queueitem put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Queueitem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Queueitem _copy() {
        Queueitem _x = new Queueitem();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x._workerid_value = _workerid_value;
        _x._createdby_value = _createdby_value;
        _x._modifiedby_value = _modifiedby_value;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.modifiedon = modifiedon;
        _x.title = title;
        _x.workeridmodifiedon = workeridmodifiedon;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.versionnumber = versionnumber;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x._queueid_value = _queueid_value;
        _x.statecode = statecode;
        _x.enteredon = enteredon;
        _x.overriddencreatedon = overriddencreatedon;
        _x._ownerid_value = _ownerid_value;
        _x.importsequencenumber = importsequencenumber;
        _x.queueitemid = queueitemid;
        _x.statuscode = statuscode;
        _x._objectid_value = _objectid_value;
        _x._owninguser_value = _owninguser_value;
        _x.exchangerate = exchangerate;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.objecttypecode = objecttypecode;
        _x._organizationid_value = _organizationid_value;
        _x.createdon = createdon;
        return _x;
    }

    @Action(name = "PickFromQueue")
    @JsonIgnore
    public ActionRequestNoReturn pickFromQueue(Systemuser systemUser, Boolean removeQueueItem) {
        Preconditions.checkNotNull(systemUser, "systemUser cannot be null");
        Preconditions.checkNotNull(removeQueueItem, "removeQueueItem cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SystemUser", "Microsoft.Dynamics.CRM.systemuser", systemUser)
            .put("RemoveQueueItem", "Edm.Boolean", removeQueueItem)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.PickFromQueue"), _parameters);
    }

    @Action(name = "ReleaseToQueue")
    @JsonIgnore
    public ActionRequestNoReturn releaseToQueue() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ReleaseToQueue"), _parameters);
    }

    @Action(name = "RemoveFromQueue")
    @JsonIgnore
    public ActionRequestNoReturn removeFromQueue() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RemoveFromQueue"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Queueitem[");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("_workerid_value=");
        b.append(this._workerid_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("workeridmodifiedon=");
        b.append(this.workeridmodifiedon);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("_queueid_value=");
        b.append(this._queueid_value);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("enteredon=");
        b.append(this.enteredon);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("queueitemid=");
        b.append(this.queueitemid);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_objectid_value=");
        b.append(this._objectid_value);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("objecttypecode=");
        b.append(this.objecttypecode);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
