package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "timezoneruleversionnumber", 
    "principalobjectaccessid", 
    "changedon", 
    "principalid", 
    "versionnumber", 
    "objecttypecode", 
    "utcconversiontimezonecode", 
    "objectid", 
    "principaltypecode", 
    "inheritedaccessrightsmask", 
    "accessrightsmask"})
@JsonInclude(Include.NON_NULL)
public class Principalobjectaccess extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.principalobjectaccess";
    }

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("principalobjectaccessid")
    protected UUID principalobjectaccessid;

    @JsonProperty("changedon")
    protected OffsetDateTime changedon;

    @JsonProperty("principalid")
    protected UUID principalid;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("objecttypecode")
    protected String objecttypecode;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("objectid")
    protected UUID objectid;

    @JsonProperty("principaltypecode")
    protected String principaltypecode;

    @JsonProperty("inheritedaccessrightsmask")
    protected Integer inheritedaccessrightsmask;

    @JsonProperty("accessrightsmask")
    protected Integer accessrightsmask;

    protected Principalobjectaccess() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPrincipalobjectaccess() {
        return new Builder();
    }

    public static final class Builder {
        private Integer timezoneruleversionnumber;
        private UUID principalobjectaccessid;
        private OffsetDateTime changedon;
        private UUID principalid;
        private Long versionnumber;
        private String objecttypecode;
        private Integer utcconversiontimezonecode;
        private UUID objectid;
        private String principaltypecode;
        private Integer inheritedaccessrightsmask;
        private Integer accessrightsmask;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder principalobjectaccessid(UUID principalobjectaccessid) {
            this.principalobjectaccessid = principalobjectaccessid;
            this.changedFields = changedFields.add("principalobjectaccessid");
            return this;
        }

        public Builder changedon(OffsetDateTime changedon) {
            this.changedon = changedon;
            this.changedFields = changedFields.add("changedon");
            return this;
        }

        public Builder principalid(UUID principalid) {
            this.principalid = principalid;
            this.changedFields = changedFields.add("principalid");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder objecttypecode(String objecttypecode) {
            this.objecttypecode = objecttypecode;
            this.changedFields = changedFields.add("objecttypecode");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder objectid(UUID objectid) {
            this.objectid = objectid;
            this.changedFields = changedFields.add("objectid");
            return this;
        }

        public Builder principaltypecode(String principaltypecode) {
            this.principaltypecode = principaltypecode;
            this.changedFields = changedFields.add("principaltypecode");
            return this;
        }

        public Builder inheritedaccessrightsmask(Integer inheritedaccessrightsmask) {
            this.inheritedaccessrightsmask = inheritedaccessrightsmask;
            this.changedFields = changedFields.add("inheritedaccessrightsmask");
            return this;
        }

        public Builder accessrightsmask(Integer accessrightsmask) {
            this.accessrightsmask = accessrightsmask;
            this.changedFields = changedFields.add("accessrightsmask");
            return this;
        }

        public Principalobjectaccess build() {
            Principalobjectaccess _x = new Principalobjectaccess();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.principalobjectaccess";
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.principalobjectaccessid = principalobjectaccessid;
            _x.changedon = changedon;
            _x.principalid = principalid;
            _x.versionnumber = versionnumber;
            _x.objecttypecode = objecttypecode;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.objectid = objectid;
            _x.principaltypecode = principaltypecode;
            _x.inheritedaccessrightsmask = inheritedaccessrightsmask;
            _x.accessrightsmask = accessrightsmask;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && principalobjectaccessid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(principalobjectaccessid, UUID.class));
        }
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Principalobjectaccess withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Principalobjectaccess _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.principalobjectaccess");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="principalobjectaccessid")
    @JsonIgnore
    public Optional<UUID> getPrincipalobjectaccessid() {
        return Optional.ofNullable(principalobjectaccessid);
    }

    public Principalobjectaccess withPrincipalobjectaccessid(UUID principalobjectaccessid) {
        Principalobjectaccess _x = _copy();
        _x.changedFields = changedFields.add("principalobjectaccessid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.principalobjectaccess");
        _x.principalobjectaccessid = principalobjectaccessid;
        return _x;
    }

    @Property(name="changedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getChangedon() {
        return Optional.ofNullable(changedon);
    }

    public Principalobjectaccess withChangedon(OffsetDateTime changedon) {
        Principalobjectaccess _x = _copy();
        _x.changedFields = changedFields.add("changedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.principalobjectaccess");
        _x.changedon = changedon;
        return _x;
    }

    @Property(name="principalid")
    @JsonIgnore
    public Optional<UUID> getPrincipalid() {
        return Optional.ofNullable(principalid);
    }

    public Principalobjectaccess withPrincipalid(UUID principalid) {
        Principalobjectaccess _x = _copy();
        _x.changedFields = changedFields.add("principalid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.principalobjectaccess");
        _x.principalid = principalid;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Principalobjectaccess withVersionnumber(Long versionnumber) {
        Principalobjectaccess _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.principalobjectaccess");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="objecttypecode")
    @JsonIgnore
    public Optional<String> getObjecttypecode() {
        return Optional.ofNullable(objecttypecode);
    }

    public Principalobjectaccess withObjecttypecode(String objecttypecode) {
        Principalobjectaccess _x = _copy();
        _x.changedFields = changedFields.add("objecttypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.principalobjectaccess");
        _x.objecttypecode = objecttypecode;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Principalobjectaccess withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Principalobjectaccess _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.principalobjectaccess");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="objectid")
    @JsonIgnore
    public Optional<UUID> getObjectid() {
        return Optional.ofNullable(objectid);
    }

    public Principalobjectaccess withObjectid(UUID objectid) {
        Principalobjectaccess _x = _copy();
        _x.changedFields = changedFields.add("objectid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.principalobjectaccess");
        _x.objectid = objectid;
        return _x;
    }

    @Property(name="principaltypecode")
    @JsonIgnore
    public Optional<String> getPrincipaltypecode() {
        return Optional.ofNullable(principaltypecode);
    }

    public Principalobjectaccess withPrincipaltypecode(String principaltypecode) {
        Principalobjectaccess _x = _copy();
        _x.changedFields = changedFields.add("principaltypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.principalobjectaccess");
        _x.principaltypecode = principaltypecode;
        return _x;
    }

    @Property(name="inheritedaccessrightsmask")
    @JsonIgnore
    public Optional<Integer> getInheritedaccessrightsmask() {
        return Optional.ofNullable(inheritedaccessrightsmask);
    }

    public Principalobjectaccess withInheritedaccessrightsmask(Integer inheritedaccessrightsmask) {
        Principalobjectaccess _x = _copy();
        _x.changedFields = changedFields.add("inheritedaccessrightsmask");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.principalobjectaccess");
        _x.inheritedaccessrightsmask = inheritedaccessrightsmask;
        return _x;
    }

    @Property(name="accessrightsmask")
    @JsonIgnore
    public Optional<Integer> getAccessrightsmask() {
        return Optional.ofNullable(accessrightsmask);
    }

    public Principalobjectaccess withAccessrightsmask(Integer accessrightsmask) {
        Principalobjectaccess _x = _copy();
        _x.changedFields = changedFields.add("accessrightsmask");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.principalobjectaccess");
        _x.accessrightsmask = accessrightsmask;
        return _x;
    }

    public Principalobjectaccess withUnmappedField(String name, Object value) {
        Principalobjectaccess _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Principalobjectaccess patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Principalobjectaccess _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Principalobjectaccess put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Principalobjectaccess _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Principalobjectaccess _copy() {
        Principalobjectaccess _x = new Principalobjectaccess();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.principalobjectaccessid = principalobjectaccessid;
        _x.changedon = changedon;
        _x.principalid = principalid;
        _x.versionnumber = versionnumber;
        _x.objecttypecode = objecttypecode;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.objectid = objectid;
        _x.principaltypecode = principaltypecode;
        _x.inheritedaccessrightsmask = inheritedaccessrightsmask;
        _x.accessrightsmask = accessrightsmask;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Principalobjectaccess[");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("principalobjectaccessid=");
        b.append(this.principalobjectaccessid);
        b.append(", ");
        b.append("changedon=");
        b.append(this.changedon);
        b.append(", ");
        b.append("principalid=");
        b.append(this.principalid);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("objecttypecode=");
        b.append(this.objecttypecode);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("objectid=");
        b.append(this.objectid);
        b.append(", ");
        b.append("principaltypecode=");
        b.append(this.principaltypecode);
        b.append(", ");
        b.append("inheritedaccessrightsmask=");
        b.append(this.inheritedaccessrightsmask);
        b.append(", ");
        b.append("accessrightsmask=");
        b.append(this.accessrightsmask);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
