package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.AssociatedMenuConfiguration;
import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.complex.CascadeConfiguration;
import microsoft.dynamics.crm.complex.RelationshipAttribute;
import microsoft.dynamics.crm.entity.request.LookupAttributeMetadataRequest;
import microsoft.dynamics.crm.enums.RelationshipType;
import microsoft.dynamics.crm.enums.SecurityTypes;

@JsonPropertyOrder({
    "@odata.type", 
    "AssociatedMenuConfiguration", 
    "CascadeConfiguration", 
    "ReferencedAttribute", 
    "ReferencedEntity", 
    "ReferencingAttribute", 
    "ReferencingEntity", 
    "IsHierarchical", 
    "EntityKey", 
    "RelationshipAttributes", 
    "ReferencedEntityNavigationPropertyName", 
    "ReferencingEntityNavigationPropertyName", 
    "RelationshipBehavior", 
    "Lookup"})
@JsonInclude(Include.NON_NULL)
public class OneToManyRelationshipMetadata extends RelationshipMetadataBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.OneToManyRelationshipMetadata";
    }

    @JsonProperty("AssociatedMenuConfiguration")
    protected AssociatedMenuConfiguration associatedMenuConfiguration;

    @JsonProperty("CascadeConfiguration")
    protected CascadeConfiguration cascadeConfiguration;

    @JsonProperty("ReferencedAttribute")
    protected String referencedAttribute;

    @JsonProperty("ReferencedEntity")
    protected String referencedEntity;

    @JsonProperty("ReferencingAttribute")
    protected String referencingAttribute;

    @JsonProperty("ReferencingEntity")
    protected String referencingEntity;

    @JsonProperty("IsHierarchical")
    protected Boolean isHierarchical;

    @JsonProperty("EntityKey")
    protected String entityKey;

    @JsonProperty("RelationshipAttributes")
    protected List<RelationshipAttribute> relationshipAttributes;

    @JsonProperty("RelationshipAttributes@nextLink")
    protected String relationshipAttributesNextLink;

    @JsonProperty("ReferencedEntityNavigationPropertyName")
    protected String referencedEntityNavigationPropertyName;

    @JsonProperty("ReferencingEntityNavigationPropertyName")
    protected String referencingEntityNavigationPropertyName;

    @JsonProperty("RelationshipBehavior")
    protected Integer relationshipBehavior;

    @JsonProperty("Lookup")
    protected LookupAttributeMetadata lookup;

    protected OneToManyRelationshipMetadata() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOneToManyRelationshipMetadata() {
        return new Builder();
    }

    public static final class Builder {
        private UUID metadataId;
        private Boolean hasChanged;
        private Boolean isCustomRelationship;
        private BooleanManagedProperty isCustomizable;
        private Boolean isValidForAdvancedFind;
        private String schemaName;
        private SecurityTypes securityTypes;
        private Boolean isManaged;
        private RelationshipType relationshipType;
        private String introducedVersion;
        private AssociatedMenuConfiguration associatedMenuConfiguration;
        private CascadeConfiguration cascadeConfiguration;
        private String referencedAttribute;
        private String referencedEntity;
        private String referencingAttribute;
        private String referencingEntity;
        private Boolean isHierarchical;
        private String entityKey;
        private List<RelationshipAttribute> relationshipAttributes;
        private String relationshipAttributesNextLink;
        private String referencedEntityNavigationPropertyName;
        private String referencingEntityNavigationPropertyName;
        private Integer relationshipBehavior;
        private LookupAttributeMetadata lookup;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder metadataId(UUID metadataId) {
            this.metadataId = metadataId;
            this.changedFields = changedFields.add("MetadataId");
            return this;
        }

        public Builder hasChanged(Boolean hasChanged) {
            this.hasChanged = hasChanged;
            this.changedFields = changedFields.add("HasChanged");
            return this;
        }

        public Builder isCustomRelationship(Boolean isCustomRelationship) {
            this.isCustomRelationship = isCustomRelationship;
            this.changedFields = changedFields.add("IsCustomRelationship");
            return this;
        }

        public Builder isCustomizable(BooleanManagedProperty isCustomizable) {
            this.isCustomizable = isCustomizable;
            this.changedFields = changedFields.add("IsCustomizable");
            return this;
        }

        public Builder isValidForAdvancedFind(Boolean isValidForAdvancedFind) {
            this.isValidForAdvancedFind = isValidForAdvancedFind;
            this.changedFields = changedFields.add("IsValidForAdvancedFind");
            return this;
        }

        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            this.changedFields = changedFields.add("SchemaName");
            return this;
        }

        public Builder securityTypes(SecurityTypes securityTypes) {
            this.securityTypes = securityTypes;
            this.changedFields = changedFields.add("SecurityTypes");
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.isManaged = isManaged;
            this.changedFields = changedFields.add("IsManaged");
            return this;
        }

        public Builder relationshipType(RelationshipType relationshipType) {
            this.relationshipType = relationshipType;
            this.changedFields = changedFields.add("RelationshipType");
            return this;
        }

        public Builder introducedVersion(String introducedVersion) {
            this.introducedVersion = introducedVersion;
            this.changedFields = changedFields.add("IntroducedVersion");
            return this;
        }

        public Builder associatedMenuConfiguration(AssociatedMenuConfiguration associatedMenuConfiguration) {
            this.associatedMenuConfiguration = associatedMenuConfiguration;
            this.changedFields = changedFields.add("AssociatedMenuConfiguration");
            return this;
        }

        public Builder cascadeConfiguration(CascadeConfiguration cascadeConfiguration) {
            this.cascadeConfiguration = cascadeConfiguration;
            this.changedFields = changedFields.add("CascadeConfiguration");
            return this;
        }

        public Builder referencedAttribute(String referencedAttribute) {
            this.referencedAttribute = referencedAttribute;
            this.changedFields = changedFields.add("ReferencedAttribute");
            return this;
        }

        public Builder referencedEntity(String referencedEntity) {
            this.referencedEntity = referencedEntity;
            this.changedFields = changedFields.add("ReferencedEntity");
            return this;
        }

        public Builder referencingAttribute(String referencingAttribute) {
            this.referencingAttribute = referencingAttribute;
            this.changedFields = changedFields.add("ReferencingAttribute");
            return this;
        }

        public Builder referencingEntity(String referencingEntity) {
            this.referencingEntity = referencingEntity;
            this.changedFields = changedFields.add("ReferencingEntity");
            return this;
        }

        public Builder isHierarchical(Boolean isHierarchical) {
            this.isHierarchical = isHierarchical;
            this.changedFields = changedFields.add("IsHierarchical");
            return this;
        }

        public Builder entityKey(String entityKey) {
            this.entityKey = entityKey;
            this.changedFields = changedFields.add("EntityKey");
            return this;
        }

        public Builder relationshipAttributes(List<RelationshipAttribute> relationshipAttributes) {
            this.relationshipAttributes = relationshipAttributes;
            this.changedFields = changedFields.add("RelationshipAttributes");
            return this;
        }

        public Builder relationshipAttributes(RelationshipAttribute... relationshipAttributes) {
            return relationshipAttributes(Arrays.asList(relationshipAttributes));
        }

        public Builder relationshipAttributesNextLink(String relationshipAttributesNextLink) {
            this.relationshipAttributesNextLink = relationshipAttributesNextLink;
            this.changedFields = changedFields.add("RelationshipAttributes");
            return this;
        }

        public Builder referencedEntityNavigationPropertyName(String referencedEntityNavigationPropertyName) {
            this.referencedEntityNavigationPropertyName = referencedEntityNavigationPropertyName;
            this.changedFields = changedFields.add("ReferencedEntityNavigationPropertyName");
            return this;
        }

        public Builder referencingEntityNavigationPropertyName(String referencingEntityNavigationPropertyName) {
            this.referencingEntityNavigationPropertyName = referencingEntityNavigationPropertyName;
            this.changedFields = changedFields.add("ReferencingEntityNavigationPropertyName");
            return this;
        }

        public Builder relationshipBehavior(Integer relationshipBehavior) {
            this.relationshipBehavior = relationshipBehavior;
            this.changedFields = changedFields.add("RelationshipBehavior");
            return this;
        }

        public Builder lookup(LookupAttributeMetadata lookup) {
            this.lookup = lookup;
            this.changedFields = changedFields.add("Lookup");
            return this;
        }

        public OneToManyRelationshipMetadata build() {
            OneToManyRelationshipMetadata _x = new OneToManyRelationshipMetadata();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.OneToManyRelationshipMetadata";
            _x.metadataId = metadataId;
            _x.hasChanged = hasChanged;
            _x.isCustomRelationship = isCustomRelationship;
            _x.isCustomizable = isCustomizable;
            _x.isValidForAdvancedFind = isValidForAdvancedFind;
            _x.schemaName = schemaName;
            _x.securityTypes = securityTypes;
            _x.isManaged = isManaged;
            _x.relationshipType = relationshipType;
            _x.introducedVersion = introducedVersion;
            _x.associatedMenuConfiguration = associatedMenuConfiguration;
            _x.cascadeConfiguration = cascadeConfiguration;
            _x.referencedAttribute = referencedAttribute;
            _x.referencedEntity = referencedEntity;
            _x.referencingAttribute = referencingAttribute;
            _x.referencingEntity = referencingEntity;
            _x.isHierarchical = isHierarchical;
            _x.entityKey = entityKey;
            _x.relationshipAttributes = relationshipAttributes;
            _x.relationshipAttributesNextLink = relationshipAttributesNextLink;
            _x.referencedEntityNavigationPropertyName = referencedEntityNavigationPropertyName;
            _x.referencingEntityNavigationPropertyName = referencingEntityNavigationPropertyName;
            _x.relationshipBehavior = relationshipBehavior;
            _x.lookup = lookup;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && metadataId != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(metadataId, UUID.class));
        }
    }

    @Property(name="AssociatedMenuConfiguration")
    @JsonIgnore
    public Optional<AssociatedMenuConfiguration> getAssociatedMenuConfiguration() {
        return Optional.ofNullable(associatedMenuConfiguration);
    }

    public OneToManyRelationshipMetadata withAssociatedMenuConfiguration(AssociatedMenuConfiguration associatedMenuConfiguration) {
        OneToManyRelationshipMetadata _x = _copy();
        _x.changedFields = changedFields.add("AssociatedMenuConfiguration");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OneToManyRelationshipMetadata");
        _x.associatedMenuConfiguration = associatedMenuConfiguration;
        return _x;
    }

    @Property(name="CascadeConfiguration")
    @JsonIgnore
    public Optional<CascadeConfiguration> getCascadeConfiguration() {
        return Optional.ofNullable(cascadeConfiguration);
    }

    public OneToManyRelationshipMetadata withCascadeConfiguration(CascadeConfiguration cascadeConfiguration) {
        OneToManyRelationshipMetadata _x = _copy();
        _x.changedFields = changedFields.add("CascadeConfiguration");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OneToManyRelationshipMetadata");
        _x.cascadeConfiguration = cascadeConfiguration;
        return _x;
    }

    @Property(name="ReferencedAttribute")
    @JsonIgnore
    public Optional<String> getReferencedAttribute() {
        return Optional.ofNullable(referencedAttribute);
    }

    public OneToManyRelationshipMetadata withReferencedAttribute(String referencedAttribute) {
        OneToManyRelationshipMetadata _x = _copy();
        _x.changedFields = changedFields.add("ReferencedAttribute");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OneToManyRelationshipMetadata");
        _x.referencedAttribute = referencedAttribute;
        return _x;
    }

    @Property(name="ReferencedEntity")
    @JsonIgnore
    public Optional<String> getReferencedEntity() {
        return Optional.ofNullable(referencedEntity);
    }

    public OneToManyRelationshipMetadata withReferencedEntity(String referencedEntity) {
        OneToManyRelationshipMetadata _x = _copy();
        _x.changedFields = changedFields.add("ReferencedEntity");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OneToManyRelationshipMetadata");
        _x.referencedEntity = referencedEntity;
        return _x;
    }

    @Property(name="ReferencingAttribute")
    @JsonIgnore
    public Optional<String> getReferencingAttribute() {
        return Optional.ofNullable(referencingAttribute);
    }

    public OneToManyRelationshipMetadata withReferencingAttribute(String referencingAttribute) {
        OneToManyRelationshipMetadata _x = _copy();
        _x.changedFields = changedFields.add("ReferencingAttribute");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OneToManyRelationshipMetadata");
        _x.referencingAttribute = referencingAttribute;
        return _x;
    }

    @Property(name="ReferencingEntity")
    @JsonIgnore
    public Optional<String> getReferencingEntity() {
        return Optional.ofNullable(referencingEntity);
    }

    public OneToManyRelationshipMetadata withReferencingEntity(String referencingEntity) {
        OneToManyRelationshipMetadata _x = _copy();
        _x.changedFields = changedFields.add("ReferencingEntity");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OneToManyRelationshipMetadata");
        _x.referencingEntity = referencingEntity;
        return _x;
    }

    @Property(name="IsHierarchical")
    @JsonIgnore
    public Optional<Boolean> getIsHierarchical() {
        return Optional.ofNullable(isHierarchical);
    }

    public OneToManyRelationshipMetadata withIsHierarchical(Boolean isHierarchical) {
        OneToManyRelationshipMetadata _x = _copy();
        _x.changedFields = changedFields.add("IsHierarchical");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OneToManyRelationshipMetadata");
        _x.isHierarchical = isHierarchical;
        return _x;
    }

    @Property(name="EntityKey")
    @JsonIgnore
    public Optional<String> getEntityKey() {
        return Optional.ofNullable(entityKey);
    }

    public OneToManyRelationshipMetadata withEntityKey(String entityKey) {
        OneToManyRelationshipMetadata _x = _copy();
        _x.changedFields = changedFields.add("EntityKey");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OneToManyRelationshipMetadata");
        _x.entityKey = entityKey;
        return _x;
    }

    @Property(name="RelationshipAttributes")
    @JsonIgnore
    public CollectionPage<RelationshipAttribute> getRelationshipAttributes() {
        return new CollectionPage<RelationshipAttribute>(contextPath, RelationshipAttribute.class, this.relationshipAttributes, Optional.ofNullable(relationshipAttributesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public OneToManyRelationshipMetadata withRelationshipAttributes(List<RelationshipAttribute> relationshipAttributes) {
        OneToManyRelationshipMetadata _x = _copy();
        _x.changedFields = changedFields.add("RelationshipAttributes");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OneToManyRelationshipMetadata");
        _x.relationshipAttributes = relationshipAttributes;
        return _x;
    }

    @Property(name="RelationshipAttributes")
    @JsonIgnore
    public CollectionPage<RelationshipAttribute> getRelationshipAttributes(HttpRequestOptions options) {
        return new CollectionPage<RelationshipAttribute>(contextPath, RelationshipAttribute.class, this.relationshipAttributes, Optional.ofNullable(relationshipAttributesNextLink), Collections.emptyList(), options);
    }

    @Property(name="ReferencedEntityNavigationPropertyName")
    @JsonIgnore
    public Optional<String> getReferencedEntityNavigationPropertyName() {
        return Optional.ofNullable(referencedEntityNavigationPropertyName);
    }

    public OneToManyRelationshipMetadata withReferencedEntityNavigationPropertyName(String referencedEntityNavigationPropertyName) {
        OneToManyRelationshipMetadata _x = _copy();
        _x.changedFields = changedFields.add("ReferencedEntityNavigationPropertyName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OneToManyRelationshipMetadata");
        _x.referencedEntityNavigationPropertyName = referencedEntityNavigationPropertyName;
        return _x;
    }

    @Property(name="ReferencingEntityNavigationPropertyName")
    @JsonIgnore
    public Optional<String> getReferencingEntityNavigationPropertyName() {
        return Optional.ofNullable(referencingEntityNavigationPropertyName);
    }

    public OneToManyRelationshipMetadata withReferencingEntityNavigationPropertyName(String referencingEntityNavigationPropertyName) {
        OneToManyRelationshipMetadata _x = _copy();
        _x.changedFields = changedFields.add("ReferencingEntityNavigationPropertyName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OneToManyRelationshipMetadata");
        _x.referencingEntityNavigationPropertyName = referencingEntityNavigationPropertyName;
        return _x;
    }

    @Property(name="RelationshipBehavior")
    @JsonIgnore
    public Optional<Integer> getRelationshipBehavior() {
        return Optional.ofNullable(relationshipBehavior);
    }

    public OneToManyRelationshipMetadata withRelationshipBehavior(Integer relationshipBehavior) {
        OneToManyRelationshipMetadata _x = _copy();
        _x.changedFields = changedFields.add("RelationshipBehavior");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OneToManyRelationshipMetadata");
        _x.relationshipBehavior = relationshipBehavior;
        return _x;
    }

    public OneToManyRelationshipMetadata withUnmappedField(String name, Object value) {
        OneToManyRelationshipMetadata _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="Lookup")
    @JsonIgnore
    public LookupAttributeMetadataRequest getLookup() {
        return new LookupAttributeMetadataRequest(contextPath.addSegment("Lookup"), Optional.ofNullable(lookup));
    }

    public OneToManyRelationshipMetadata withLookup(LookupAttributeMetadata lookup) {
        OneToManyRelationshipMetadata _x = _copy();
        _x.changedFields = changedFields.add("Lookup");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OneToManyRelationshipMetadata");
        _x.lookup = lookup;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OneToManyRelationshipMetadata patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OneToManyRelationshipMetadata _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OneToManyRelationshipMetadata put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OneToManyRelationshipMetadata _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OneToManyRelationshipMetadata _copy() {
        OneToManyRelationshipMetadata _x = new OneToManyRelationshipMetadata();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.metadataId = metadataId;
        _x.hasChanged = hasChanged;
        _x.isCustomRelationship = isCustomRelationship;
        _x.isCustomizable = isCustomizable;
        _x.isValidForAdvancedFind = isValidForAdvancedFind;
        _x.schemaName = schemaName;
        _x.securityTypes = securityTypes;
        _x.isManaged = isManaged;
        _x.relationshipType = relationshipType;
        _x.introducedVersion = introducedVersion;
        _x.associatedMenuConfiguration = associatedMenuConfiguration;
        _x.cascadeConfiguration = cascadeConfiguration;
        _x.referencedAttribute = referencedAttribute;
        _x.referencedEntity = referencedEntity;
        _x.referencingAttribute = referencingAttribute;
        _x.referencingEntity = referencingEntity;
        _x.isHierarchical = isHierarchical;
        _x.entityKey = entityKey;
        _x.relationshipAttributes = relationshipAttributes;
        _x.referencedEntityNavigationPropertyName = referencedEntityNavigationPropertyName;
        _x.referencingEntityNavigationPropertyName = referencingEntityNavigationPropertyName;
        _x.relationshipBehavior = relationshipBehavior;
        _x.lookup = lookup;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OneToManyRelationshipMetadata[");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("HasChanged=");
        b.append(this.hasChanged);
        b.append(", ");
        b.append("IsCustomRelationship=");
        b.append(this.isCustomRelationship);
        b.append(", ");
        b.append("IsCustomizable=");
        b.append(this.isCustomizable);
        b.append(", ");
        b.append("IsValidForAdvancedFind=");
        b.append(this.isValidForAdvancedFind);
        b.append(", ");
        b.append("SchemaName=");
        b.append(this.schemaName);
        b.append(", ");
        b.append("SecurityTypes=");
        b.append(this.securityTypes);
        b.append(", ");
        b.append("IsManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("RelationshipType=");
        b.append(this.relationshipType);
        b.append(", ");
        b.append("IntroducedVersion=");
        b.append(this.introducedVersion);
        b.append(", ");
        b.append("AssociatedMenuConfiguration=");
        b.append(this.associatedMenuConfiguration);
        b.append(", ");
        b.append("CascadeConfiguration=");
        b.append(this.cascadeConfiguration);
        b.append(", ");
        b.append("ReferencedAttribute=");
        b.append(this.referencedAttribute);
        b.append(", ");
        b.append("ReferencedEntity=");
        b.append(this.referencedEntity);
        b.append(", ");
        b.append("ReferencingAttribute=");
        b.append(this.referencingAttribute);
        b.append(", ");
        b.append("ReferencingEntity=");
        b.append(this.referencingEntity);
        b.append(", ");
        b.append("IsHierarchical=");
        b.append(this.isHierarchical);
        b.append(", ");
        b.append("EntityKey=");
        b.append(this.entityKey);
        b.append(", ");
        b.append("RelationshipAttributes=");
        b.append(this.relationshipAttributes);
        b.append(", ");
        b.append("ReferencedEntityNavigationPropertyName=");
        b.append(this.referencedEntityNavigationPropertyName);
        b.append(", ");
        b.append("ReferencingEntityNavigationPropertyName=");
        b.append(this.referencingEntityNavigationPropertyName);
        b.append(", ");
        b.append("RelationshipBehavior=");
        b.append(this.relationshipBehavior);
        b.append(", ");
        b.append("Lookup=");
        b.append(this.lookup);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
