package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_analysiscomponentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_solutionhealthruleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "msdyn_name", 
    "msdyn_description", 
    "utcconversiontimezonecode", 
    "statecode", 
    "_createdonbehalfby_value", 
    "modifiedon", 
    "timezoneruleversionnumber", 
    "versionnumber", 
    "_organizationid_value", 
    "_createdby_value", 
    "importsequencenumber", 
    "createdon", 
    "_modifiedby_value", 
    "msdyn_uniquename", 
    "overriddencreatedon", 
    "statuscode", 
    "_modifiedonbehalfby_value", 
    "msdyn_solutionhealthrulesetid"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_solutionhealthruleset extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_solutionhealthruleset";
    }

    @JsonProperty("msdyn_name")
    protected String msdyn_name;

    @JsonProperty("msdyn_description")
    protected String msdyn_description;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_organizationid_value")
    protected UUID _organizationid_value;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("msdyn_uniquename")
    protected String msdyn_uniquename;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("msdyn_solutionhealthrulesetid")
    protected UUID msdyn_solutionhealthrulesetid;

    protected Msdyn_solutionhealthruleset() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_solutionhealthruleset() {
        return new Builder();
    }

    public static final class Builder {
        private String msdyn_name;
        private String msdyn_description;
        private Integer utcconversiontimezonecode;
        private Integer statecode;
        private UUID _createdonbehalfby_value;
        private OffsetDateTime modifiedon;
        private Integer timezoneruleversionnumber;
        private Long versionnumber;
        private UUID _organizationid_value;
        private UUID _createdby_value;
        private Integer importsequencenumber;
        private OffsetDateTime createdon;
        private UUID _modifiedby_value;
        private String msdyn_uniquename;
        private OffsetDateTime overriddencreatedon;
        private Integer statuscode;
        private UUID _modifiedonbehalfby_value;
        private UUID msdyn_solutionhealthrulesetid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder msdyn_name(String msdyn_name) {
            this.msdyn_name = msdyn_name;
            this.changedFields = changedFields.add("msdyn_name");
            return this;
        }

        public Builder msdyn_description(String msdyn_description) {
            this.msdyn_description = msdyn_description;
            this.changedFields = changedFields.add("msdyn_description");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _organizationid_value(UUID _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder msdyn_uniquename(String msdyn_uniquename) {
            this.msdyn_uniquename = msdyn_uniquename;
            this.changedFields = changedFields.add("msdyn_uniquename");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder msdyn_solutionhealthrulesetid(UUID msdyn_solutionhealthrulesetid) {
            this.msdyn_solutionhealthrulesetid = msdyn_solutionhealthrulesetid;
            this.changedFields = changedFields.add("msdyn_solutionhealthrulesetid");
            return this;
        }

        public Msdyn_solutionhealthruleset build() {
            Msdyn_solutionhealthruleset _x = new Msdyn_solutionhealthruleset();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_solutionhealthruleset";
            _x.msdyn_name = msdyn_name;
            _x.msdyn_description = msdyn_description;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.statecode = statecode;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.modifiedon = modifiedon;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.versionnumber = versionnumber;
            _x._organizationid_value = _organizationid_value;
            _x._createdby_value = _createdby_value;
            _x.importsequencenumber = importsequencenumber;
            _x.createdon = createdon;
            _x._modifiedby_value = _modifiedby_value;
            _x.msdyn_uniquename = msdyn_uniquename;
            _x.overriddencreatedon = overriddencreatedon;
            _x.statuscode = statuscode;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.msdyn_solutionhealthrulesetid = msdyn_solutionhealthrulesetid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_solutionhealthrulesetid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_solutionhealthrulesetid, UUID.class));
        }
    }

    @Property(name="msdyn_name")
    @JsonIgnore
    public Optional<String> getMsdyn_name() {
        return Optional.ofNullable(msdyn_name);
    }

    public Msdyn_solutionhealthruleset withMsdyn_name(String msdyn_name) {
        Msdyn_solutionhealthruleset _x = _copy();
        _x.changedFields = changedFields.add("msdyn_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthruleset");
        _x.msdyn_name = msdyn_name;
        return _x;
    }

    @Property(name="msdyn_description")
    @JsonIgnore
    public Optional<String> getMsdyn_description() {
        return Optional.ofNullable(msdyn_description);
    }

    public Msdyn_solutionhealthruleset withMsdyn_description(String msdyn_description) {
        Msdyn_solutionhealthruleset _x = _copy();
        _x.changedFields = changedFields.add("msdyn_description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthruleset");
        _x.msdyn_description = msdyn_description;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Msdyn_solutionhealthruleset withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Msdyn_solutionhealthruleset _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthruleset");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Msdyn_solutionhealthruleset withStatecode(Integer statecode) {
        Msdyn_solutionhealthruleset _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthruleset");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Msdyn_solutionhealthruleset with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Msdyn_solutionhealthruleset _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthruleset");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Msdyn_solutionhealthruleset withModifiedon(OffsetDateTime modifiedon) {
        Msdyn_solutionhealthruleset _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthruleset");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Msdyn_solutionhealthruleset withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Msdyn_solutionhealthruleset _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthruleset");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Msdyn_solutionhealthruleset withVersionnumber(Long versionnumber) {
        Msdyn_solutionhealthruleset _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthruleset");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<UUID> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Msdyn_solutionhealthruleset with_organizationid_value(UUID _organizationid_value) {
        Msdyn_solutionhealthruleset _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthruleset");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Msdyn_solutionhealthruleset with_createdby_value(UUID _createdby_value) {
        Msdyn_solutionhealthruleset _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthruleset");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Msdyn_solutionhealthruleset withImportsequencenumber(Integer importsequencenumber) {
        Msdyn_solutionhealthruleset _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthruleset");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Msdyn_solutionhealthruleset withCreatedon(OffsetDateTime createdon) {
        Msdyn_solutionhealthruleset _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthruleset");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Msdyn_solutionhealthruleset with_modifiedby_value(UUID _modifiedby_value) {
        Msdyn_solutionhealthruleset _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthruleset");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="msdyn_uniquename")
    @JsonIgnore
    public Optional<String> getMsdyn_uniquename() {
        return Optional.ofNullable(msdyn_uniquename);
    }

    public Msdyn_solutionhealthruleset withMsdyn_uniquename(String msdyn_uniquename) {
        Msdyn_solutionhealthruleset _x = _copy();
        _x.changedFields = changedFields.add("msdyn_uniquename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthruleset");
        _x.msdyn_uniquename = msdyn_uniquename;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Msdyn_solutionhealthruleset withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Msdyn_solutionhealthruleset _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthruleset");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Msdyn_solutionhealthruleset withStatuscode(Integer statuscode) {
        Msdyn_solutionhealthruleset _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthruleset");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Msdyn_solutionhealthruleset with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Msdyn_solutionhealthruleset _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthruleset");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="msdyn_solutionhealthrulesetid")
    @JsonIgnore
    public Optional<UUID> getMsdyn_solutionhealthrulesetid() {
        return Optional.ofNullable(msdyn_solutionhealthrulesetid);
    }

    public Msdyn_solutionhealthruleset withMsdyn_solutionhealthrulesetid(UUID msdyn_solutionhealthrulesetid) {
        Msdyn_solutionhealthruleset _x = _copy();
        _x.changedFields = changedFields.add("msdyn_solutionhealthrulesetid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthruleset");
        _x.msdyn_solutionhealthrulesetid = msdyn_solutionhealthrulesetid;
        return _x;
    }

    public Msdyn_solutionhealthruleset withUnmappedField(String name, Object value) {
        Msdyn_solutionhealthruleset _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="msdyn_solutionhealthruleset_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getMsdyn_solutionhealthruleset_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("msdyn_solutionhealthruleset_SyncErrors"), RequestHelper.getValue(unmappedFields, "msdyn_solutionhealthruleset_SyncErrors"));
    }

    @NavigationProperty(name="msdyn_solutionhealthruleset_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_solutionhealthruleset_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_solutionhealthruleset_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "msdyn_solutionhealthruleset_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="msdyn_solutionhealthruleset_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_solutionhealthruleset_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_solutionhealthruleset_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "msdyn_solutionhealthruleset_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="msdyn_solutionhealthruleset_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getMsdyn_solutionhealthruleset_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("msdyn_solutionhealthruleset_AsyncOperations"), RequestHelper.getValue(unmappedFields, "msdyn_solutionhealthruleset_AsyncOperations"));
    }

    @NavigationProperty(name="msdyn_solutionhealthruleset_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getMsdyn_solutionhealthruleset_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("msdyn_solutionhealthruleset_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "msdyn_solutionhealthruleset_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="msdyn_solutionhealthruleset_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getMsdyn_solutionhealthruleset_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("msdyn_solutionhealthruleset_ProcessSession"), RequestHelper.getValue(unmappedFields, "msdyn_solutionhealthruleset_ProcessSession"));
    }

    @NavigationProperty(name="msdyn_solutionhealthruleset_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getMsdyn_solutionhealthruleset_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("msdyn_solutionhealthruleset_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "msdyn_solutionhealthruleset_BulkDeleteFailures"));
    }

    @NavigationProperty(name="msdyn_solutionhealthruleset_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getMsdyn_solutionhealthruleset_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("msdyn_solutionhealthruleset_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "msdyn_solutionhealthruleset_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="msdyn_msdyn_solutionhealthruleset_msdyn_analysi")
    @JsonIgnore
    public Msdyn_analysiscomponentCollectionRequest getMsdyn_msdyn_solutionhealthruleset_msdyn_analysi() {
        return new Msdyn_analysiscomponentCollectionRequest(
                        contextPath.addSegment("msdyn_msdyn_solutionhealthruleset_msdyn_analysi"), RequestHelper.getValue(unmappedFields, "msdyn_msdyn_solutionhealthruleset_msdyn_analysi"));
    }

    @NavigationProperty(name="msdyn_msdyn_solutionhealthruleset_msdyn_solutio")
    @JsonIgnore
    public Msdyn_solutionhealthruleCollectionRequest getMsdyn_msdyn_solutionhealthruleset_msdyn_solutio() {
        return new Msdyn_solutionhealthruleCollectionRequest(
                        contextPath.addSegment("msdyn_msdyn_solutionhealthruleset_msdyn_solutio"), RequestHelper.getValue(unmappedFields, "msdyn_msdyn_solutionhealthruleset_msdyn_solutio"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_solutionhealthruleset patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_solutionhealthruleset _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_solutionhealthruleset put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_solutionhealthruleset _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_solutionhealthruleset _copy() {
        Msdyn_solutionhealthruleset _x = new Msdyn_solutionhealthruleset();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.msdyn_name = msdyn_name;
        _x.msdyn_description = msdyn_description;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.statecode = statecode;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.modifiedon = modifiedon;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.versionnumber = versionnumber;
        _x._organizationid_value = _organizationid_value;
        _x._createdby_value = _createdby_value;
        _x.importsequencenumber = importsequencenumber;
        _x.createdon = createdon;
        _x._modifiedby_value = _modifiedby_value;
        _x.msdyn_uniquename = msdyn_uniquename;
        _x.overriddencreatedon = overriddencreatedon;
        _x.statuscode = statuscode;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.msdyn_solutionhealthrulesetid = msdyn_solutionhealthrulesetid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_solutionhealthruleset[");
        b.append("msdyn_name=");
        b.append(this.msdyn_name);
        b.append(", ");
        b.append("msdyn_description=");
        b.append(this.msdyn_description);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("msdyn_uniquename=");
        b.append(this.msdyn_uniquename);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("msdyn_solutionhealthrulesetid=");
        b.append(this.msdyn_solutionhealthrulesetid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
