package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_solutionhealthruleargumentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhealthrulesetRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.entity.request.WorkflowRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "createdon", 
    "_msdyn_solutionhealthrulesetid_value", 
    "_owningbusinessunit_value", 
    "_modifiedby_value", 
    "_msdyn_resolutionaction_value", 
    "versionnumber", 
    "importsequencenumber", 
    "_msdyn_workflow_value", 
    "statuscode", 
    "utcconversiontimezonecode", 
    "modifiedon", 
    "msdyn_description", 
    "_createdonbehalfby_value", 
    "overriddencreatedon", 
    "_owningteam_value", 
    "_owninguser_value", 
    "msdyn_name", 
    "timezoneruleversionnumber", 
    "_createdby_value", 
    "_ownerid_value", 
    "msdyn_resolutionmessage", 
    "_modifiedonbehalfby_value", 
    "msdyn_solutionhealthruleid", 
    "msdyn_uniquename", 
    "msdyn_owningsolutionid", 
    "statecode"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_solutionhealthrule extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule";
    }

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_msdyn_solutionhealthrulesetid_value")
    protected UUID _msdyn_solutionhealthrulesetid_value;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("_msdyn_resolutionaction_value")
    protected UUID _msdyn_resolutionaction_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("_msdyn_workflow_value")
    protected UUID _msdyn_workflow_value;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("msdyn_description")
    protected String msdyn_description;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("msdyn_name")
    protected String msdyn_name;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("msdyn_resolutionmessage")
    protected String msdyn_resolutionmessage;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("msdyn_solutionhealthruleid")
    protected UUID msdyn_solutionhealthruleid;

    @JsonProperty("msdyn_uniquename")
    protected String msdyn_uniquename;

    @JsonProperty("msdyn_owningsolutionid")
    protected String msdyn_owningsolutionid;

    @JsonProperty("statecode")
    protected Integer statecode;

    protected Msdyn_solutionhealthrule() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_solutionhealthrule() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime createdon;
        private UUID _msdyn_solutionhealthrulesetid_value;
        private UUID _owningbusinessunit_value;
        private UUID _modifiedby_value;
        private UUID _msdyn_resolutionaction_value;
        private Long versionnumber;
        private Integer importsequencenumber;
        private UUID _msdyn_workflow_value;
        private Integer statuscode;
        private Integer utcconversiontimezonecode;
        private OffsetDateTime modifiedon;
        private String msdyn_description;
        private UUID _createdonbehalfby_value;
        private OffsetDateTime overriddencreatedon;
        private UUID _owningteam_value;
        private UUID _owninguser_value;
        private String msdyn_name;
        private Integer timezoneruleversionnumber;
        private UUID _createdby_value;
        private UUID _ownerid_value;
        private String msdyn_resolutionmessage;
        private UUID _modifiedonbehalfby_value;
        private UUID msdyn_solutionhealthruleid;
        private String msdyn_uniquename;
        private String msdyn_owningsolutionid;
        private Integer statecode;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _msdyn_solutionhealthrulesetid_value(UUID _msdyn_solutionhealthrulesetid_value) {
            this._msdyn_solutionhealthrulesetid_value = _msdyn_solutionhealthrulesetid_value;
            this.changedFields = changedFields.add("_msdyn_solutionhealthrulesetid_value");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _msdyn_resolutionaction_value(UUID _msdyn_resolutionaction_value) {
            this._msdyn_resolutionaction_value = _msdyn_resolutionaction_value;
            this.changedFields = changedFields.add("_msdyn_resolutionaction_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder _msdyn_workflow_value(UUID _msdyn_workflow_value) {
            this._msdyn_workflow_value = _msdyn_workflow_value;
            this.changedFields = changedFields.add("_msdyn_workflow_value");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder msdyn_description(String msdyn_description) {
            this.msdyn_description = msdyn_description;
            this.changedFields = changedFields.add("msdyn_description");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder msdyn_name(String msdyn_name) {
            this.msdyn_name = msdyn_name;
            this.changedFields = changedFields.add("msdyn_name");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder msdyn_resolutionmessage(String msdyn_resolutionmessage) {
            this.msdyn_resolutionmessage = msdyn_resolutionmessage;
            this.changedFields = changedFields.add("msdyn_resolutionmessage");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder msdyn_solutionhealthruleid(UUID msdyn_solutionhealthruleid) {
            this.msdyn_solutionhealthruleid = msdyn_solutionhealthruleid;
            this.changedFields = changedFields.add("msdyn_solutionhealthruleid");
            return this;
        }

        public Builder msdyn_uniquename(String msdyn_uniquename) {
            this.msdyn_uniquename = msdyn_uniquename;
            this.changedFields = changedFields.add("msdyn_uniquename");
            return this;
        }

        public Builder msdyn_owningsolutionid(String msdyn_owningsolutionid) {
            this.msdyn_owningsolutionid = msdyn_owningsolutionid;
            this.changedFields = changedFields.add("msdyn_owningsolutionid");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Msdyn_solutionhealthrule build() {
            Msdyn_solutionhealthrule _x = new Msdyn_solutionhealthrule();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule";
            _x.createdon = createdon;
            _x._msdyn_solutionhealthrulesetid_value = _msdyn_solutionhealthrulesetid_value;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x._modifiedby_value = _modifiedby_value;
            _x._msdyn_resolutionaction_value = _msdyn_resolutionaction_value;
            _x.versionnumber = versionnumber;
            _x.importsequencenumber = importsequencenumber;
            _x._msdyn_workflow_value = _msdyn_workflow_value;
            _x.statuscode = statuscode;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.modifiedon = modifiedon;
            _x.msdyn_description = msdyn_description;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.overriddencreatedon = overriddencreatedon;
            _x._owningteam_value = _owningteam_value;
            _x._owninguser_value = _owninguser_value;
            _x.msdyn_name = msdyn_name;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x._createdby_value = _createdby_value;
            _x._ownerid_value = _ownerid_value;
            _x.msdyn_resolutionmessage = msdyn_resolutionmessage;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.msdyn_solutionhealthruleid = msdyn_solutionhealthruleid;
            _x.msdyn_uniquename = msdyn_uniquename;
            _x.msdyn_owningsolutionid = msdyn_owningsolutionid;
            _x.statecode = statecode;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_solutionhealthruleid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_solutionhealthruleid, UUID.class));
        }
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Msdyn_solutionhealthrule withCreatedon(OffsetDateTime createdon) {
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_msdyn_solutionhealthrulesetid_value")
    @JsonIgnore
    public Optional<UUID> get_msdyn_solutionhealthrulesetid_value() {
        return Optional.ofNullable(_msdyn_solutionhealthrulesetid_value);
    }

    public Msdyn_solutionhealthrule with_msdyn_solutionhealthrulesetid_value(UUID _msdyn_solutionhealthrulesetid_value) {
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = changedFields.add("_msdyn_solutionhealthrulesetid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule");
        _x._msdyn_solutionhealthrulesetid_value = _msdyn_solutionhealthrulesetid_value;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Msdyn_solutionhealthrule with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Msdyn_solutionhealthrule with_modifiedby_value(UUID _modifiedby_value) {
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_msdyn_resolutionaction_value")
    @JsonIgnore
    public Optional<UUID> get_msdyn_resolutionaction_value() {
        return Optional.ofNullable(_msdyn_resolutionaction_value);
    }

    public Msdyn_solutionhealthrule with_msdyn_resolutionaction_value(UUID _msdyn_resolutionaction_value) {
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = changedFields.add("_msdyn_resolutionaction_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule");
        _x._msdyn_resolutionaction_value = _msdyn_resolutionaction_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Msdyn_solutionhealthrule withVersionnumber(Long versionnumber) {
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Msdyn_solutionhealthrule withImportsequencenumber(Integer importsequencenumber) {
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="_msdyn_workflow_value")
    @JsonIgnore
    public Optional<UUID> get_msdyn_workflow_value() {
        return Optional.ofNullable(_msdyn_workflow_value);
    }

    public Msdyn_solutionhealthrule with_msdyn_workflow_value(UUID _msdyn_workflow_value) {
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = changedFields.add("_msdyn_workflow_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule");
        _x._msdyn_workflow_value = _msdyn_workflow_value;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Msdyn_solutionhealthrule withStatuscode(Integer statuscode) {
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Msdyn_solutionhealthrule withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Msdyn_solutionhealthrule withModifiedon(OffsetDateTime modifiedon) {
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="msdyn_description")
    @JsonIgnore
    public Optional<String> getMsdyn_description() {
        return Optional.ofNullable(msdyn_description);
    }

    public Msdyn_solutionhealthrule withMsdyn_description(String msdyn_description) {
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = changedFields.add("msdyn_description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule");
        _x.msdyn_description = msdyn_description;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Msdyn_solutionhealthrule with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Msdyn_solutionhealthrule withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Msdyn_solutionhealthrule with_owningteam_value(UUID _owningteam_value) {
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Msdyn_solutionhealthrule with_owninguser_value(UUID _owninguser_value) {
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="msdyn_name")
    @JsonIgnore
    public Optional<String> getMsdyn_name() {
        return Optional.ofNullable(msdyn_name);
    }

    public Msdyn_solutionhealthrule withMsdyn_name(String msdyn_name) {
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = changedFields.add("msdyn_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule");
        _x.msdyn_name = msdyn_name;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Msdyn_solutionhealthrule withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Msdyn_solutionhealthrule with_createdby_value(UUID _createdby_value) {
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Msdyn_solutionhealthrule with_ownerid_value(UUID _ownerid_value) {
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="msdyn_resolutionmessage")
    @JsonIgnore
    public Optional<String> getMsdyn_resolutionmessage() {
        return Optional.ofNullable(msdyn_resolutionmessage);
    }

    public Msdyn_solutionhealthrule withMsdyn_resolutionmessage(String msdyn_resolutionmessage) {
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = changedFields.add("msdyn_resolutionmessage");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule");
        _x.msdyn_resolutionmessage = msdyn_resolutionmessage;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Msdyn_solutionhealthrule with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="msdyn_solutionhealthruleid")
    @JsonIgnore
    public Optional<UUID> getMsdyn_solutionhealthruleid() {
        return Optional.ofNullable(msdyn_solutionhealthruleid);
    }

    public Msdyn_solutionhealthrule withMsdyn_solutionhealthruleid(UUID msdyn_solutionhealthruleid) {
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = changedFields.add("msdyn_solutionhealthruleid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule");
        _x.msdyn_solutionhealthruleid = msdyn_solutionhealthruleid;
        return _x;
    }

    @Property(name="msdyn_uniquename")
    @JsonIgnore
    public Optional<String> getMsdyn_uniquename() {
        return Optional.ofNullable(msdyn_uniquename);
    }

    public Msdyn_solutionhealthrule withMsdyn_uniquename(String msdyn_uniquename) {
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = changedFields.add("msdyn_uniquename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule");
        _x.msdyn_uniquename = msdyn_uniquename;
        return _x;
    }

    @Property(name="msdyn_owningsolutionid")
    @JsonIgnore
    public Optional<String> getMsdyn_owningsolutionid() {
        return Optional.ofNullable(msdyn_owningsolutionid);
    }

    public Msdyn_solutionhealthrule withMsdyn_owningsolutionid(String msdyn_owningsolutionid) {
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = changedFields.add("msdyn_owningsolutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule");
        _x.msdyn_owningsolutionid = msdyn_owningsolutionid;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Msdyn_solutionhealthrule withStatecode(Integer statecode) {
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhealthrule");
        _x.statecode = statecode;
        return _x;
    }

    public Msdyn_solutionhealthrule withUnmappedField(String name, Object value) {
        Msdyn_solutionhealthrule _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="msdyn_solutionhealthrule_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getMsdyn_solutionhealthrule_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("msdyn_solutionhealthrule_SyncErrors"), RequestHelper.getValue(unmappedFields, "msdyn_solutionhealthrule_SyncErrors"));
    }

    @NavigationProperty(name="msdyn_solutionhealthrule_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_solutionhealthrule_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_solutionhealthrule_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "msdyn_solutionhealthrule_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="msdyn_solutionhealthrule_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_solutionhealthrule_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_solutionhealthrule_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "msdyn_solutionhealthrule_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="msdyn_solutionhealthrule_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getMsdyn_solutionhealthrule_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("msdyn_solutionhealthrule_AsyncOperations"), RequestHelper.getValue(unmappedFields, "msdyn_solutionhealthrule_AsyncOperations"));
    }

    @NavigationProperty(name="msdyn_solutionhealthrule_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getMsdyn_solutionhealthrule_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("msdyn_solutionhealthrule_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "msdyn_solutionhealthrule_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="msdyn_solutionhealthrule_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getMsdyn_solutionhealthrule_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("msdyn_solutionhealthrule_ProcessSession"), RequestHelper.getValue(unmappedFields, "msdyn_solutionhealthrule_ProcessSession"));
    }

    @NavigationProperty(name="msdyn_solutionhealthrule_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getMsdyn_solutionhealthrule_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("msdyn_solutionhealthrule_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "msdyn_solutionhealthrule_BulkDeleteFailures"));
    }

    @NavigationProperty(name="msdyn_solutionhealthrule_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getMsdyn_solutionhealthrule_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("msdyn_solutionhealthrule_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "msdyn_solutionhealthrule_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="msdyn_msdyn_solutionhealthrule_msdyn_solutionhealthruleargument_SolutionHealthRule")
    @JsonIgnore
    public Msdyn_solutionhealthruleargumentCollectionRequest getMsdyn_msdyn_solutionhealthrule_msdyn_solutionhealthruleargument_SolutionHealthRule() {
        return new Msdyn_solutionhealthruleargumentCollectionRequest(
                        contextPath.addSegment("msdyn_msdyn_solutionhealthrule_msdyn_solutionhealthruleargument_SolutionHealthRule"), RequestHelper.getValue(unmappedFields, "msdyn_msdyn_solutionhealthrule_msdyn_solutionhealthruleargument_SolutionHealthRule"));
    }

    @NavigationProperty(name="msdyn_solutionhealthrulesetId")
    @JsonIgnore
    public Msdyn_solutionhealthrulesetRequest getMsdyn_solutionhealthrulesetId() {
        return new Msdyn_solutionhealthrulesetRequest(contextPath.addSegment("msdyn_solutionhealthrulesetId"), RequestHelper.getValue(unmappedFields, "msdyn_solutionhealthrulesetId"));
    }

    @NavigationProperty(name="msdyn_Workflow")
    @JsonIgnore
    public WorkflowRequest getMsdyn_Workflow() {
        return new WorkflowRequest(contextPath.addSegment("msdyn_Workflow"), RequestHelper.getValue(unmappedFields, "msdyn_Workflow"));
    }

    @NavigationProperty(name="msdyn_resolutionaction")
    @JsonIgnore
    public WorkflowRequest getMsdyn_resolutionaction() {
        return new WorkflowRequest(contextPath.addSegment("msdyn_resolutionaction"), RequestHelper.getValue(unmappedFields, "msdyn_resolutionaction"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_solutionhealthrule patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_solutionhealthrule put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_solutionhealthrule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_solutionhealthrule _copy() {
        Msdyn_solutionhealthrule _x = new Msdyn_solutionhealthrule();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.createdon = createdon;
        _x._msdyn_solutionhealthrulesetid_value = _msdyn_solutionhealthrulesetid_value;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x._modifiedby_value = _modifiedby_value;
        _x._msdyn_resolutionaction_value = _msdyn_resolutionaction_value;
        _x.versionnumber = versionnumber;
        _x.importsequencenumber = importsequencenumber;
        _x._msdyn_workflow_value = _msdyn_workflow_value;
        _x.statuscode = statuscode;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.modifiedon = modifiedon;
        _x.msdyn_description = msdyn_description;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.overriddencreatedon = overriddencreatedon;
        _x._owningteam_value = _owningteam_value;
        _x._owninguser_value = _owninguser_value;
        _x.msdyn_name = msdyn_name;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x._createdby_value = _createdby_value;
        _x._ownerid_value = _ownerid_value;
        _x.msdyn_resolutionmessage = msdyn_resolutionmessage;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.msdyn_solutionhealthruleid = msdyn_solutionhealthruleid;
        _x.msdyn_uniquename = msdyn_uniquename;
        _x.msdyn_owningsolutionid = msdyn_owningsolutionid;
        _x.statecode = statecode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_solutionhealthrule[");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_msdyn_solutionhealthrulesetid_value=");
        b.append(this._msdyn_solutionhealthrulesetid_value);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_msdyn_resolutionaction_value=");
        b.append(this._msdyn_resolutionaction_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("_msdyn_workflow_value=");
        b.append(this._msdyn_workflow_value);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("msdyn_description=");
        b.append(this.msdyn_description);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("msdyn_name=");
        b.append(this.msdyn_name);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("msdyn_resolutionmessage=");
        b.append(this.msdyn_resolutionmessage);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("msdyn_solutionhealthruleid=");
        b.append(this.msdyn_solutionhealthruleid);
        b.append(", ");
        b.append("msdyn_uniquename=");
        b.append(this.msdyn_uniquename);
        b.append(", ");
        b.append("msdyn_owningsolutionid=");
        b.append(this.msdyn_owningsolutionid);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
