package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_analysisresultdetailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysiscomponentRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysisjobRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "msdyn_line", 
    "msdyn_snippet", 
    "msdyn_messageid", 
    "msdyn_severity", 
    "msdyn_level", 
    "msdyn_solutionhealthmessage", 
    "msdyn_module", 
    "msdyn_analysiscomponenttype", 
    "modifiedon", 
    "_modifiedby_value", 
    "msdyn_category", 
    "_msdyn_analysisjobid_value", 
    "_ownerid_value", 
    "_owningteam_value", 
    "msdyn_analysisresultid", 
    "_owningbusinessunit_value", 
    "_createdby_value", 
    "msdyn_returnstatus", 
    "versionnumber", 
    "msdyn_componenttype", 
    "msdyn_type", 
    "utcconversiontimezonecode", 
    "_createdonbehalfby_value", 
    "msdyn_rulereferenceuri", 
    "msdyn_entityname", 
    "statecode", 
    "msdyn_message", 
    "msdyn_messagearguments", 
    "_owninguser_value", 
    "importsequencenumber", 
    "msdyn_ruleid", 
    "msdyn_hasresolution", 
    "msdyn_member", 
    "_msdyn_analysiscomponentid_value", 
    "overriddencreatedon", 
    "timezoneruleversionnumber", 
    "msdyn_helplink", 
    "msdyn_fileuri", 
    "statuscode", 
    "createdon", 
    "msdyn_name", 
    "_modifiedonbehalfby_value"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_analysisresult extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_analysisresult";
    }

    @JsonProperty("msdyn_line")
    protected Integer msdyn_line;

    @JsonProperty("msdyn_snippet")
    protected String msdyn_snippet;

    @JsonProperty("msdyn_messageid")
    protected String msdyn_messageid;

    @JsonProperty("msdyn_severity")
    protected Integer msdyn_severity;

    @JsonProperty("msdyn_level")
    protected Integer msdyn_level;

    @JsonProperty("msdyn_solutionhealthmessage")
    protected String msdyn_solutionhealthmessage;

    @JsonProperty("msdyn_module")
    protected String msdyn_module;

    @JsonProperty("msdyn_analysiscomponenttype")
    protected Integer msdyn_analysiscomponenttype;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("msdyn_category")
    protected Integer msdyn_category;

    @JsonProperty("_msdyn_analysisjobid_value")
    protected UUID _msdyn_analysisjobid_value;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("msdyn_analysisresultid")
    protected UUID msdyn_analysisresultid;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("msdyn_returnstatus")
    protected Integer msdyn_returnstatus;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("msdyn_componenttype")
    protected Integer msdyn_componenttype;

    @JsonProperty("msdyn_type")
    protected String msdyn_type;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("msdyn_rulereferenceuri")
    protected String msdyn_rulereferenceuri;

    @JsonProperty("msdyn_entityname")
    protected String msdyn_entityname;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("msdyn_message")
    protected String msdyn_message;

    @JsonProperty("msdyn_messagearguments")
    protected String msdyn_messagearguments;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("msdyn_ruleid")
    protected String msdyn_ruleid;

    @JsonProperty("msdyn_hasresolution")
    protected Boolean msdyn_hasresolution;

    @JsonProperty("msdyn_member")
    protected String msdyn_member;

    @JsonProperty("_msdyn_analysiscomponentid_value")
    protected UUID _msdyn_analysiscomponentid_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("msdyn_helplink")
    protected String msdyn_helplink;

    @JsonProperty("msdyn_fileuri")
    protected String msdyn_fileuri;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("msdyn_name")
    protected String msdyn_name;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    protected Msdyn_analysisresult() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_analysisresult() {
        return new Builder();
    }

    public static final class Builder {
        private Integer msdyn_line;
        private String msdyn_snippet;
        private String msdyn_messageid;
        private Integer msdyn_severity;
        private Integer msdyn_level;
        private String msdyn_solutionhealthmessage;
        private String msdyn_module;
        private Integer msdyn_analysiscomponenttype;
        private OffsetDateTime modifiedon;
        private UUID _modifiedby_value;
        private Integer msdyn_category;
        private UUID _msdyn_analysisjobid_value;
        private UUID _ownerid_value;
        private UUID _owningteam_value;
        private UUID msdyn_analysisresultid;
        private UUID _owningbusinessunit_value;
        private UUID _createdby_value;
        private Integer msdyn_returnstatus;
        private Long versionnumber;
        private Integer msdyn_componenttype;
        private String msdyn_type;
        private Integer utcconversiontimezonecode;
        private UUID _createdonbehalfby_value;
        private String msdyn_rulereferenceuri;
        private String msdyn_entityname;
        private Integer statecode;
        private String msdyn_message;
        private String msdyn_messagearguments;
        private UUID _owninguser_value;
        private Integer importsequencenumber;
        private String msdyn_ruleid;
        private Boolean msdyn_hasresolution;
        private String msdyn_member;
        private UUID _msdyn_analysiscomponentid_value;
        private OffsetDateTime overriddencreatedon;
        private Integer timezoneruleversionnumber;
        private String msdyn_helplink;
        private String msdyn_fileuri;
        private Integer statuscode;
        private OffsetDateTime createdon;
        private String msdyn_name;
        private UUID _modifiedonbehalfby_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder msdyn_line(Integer msdyn_line) {
            this.msdyn_line = msdyn_line;
            this.changedFields = changedFields.add("msdyn_line");
            return this;
        }

        public Builder msdyn_snippet(String msdyn_snippet) {
            this.msdyn_snippet = msdyn_snippet;
            this.changedFields = changedFields.add("msdyn_snippet");
            return this;
        }

        public Builder msdyn_messageid(String msdyn_messageid) {
            this.msdyn_messageid = msdyn_messageid;
            this.changedFields = changedFields.add("msdyn_messageid");
            return this;
        }

        public Builder msdyn_severity(Integer msdyn_severity) {
            this.msdyn_severity = msdyn_severity;
            this.changedFields = changedFields.add("msdyn_severity");
            return this;
        }

        public Builder msdyn_level(Integer msdyn_level) {
            this.msdyn_level = msdyn_level;
            this.changedFields = changedFields.add("msdyn_level");
            return this;
        }

        public Builder msdyn_solutionhealthmessage(String msdyn_solutionhealthmessage) {
            this.msdyn_solutionhealthmessage = msdyn_solutionhealthmessage;
            this.changedFields = changedFields.add("msdyn_solutionhealthmessage");
            return this;
        }

        public Builder msdyn_module(String msdyn_module) {
            this.msdyn_module = msdyn_module;
            this.changedFields = changedFields.add("msdyn_module");
            return this;
        }

        public Builder msdyn_analysiscomponenttype(Integer msdyn_analysiscomponenttype) {
            this.msdyn_analysiscomponenttype = msdyn_analysiscomponenttype;
            this.changedFields = changedFields.add("msdyn_analysiscomponenttype");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder msdyn_category(Integer msdyn_category) {
            this.msdyn_category = msdyn_category;
            this.changedFields = changedFields.add("msdyn_category");
            return this;
        }

        public Builder _msdyn_analysisjobid_value(UUID _msdyn_analysisjobid_value) {
            this._msdyn_analysisjobid_value = _msdyn_analysisjobid_value;
            this.changedFields = changedFields.add("_msdyn_analysisjobid_value");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder msdyn_analysisresultid(UUID msdyn_analysisresultid) {
            this.msdyn_analysisresultid = msdyn_analysisresultid;
            this.changedFields = changedFields.add("msdyn_analysisresultid");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder msdyn_returnstatus(Integer msdyn_returnstatus) {
            this.msdyn_returnstatus = msdyn_returnstatus;
            this.changedFields = changedFields.add("msdyn_returnstatus");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder msdyn_componenttype(Integer msdyn_componenttype) {
            this.msdyn_componenttype = msdyn_componenttype;
            this.changedFields = changedFields.add("msdyn_componenttype");
            return this;
        }

        public Builder msdyn_type(String msdyn_type) {
            this.msdyn_type = msdyn_type;
            this.changedFields = changedFields.add("msdyn_type");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder msdyn_rulereferenceuri(String msdyn_rulereferenceuri) {
            this.msdyn_rulereferenceuri = msdyn_rulereferenceuri;
            this.changedFields = changedFields.add("msdyn_rulereferenceuri");
            return this;
        }

        public Builder msdyn_entityname(String msdyn_entityname) {
            this.msdyn_entityname = msdyn_entityname;
            this.changedFields = changedFields.add("msdyn_entityname");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder msdyn_message(String msdyn_message) {
            this.msdyn_message = msdyn_message;
            this.changedFields = changedFields.add("msdyn_message");
            return this;
        }

        public Builder msdyn_messagearguments(String msdyn_messagearguments) {
            this.msdyn_messagearguments = msdyn_messagearguments;
            this.changedFields = changedFields.add("msdyn_messagearguments");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder msdyn_ruleid(String msdyn_ruleid) {
            this.msdyn_ruleid = msdyn_ruleid;
            this.changedFields = changedFields.add("msdyn_ruleid");
            return this;
        }

        public Builder msdyn_hasresolution(Boolean msdyn_hasresolution) {
            this.msdyn_hasresolution = msdyn_hasresolution;
            this.changedFields = changedFields.add("msdyn_hasresolution");
            return this;
        }

        public Builder msdyn_member(String msdyn_member) {
            this.msdyn_member = msdyn_member;
            this.changedFields = changedFields.add("msdyn_member");
            return this;
        }

        public Builder _msdyn_analysiscomponentid_value(UUID _msdyn_analysiscomponentid_value) {
            this._msdyn_analysiscomponentid_value = _msdyn_analysiscomponentid_value;
            this.changedFields = changedFields.add("_msdyn_analysiscomponentid_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder msdyn_helplink(String msdyn_helplink) {
            this.msdyn_helplink = msdyn_helplink;
            this.changedFields = changedFields.add("msdyn_helplink");
            return this;
        }

        public Builder msdyn_fileuri(String msdyn_fileuri) {
            this.msdyn_fileuri = msdyn_fileuri;
            this.changedFields = changedFields.add("msdyn_fileuri");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder msdyn_name(String msdyn_name) {
            this.msdyn_name = msdyn_name;
            this.changedFields = changedFields.add("msdyn_name");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Msdyn_analysisresult build() {
            Msdyn_analysisresult _x = new Msdyn_analysisresult();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_analysisresult";
            _x.msdyn_line = msdyn_line;
            _x.msdyn_snippet = msdyn_snippet;
            _x.msdyn_messageid = msdyn_messageid;
            _x.msdyn_severity = msdyn_severity;
            _x.msdyn_level = msdyn_level;
            _x.msdyn_solutionhealthmessage = msdyn_solutionhealthmessage;
            _x.msdyn_module = msdyn_module;
            _x.msdyn_analysiscomponenttype = msdyn_analysiscomponenttype;
            _x.modifiedon = modifiedon;
            _x._modifiedby_value = _modifiedby_value;
            _x.msdyn_category = msdyn_category;
            _x._msdyn_analysisjobid_value = _msdyn_analysisjobid_value;
            _x._ownerid_value = _ownerid_value;
            _x._owningteam_value = _owningteam_value;
            _x.msdyn_analysisresultid = msdyn_analysisresultid;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x._createdby_value = _createdby_value;
            _x.msdyn_returnstatus = msdyn_returnstatus;
            _x.versionnumber = versionnumber;
            _x.msdyn_componenttype = msdyn_componenttype;
            _x.msdyn_type = msdyn_type;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.msdyn_rulereferenceuri = msdyn_rulereferenceuri;
            _x.msdyn_entityname = msdyn_entityname;
            _x.statecode = statecode;
            _x.msdyn_message = msdyn_message;
            _x.msdyn_messagearguments = msdyn_messagearguments;
            _x._owninguser_value = _owninguser_value;
            _x.importsequencenumber = importsequencenumber;
            _x.msdyn_ruleid = msdyn_ruleid;
            _x.msdyn_hasresolution = msdyn_hasresolution;
            _x.msdyn_member = msdyn_member;
            _x._msdyn_analysiscomponentid_value = _msdyn_analysiscomponentid_value;
            _x.overriddencreatedon = overriddencreatedon;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.msdyn_helplink = msdyn_helplink;
            _x.msdyn_fileuri = msdyn_fileuri;
            _x.statuscode = statuscode;
            _x.createdon = createdon;
            _x.msdyn_name = msdyn_name;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_analysisresultid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_analysisresultid, UUID.class));
        }
    }

    @Property(name="msdyn_line")
    @JsonIgnore
    public Optional<Integer> getMsdyn_line() {
        return Optional.ofNullable(msdyn_line);
    }

    public Msdyn_analysisresult withMsdyn_line(Integer msdyn_line) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("msdyn_line");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.msdyn_line = msdyn_line;
        return _x;
    }

    @Property(name="msdyn_snippet")
    @JsonIgnore
    public Optional<String> getMsdyn_snippet() {
        return Optional.ofNullable(msdyn_snippet);
    }

    public Msdyn_analysisresult withMsdyn_snippet(String msdyn_snippet) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("msdyn_snippet");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.msdyn_snippet = msdyn_snippet;
        return _x;
    }

    @Property(name="msdyn_messageid")
    @JsonIgnore
    public Optional<String> getMsdyn_messageid() {
        return Optional.ofNullable(msdyn_messageid);
    }

    public Msdyn_analysisresult withMsdyn_messageid(String msdyn_messageid) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("msdyn_messageid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.msdyn_messageid = msdyn_messageid;
        return _x;
    }

    @Property(name="msdyn_severity")
    @JsonIgnore
    public Optional<Integer> getMsdyn_severity() {
        return Optional.ofNullable(msdyn_severity);
    }

    public Msdyn_analysisresult withMsdyn_severity(Integer msdyn_severity) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("msdyn_severity");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.msdyn_severity = msdyn_severity;
        return _x;
    }

    @Property(name="msdyn_level")
    @JsonIgnore
    public Optional<Integer> getMsdyn_level() {
        return Optional.ofNullable(msdyn_level);
    }

    public Msdyn_analysisresult withMsdyn_level(Integer msdyn_level) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("msdyn_level");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.msdyn_level = msdyn_level;
        return _x;
    }

    @Property(name="msdyn_solutionhealthmessage")
    @JsonIgnore
    public Optional<String> getMsdyn_solutionhealthmessage() {
        return Optional.ofNullable(msdyn_solutionhealthmessage);
    }

    public Msdyn_analysisresult withMsdyn_solutionhealthmessage(String msdyn_solutionhealthmessage) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("msdyn_solutionhealthmessage");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.msdyn_solutionhealthmessage = msdyn_solutionhealthmessage;
        return _x;
    }

    @Property(name="msdyn_module")
    @JsonIgnore
    public Optional<String> getMsdyn_module() {
        return Optional.ofNullable(msdyn_module);
    }

    public Msdyn_analysisresult withMsdyn_module(String msdyn_module) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("msdyn_module");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.msdyn_module = msdyn_module;
        return _x;
    }

    @Property(name="msdyn_analysiscomponenttype")
    @JsonIgnore
    public Optional<Integer> getMsdyn_analysiscomponenttype() {
        return Optional.ofNullable(msdyn_analysiscomponenttype);
    }

    public Msdyn_analysisresult withMsdyn_analysiscomponenttype(Integer msdyn_analysiscomponenttype) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("msdyn_analysiscomponenttype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.msdyn_analysiscomponenttype = msdyn_analysiscomponenttype;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Msdyn_analysisresult withModifiedon(OffsetDateTime modifiedon) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Msdyn_analysisresult with_modifiedby_value(UUID _modifiedby_value) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="msdyn_category")
    @JsonIgnore
    public Optional<Integer> getMsdyn_category() {
        return Optional.ofNullable(msdyn_category);
    }

    public Msdyn_analysisresult withMsdyn_category(Integer msdyn_category) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("msdyn_category");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.msdyn_category = msdyn_category;
        return _x;
    }

    @Property(name="_msdyn_analysisjobid_value")
    @JsonIgnore
    public Optional<UUID> get_msdyn_analysisjobid_value() {
        return Optional.ofNullable(_msdyn_analysisjobid_value);
    }

    public Msdyn_analysisresult with_msdyn_analysisjobid_value(UUID _msdyn_analysisjobid_value) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("_msdyn_analysisjobid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x._msdyn_analysisjobid_value = _msdyn_analysisjobid_value;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Msdyn_analysisresult with_ownerid_value(UUID _ownerid_value) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Msdyn_analysisresult with_owningteam_value(UUID _owningteam_value) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="msdyn_analysisresultid")
    @JsonIgnore
    public Optional<UUID> getMsdyn_analysisresultid() {
        return Optional.ofNullable(msdyn_analysisresultid);
    }

    public Msdyn_analysisresult withMsdyn_analysisresultid(UUID msdyn_analysisresultid) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("msdyn_analysisresultid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.msdyn_analysisresultid = msdyn_analysisresultid;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Msdyn_analysisresult with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Msdyn_analysisresult with_createdby_value(UUID _createdby_value) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="msdyn_returnstatus")
    @JsonIgnore
    public Optional<Integer> getMsdyn_returnstatus() {
        return Optional.ofNullable(msdyn_returnstatus);
    }

    public Msdyn_analysisresult withMsdyn_returnstatus(Integer msdyn_returnstatus) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("msdyn_returnstatus");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.msdyn_returnstatus = msdyn_returnstatus;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Msdyn_analysisresult withVersionnumber(Long versionnumber) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="msdyn_componenttype")
    @JsonIgnore
    public Optional<Integer> getMsdyn_componenttype() {
        return Optional.ofNullable(msdyn_componenttype);
    }

    public Msdyn_analysisresult withMsdyn_componenttype(Integer msdyn_componenttype) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("msdyn_componenttype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.msdyn_componenttype = msdyn_componenttype;
        return _x;
    }

    @Property(name="msdyn_type")
    @JsonIgnore
    public Optional<String> getMsdyn_type() {
        return Optional.ofNullable(msdyn_type);
    }

    public Msdyn_analysisresult withMsdyn_type(String msdyn_type) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("msdyn_type");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.msdyn_type = msdyn_type;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Msdyn_analysisresult withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Msdyn_analysisresult with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="msdyn_rulereferenceuri")
    @JsonIgnore
    public Optional<String> getMsdyn_rulereferenceuri() {
        return Optional.ofNullable(msdyn_rulereferenceuri);
    }

    public Msdyn_analysisresult withMsdyn_rulereferenceuri(String msdyn_rulereferenceuri) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("msdyn_rulereferenceuri");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.msdyn_rulereferenceuri = msdyn_rulereferenceuri;
        return _x;
    }

    @Property(name="msdyn_entityname")
    @JsonIgnore
    public Optional<String> getMsdyn_entityname() {
        return Optional.ofNullable(msdyn_entityname);
    }

    public Msdyn_analysisresult withMsdyn_entityname(String msdyn_entityname) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("msdyn_entityname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.msdyn_entityname = msdyn_entityname;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Msdyn_analysisresult withStatecode(Integer statecode) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="msdyn_message")
    @JsonIgnore
    public Optional<String> getMsdyn_message() {
        return Optional.ofNullable(msdyn_message);
    }

    public Msdyn_analysisresult withMsdyn_message(String msdyn_message) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("msdyn_message");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.msdyn_message = msdyn_message;
        return _x;
    }

    @Property(name="msdyn_messagearguments")
    @JsonIgnore
    public Optional<String> getMsdyn_messagearguments() {
        return Optional.ofNullable(msdyn_messagearguments);
    }

    public Msdyn_analysisresult withMsdyn_messagearguments(String msdyn_messagearguments) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("msdyn_messagearguments");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.msdyn_messagearguments = msdyn_messagearguments;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Msdyn_analysisresult with_owninguser_value(UUID _owninguser_value) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Msdyn_analysisresult withImportsequencenumber(Integer importsequencenumber) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="msdyn_ruleid")
    @JsonIgnore
    public Optional<String> getMsdyn_ruleid() {
        return Optional.ofNullable(msdyn_ruleid);
    }

    public Msdyn_analysisresult withMsdyn_ruleid(String msdyn_ruleid) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("msdyn_ruleid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.msdyn_ruleid = msdyn_ruleid;
        return _x;
    }

    @Property(name="msdyn_hasresolution")
    @JsonIgnore
    public Optional<Boolean> getMsdyn_hasresolution() {
        return Optional.ofNullable(msdyn_hasresolution);
    }

    public Msdyn_analysisresult withMsdyn_hasresolution(Boolean msdyn_hasresolution) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("msdyn_hasresolution");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.msdyn_hasresolution = msdyn_hasresolution;
        return _x;
    }

    @Property(name="msdyn_member")
    @JsonIgnore
    public Optional<String> getMsdyn_member() {
        return Optional.ofNullable(msdyn_member);
    }

    public Msdyn_analysisresult withMsdyn_member(String msdyn_member) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("msdyn_member");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.msdyn_member = msdyn_member;
        return _x;
    }

    @Property(name="_msdyn_analysiscomponentid_value")
    @JsonIgnore
    public Optional<UUID> get_msdyn_analysiscomponentid_value() {
        return Optional.ofNullable(_msdyn_analysiscomponentid_value);
    }

    public Msdyn_analysisresult with_msdyn_analysiscomponentid_value(UUID _msdyn_analysiscomponentid_value) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("_msdyn_analysiscomponentid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x._msdyn_analysiscomponentid_value = _msdyn_analysiscomponentid_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Msdyn_analysisresult withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Msdyn_analysisresult withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="msdyn_helplink")
    @JsonIgnore
    public Optional<String> getMsdyn_helplink() {
        return Optional.ofNullable(msdyn_helplink);
    }

    public Msdyn_analysisresult withMsdyn_helplink(String msdyn_helplink) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("msdyn_helplink");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.msdyn_helplink = msdyn_helplink;
        return _x;
    }

    @Property(name="msdyn_fileuri")
    @JsonIgnore
    public Optional<String> getMsdyn_fileuri() {
        return Optional.ofNullable(msdyn_fileuri);
    }

    public Msdyn_analysisresult withMsdyn_fileuri(String msdyn_fileuri) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("msdyn_fileuri");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.msdyn_fileuri = msdyn_fileuri;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Msdyn_analysisresult withStatuscode(Integer statuscode) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Msdyn_analysisresult withCreatedon(OffsetDateTime createdon) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="msdyn_name")
    @JsonIgnore
    public Optional<String> getMsdyn_name() {
        return Optional.ofNullable(msdyn_name);
    }

    public Msdyn_analysisresult withMsdyn_name(String msdyn_name) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("msdyn_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x.msdyn_name = msdyn_name;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Msdyn_analysisresult with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisresult");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    public Msdyn_analysisresult withUnmappedField(String name, Object value) {
        Msdyn_analysisresult _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="msdyn_analysisresult_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getMsdyn_analysisresult_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("msdyn_analysisresult_SyncErrors"), RequestHelper.getValue(unmappedFields, "msdyn_analysisresult_SyncErrors"));
    }

    @NavigationProperty(name="msdyn_analysisresult_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_analysisresult_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_analysisresult_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "msdyn_analysisresult_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="msdyn_analysisresult_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_analysisresult_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_analysisresult_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "msdyn_analysisresult_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="msdyn_analysisresult_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getMsdyn_analysisresult_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("msdyn_analysisresult_AsyncOperations"), RequestHelper.getValue(unmappedFields, "msdyn_analysisresult_AsyncOperations"));
    }

    @NavigationProperty(name="msdyn_analysisresult_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getMsdyn_analysisresult_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("msdyn_analysisresult_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "msdyn_analysisresult_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="msdyn_analysisresult_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getMsdyn_analysisresult_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("msdyn_analysisresult_ProcessSession"), RequestHelper.getValue(unmappedFields, "msdyn_analysisresult_ProcessSession"));
    }

    @NavigationProperty(name="msdyn_analysisresult_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getMsdyn_analysisresult_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("msdyn_analysisresult_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "msdyn_analysisresult_BulkDeleteFailures"));
    }

    @NavigationProperty(name="msdyn_analysisresult_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getMsdyn_analysisresult_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("msdyn_analysisresult_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "msdyn_analysisresult_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="msdyn_AnalysisComponentId")
    @JsonIgnore
    public Msdyn_analysiscomponentRequest getMsdyn_AnalysisComponentId() {
        return new Msdyn_analysiscomponentRequest(contextPath.addSegment("msdyn_AnalysisComponentId"), RequestHelper.getValue(unmappedFields, "msdyn_AnalysisComponentId"));
    }

    @NavigationProperty(name="msdyn_AnalysisJobId")
    @JsonIgnore
    public Msdyn_analysisjobRequest getMsdyn_AnalysisJobId() {
        return new Msdyn_analysisjobRequest(contextPath.addSegment("msdyn_AnalysisJobId"), RequestHelper.getValue(unmappedFields, "msdyn_AnalysisJobId"));
    }

    @NavigationProperty(name="msdyn_msdyn_analysisresult_msdyn_analysisresultdetail_AnalysisResult")
    @JsonIgnore
    public Msdyn_analysisresultdetailCollectionRequest getMsdyn_msdyn_analysisresult_msdyn_analysisresultdetail_AnalysisResult() {
        return new Msdyn_analysisresultdetailCollectionRequest(
                        contextPath.addSegment("msdyn_msdyn_analysisresult_msdyn_analysisresultdetail_AnalysisResult"), RequestHelper.getValue(unmappedFields, "msdyn_msdyn_analysisresult_msdyn_analysisresultdetail_AnalysisResult"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_analysisresult patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_analysisresult put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_analysisresult _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_analysisresult _copy() {
        Msdyn_analysisresult _x = new Msdyn_analysisresult();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.msdyn_line = msdyn_line;
        _x.msdyn_snippet = msdyn_snippet;
        _x.msdyn_messageid = msdyn_messageid;
        _x.msdyn_severity = msdyn_severity;
        _x.msdyn_level = msdyn_level;
        _x.msdyn_solutionhealthmessage = msdyn_solutionhealthmessage;
        _x.msdyn_module = msdyn_module;
        _x.msdyn_analysiscomponenttype = msdyn_analysiscomponenttype;
        _x.modifiedon = modifiedon;
        _x._modifiedby_value = _modifiedby_value;
        _x.msdyn_category = msdyn_category;
        _x._msdyn_analysisjobid_value = _msdyn_analysisjobid_value;
        _x._ownerid_value = _ownerid_value;
        _x._owningteam_value = _owningteam_value;
        _x.msdyn_analysisresultid = msdyn_analysisresultid;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x._createdby_value = _createdby_value;
        _x.msdyn_returnstatus = msdyn_returnstatus;
        _x.versionnumber = versionnumber;
        _x.msdyn_componenttype = msdyn_componenttype;
        _x.msdyn_type = msdyn_type;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.msdyn_rulereferenceuri = msdyn_rulereferenceuri;
        _x.msdyn_entityname = msdyn_entityname;
        _x.statecode = statecode;
        _x.msdyn_message = msdyn_message;
        _x.msdyn_messagearguments = msdyn_messagearguments;
        _x._owninguser_value = _owninguser_value;
        _x.importsequencenumber = importsequencenumber;
        _x.msdyn_ruleid = msdyn_ruleid;
        _x.msdyn_hasresolution = msdyn_hasresolution;
        _x.msdyn_member = msdyn_member;
        _x._msdyn_analysiscomponentid_value = _msdyn_analysiscomponentid_value;
        _x.overriddencreatedon = overriddencreatedon;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.msdyn_helplink = msdyn_helplink;
        _x.msdyn_fileuri = msdyn_fileuri;
        _x.statuscode = statuscode;
        _x.createdon = createdon;
        _x.msdyn_name = msdyn_name;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_analysisresult[");
        b.append("msdyn_line=");
        b.append(this.msdyn_line);
        b.append(", ");
        b.append("msdyn_snippet=");
        b.append(this.msdyn_snippet);
        b.append(", ");
        b.append("msdyn_messageid=");
        b.append(this.msdyn_messageid);
        b.append(", ");
        b.append("msdyn_severity=");
        b.append(this.msdyn_severity);
        b.append(", ");
        b.append("msdyn_level=");
        b.append(this.msdyn_level);
        b.append(", ");
        b.append("msdyn_solutionhealthmessage=");
        b.append(this.msdyn_solutionhealthmessage);
        b.append(", ");
        b.append("msdyn_module=");
        b.append(this.msdyn_module);
        b.append(", ");
        b.append("msdyn_analysiscomponenttype=");
        b.append(this.msdyn_analysiscomponenttype);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("msdyn_category=");
        b.append(this.msdyn_category);
        b.append(", ");
        b.append("_msdyn_analysisjobid_value=");
        b.append(this._msdyn_analysisjobid_value);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("msdyn_analysisresultid=");
        b.append(this.msdyn_analysisresultid);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("msdyn_returnstatus=");
        b.append(this.msdyn_returnstatus);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("msdyn_componenttype=");
        b.append(this.msdyn_componenttype);
        b.append(", ");
        b.append("msdyn_type=");
        b.append(this.msdyn_type);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("msdyn_rulereferenceuri=");
        b.append(this.msdyn_rulereferenceuri);
        b.append(", ");
        b.append("msdyn_entityname=");
        b.append(this.msdyn_entityname);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("msdyn_message=");
        b.append(this.msdyn_message);
        b.append(", ");
        b.append("msdyn_messagearguments=");
        b.append(this.msdyn_messagearguments);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("msdyn_ruleid=");
        b.append(this.msdyn_ruleid);
        b.append(", ");
        b.append("msdyn_hasresolution=");
        b.append(this.msdyn_hasresolution);
        b.append(", ");
        b.append("msdyn_member=");
        b.append(this.msdyn_member);
        b.append(", ");
        b.append("_msdyn_analysiscomponentid_value=");
        b.append(this._msdyn_analysiscomponentid_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("msdyn_helplink=");
        b.append(this.msdyn_helplink);
        b.append(", ");
        b.append("msdyn_fileuri=");
        b.append(this.msdyn_fileuri);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("msdyn_name=");
        b.append(this.msdyn_name);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
