package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "solutionfileversion", 
    "languageprovisioningstateid", 
    "applicationversion", 
    "languageid", 
    "provisioningstage", 
    "solutionuniquename"})
@JsonInclude(Include.NON_NULL)
public class Languageprovisioningstate extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.languageprovisioningstate";
    }

    @JsonProperty("solutionfileversion")
    protected String solutionfileversion;

    @JsonProperty("languageprovisioningstateid")
    protected UUID languageprovisioningstateid;

    @JsonProperty("applicationversion")
    protected String applicationversion;

    @JsonProperty("languageid")
    protected Integer languageid;

    @JsonProperty("provisioningstage")
    protected Integer provisioningstage;

    @JsonProperty("solutionuniquename")
    protected String solutionuniquename;

    protected Languageprovisioningstate() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderLanguageprovisioningstate() {
        return new Builder();
    }

    public static final class Builder {
        private String solutionfileversion;
        private UUID languageprovisioningstateid;
        private String applicationversion;
        private Integer languageid;
        private Integer provisioningstage;
        private String solutionuniquename;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder solutionfileversion(String solutionfileversion) {
            this.solutionfileversion = solutionfileversion;
            this.changedFields = changedFields.add("solutionfileversion");
            return this;
        }

        public Builder languageprovisioningstateid(UUID languageprovisioningstateid) {
            this.languageprovisioningstateid = languageprovisioningstateid;
            this.changedFields = changedFields.add("languageprovisioningstateid");
            return this;
        }

        public Builder applicationversion(String applicationversion) {
            this.applicationversion = applicationversion;
            this.changedFields = changedFields.add("applicationversion");
            return this;
        }

        public Builder languageid(Integer languageid) {
            this.languageid = languageid;
            this.changedFields = changedFields.add("languageid");
            return this;
        }

        public Builder provisioningstage(Integer provisioningstage) {
            this.provisioningstage = provisioningstage;
            this.changedFields = changedFields.add("provisioningstage");
            return this;
        }

        public Builder solutionuniquename(String solutionuniquename) {
            this.solutionuniquename = solutionuniquename;
            this.changedFields = changedFields.add("solutionuniquename");
            return this;
        }

        public Languageprovisioningstate build() {
            Languageprovisioningstate _x = new Languageprovisioningstate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.languageprovisioningstate";
            _x.solutionfileversion = solutionfileversion;
            _x.languageprovisioningstateid = languageprovisioningstateid;
            _x.applicationversion = applicationversion;
            _x.languageid = languageid;
            _x.provisioningstage = provisioningstage;
            _x.solutionuniquename = solutionuniquename;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && languageprovisioningstateid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(languageprovisioningstateid, UUID.class));
        }
    }

    @Property(name="solutionfileversion")
    @JsonIgnore
    public Optional<String> getSolutionfileversion() {
        return Optional.ofNullable(solutionfileversion);
    }

    public Languageprovisioningstate withSolutionfileversion(String solutionfileversion) {
        Languageprovisioningstate _x = _copy();
        _x.changedFields = changedFields.add("solutionfileversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.languageprovisioningstate");
        _x.solutionfileversion = solutionfileversion;
        return _x;
    }

    @Property(name="languageprovisioningstateid")
    @JsonIgnore
    public Optional<UUID> getLanguageprovisioningstateid() {
        return Optional.ofNullable(languageprovisioningstateid);
    }

    public Languageprovisioningstate withLanguageprovisioningstateid(UUID languageprovisioningstateid) {
        Languageprovisioningstate _x = _copy();
        _x.changedFields = changedFields.add("languageprovisioningstateid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.languageprovisioningstate");
        _x.languageprovisioningstateid = languageprovisioningstateid;
        return _x;
    }

    @Property(name="applicationversion")
    @JsonIgnore
    public Optional<String> getApplicationversion() {
        return Optional.ofNullable(applicationversion);
    }

    public Languageprovisioningstate withApplicationversion(String applicationversion) {
        Languageprovisioningstate _x = _copy();
        _x.changedFields = changedFields.add("applicationversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.languageprovisioningstate");
        _x.applicationversion = applicationversion;
        return _x;
    }

    @Property(name="languageid")
    @JsonIgnore
    public Optional<Integer> getLanguageid() {
        return Optional.ofNullable(languageid);
    }

    public Languageprovisioningstate withLanguageid(Integer languageid) {
        Languageprovisioningstate _x = _copy();
        _x.changedFields = changedFields.add("languageid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.languageprovisioningstate");
        _x.languageid = languageid;
        return _x;
    }

    @Property(name="provisioningstage")
    @JsonIgnore
    public Optional<Integer> getProvisioningstage() {
        return Optional.ofNullable(provisioningstage);
    }

    public Languageprovisioningstate withProvisioningstage(Integer provisioningstage) {
        Languageprovisioningstate _x = _copy();
        _x.changedFields = changedFields.add("provisioningstage");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.languageprovisioningstate");
        _x.provisioningstage = provisioningstage;
        return _x;
    }

    @Property(name="solutionuniquename")
    @JsonIgnore
    public Optional<String> getSolutionuniquename() {
        return Optional.ofNullable(solutionuniquename);
    }

    public Languageprovisioningstate withSolutionuniquename(String solutionuniquename) {
        Languageprovisioningstate _x = _copy();
        _x.changedFields = changedFields.add("solutionuniquename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.languageprovisioningstate");
        _x.solutionuniquename = solutionuniquename;
        return _x;
    }

    public Languageprovisioningstate withUnmappedField(String name, Object value) {
        Languageprovisioningstate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Languageprovisioningstate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Languageprovisioningstate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Languageprovisioningstate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Languageprovisioningstate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Languageprovisioningstate _copy() {
        Languageprovisioningstate _x = new Languageprovisioningstate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.solutionfileversion = solutionfileversion;
        _x.languageprovisioningstateid = languageprovisioningstateid;
        _x.applicationversion = applicationversion;
        _x.languageid = languageid;
        _x.provisioningstage = provisioningstage;
        _x.solutionuniquename = solutionuniquename;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Languageprovisioningstate[");
        b.append("solutionfileversion=");
        b.append(this.solutionfileversion);
        b.append(", ");
        b.append("languageprovisioningstateid=");
        b.append(this.languageprovisioningstateid);
        b.append(", ");
        b.append("applicationversion=");
        b.append(this.applicationversion);
        b.append(", ");
        b.append("languageid=");
        b.append(this.languageid);
        b.append(", ");
        b.append("provisioningstage=");
        b.append(this.provisioningstage);
        b.append(", ");
        b.append("solutionuniquename=");
        b.append(this.solutionuniquename);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
