package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.FieldsecurityprofileRequest;
import microsoft.dynamics.crm.entity.request.SolutionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "fieldpermissionid", 
    "ismanaged", 
    "componentstate", 
    "canupdate", 
    "overwritetime", 
    "solutionid", 
    "entityname", 
    "canread", 
    "_organizationid_value", 
    "cancreate", 
    "_fieldsecurityprofileid_value", 
    "versionnumber", 
    "fieldpermissionidunique", 
    "attributelogicalname"})
@JsonInclude(Include.NON_NULL)
public class Fieldpermission extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.fieldpermission";
    }

    @JsonProperty("fieldpermissionid")
    protected UUID fieldpermissionid;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("canupdate")
    protected Integer canupdate;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("entityname")
    protected String entityname;

    @JsonProperty("canread")
    protected Integer canread;

    @JsonProperty("_organizationid_value")
    protected UUID _organizationid_value;

    @JsonProperty("cancreate")
    protected Integer cancreate;

    @JsonProperty("_fieldsecurityprofileid_value")
    protected UUID _fieldsecurityprofileid_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("fieldpermissionidunique")
    protected UUID fieldpermissionidunique;

    @JsonProperty("attributelogicalname")
    protected String attributelogicalname;

    protected Fieldpermission() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderFieldpermission() {
        return new Builder();
    }

    public static final class Builder {
        private UUID fieldpermissionid;
        private Boolean ismanaged;
        private Integer componentstate;
        private Integer canupdate;
        private OffsetDateTime overwritetime;
        private UUID solutionid;
        private String entityname;
        private Integer canread;
        private UUID _organizationid_value;
        private Integer cancreate;
        private UUID _fieldsecurityprofileid_value;
        private Long versionnumber;
        private UUID fieldpermissionidunique;
        private String attributelogicalname;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder fieldpermissionid(UUID fieldpermissionid) {
            this.fieldpermissionid = fieldpermissionid;
            this.changedFields = changedFields.add("fieldpermissionid");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder canupdate(Integer canupdate) {
            this.canupdate = canupdate;
            this.changedFields = changedFields.add("canupdate");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder entityname(String entityname) {
            this.entityname = entityname;
            this.changedFields = changedFields.add("entityname");
            return this;
        }

        public Builder canread(Integer canread) {
            this.canread = canread;
            this.changedFields = changedFields.add("canread");
            return this;
        }

        public Builder _organizationid_value(UUID _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder cancreate(Integer cancreate) {
            this.cancreate = cancreate;
            this.changedFields = changedFields.add("cancreate");
            return this;
        }

        public Builder _fieldsecurityprofileid_value(UUID _fieldsecurityprofileid_value) {
            this._fieldsecurityprofileid_value = _fieldsecurityprofileid_value;
            this.changedFields = changedFields.add("_fieldsecurityprofileid_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder fieldpermissionidunique(UUID fieldpermissionidunique) {
            this.fieldpermissionidunique = fieldpermissionidunique;
            this.changedFields = changedFields.add("fieldpermissionidunique");
            return this;
        }

        public Builder attributelogicalname(String attributelogicalname) {
            this.attributelogicalname = attributelogicalname;
            this.changedFields = changedFields.add("attributelogicalname");
            return this;
        }

        public Fieldpermission build() {
            Fieldpermission _x = new Fieldpermission();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.fieldpermission";
            _x.fieldpermissionid = fieldpermissionid;
            _x.ismanaged = ismanaged;
            _x.componentstate = componentstate;
            _x.canupdate = canupdate;
            _x.overwritetime = overwritetime;
            _x.solutionid = solutionid;
            _x.entityname = entityname;
            _x.canread = canread;
            _x._organizationid_value = _organizationid_value;
            _x.cancreate = cancreate;
            _x._fieldsecurityprofileid_value = _fieldsecurityprofileid_value;
            _x.versionnumber = versionnumber;
            _x.fieldpermissionidunique = fieldpermissionidunique;
            _x.attributelogicalname = attributelogicalname;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && fieldpermissionid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(fieldpermissionid, UUID.class));
        }
    }

    @Property(name="fieldpermissionid")
    @JsonIgnore
    public Optional<UUID> getFieldpermissionid() {
        return Optional.ofNullable(fieldpermissionid);
    }

    public Fieldpermission withFieldpermissionid(UUID fieldpermissionid) {
        Fieldpermission _x = _copy();
        _x.changedFields = changedFields.add("fieldpermissionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fieldpermission");
        _x.fieldpermissionid = fieldpermissionid;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Fieldpermission withIsmanaged(Boolean ismanaged) {
        Fieldpermission _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fieldpermission");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Fieldpermission withComponentstate(Integer componentstate) {
        Fieldpermission _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fieldpermission");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="canupdate")
    @JsonIgnore
    public Optional<Integer> getCanupdate() {
        return Optional.ofNullable(canupdate);
    }

    public Fieldpermission withCanupdate(Integer canupdate) {
        Fieldpermission _x = _copy();
        _x.changedFields = changedFields.add("canupdate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fieldpermission");
        _x.canupdate = canupdate;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Fieldpermission withOverwritetime(OffsetDateTime overwritetime) {
        Fieldpermission _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fieldpermission");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Fieldpermission withSolutionid(UUID solutionid) {
        Fieldpermission _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fieldpermission");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="entityname")
    @JsonIgnore
    public Optional<String> getEntityname() {
        return Optional.ofNullable(entityname);
    }

    public Fieldpermission withEntityname(String entityname) {
        Fieldpermission _x = _copy();
        _x.changedFields = changedFields.add("entityname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fieldpermission");
        _x.entityname = entityname;
        return _x;
    }

    @Property(name="canread")
    @JsonIgnore
    public Optional<Integer> getCanread() {
        return Optional.ofNullable(canread);
    }

    public Fieldpermission withCanread(Integer canread) {
        Fieldpermission _x = _copy();
        _x.changedFields = changedFields.add("canread");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fieldpermission");
        _x.canread = canread;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<UUID> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Fieldpermission with_organizationid_value(UUID _organizationid_value) {
        Fieldpermission _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fieldpermission");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="cancreate")
    @JsonIgnore
    public Optional<Integer> getCancreate() {
        return Optional.ofNullable(cancreate);
    }

    public Fieldpermission withCancreate(Integer cancreate) {
        Fieldpermission _x = _copy();
        _x.changedFields = changedFields.add("cancreate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fieldpermission");
        _x.cancreate = cancreate;
        return _x;
    }

    @Property(name="_fieldsecurityprofileid_value")
    @JsonIgnore
    public Optional<UUID> get_fieldsecurityprofileid_value() {
        return Optional.ofNullable(_fieldsecurityprofileid_value);
    }

    public Fieldpermission with_fieldsecurityprofileid_value(UUID _fieldsecurityprofileid_value) {
        Fieldpermission _x = _copy();
        _x.changedFields = changedFields.add("_fieldsecurityprofileid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fieldpermission");
        _x._fieldsecurityprofileid_value = _fieldsecurityprofileid_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Fieldpermission withVersionnumber(Long versionnumber) {
        Fieldpermission _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fieldpermission");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="fieldpermissionidunique")
    @JsonIgnore
    public Optional<UUID> getFieldpermissionidunique() {
        return Optional.ofNullable(fieldpermissionidunique);
    }

    public Fieldpermission withFieldpermissionidunique(UUID fieldpermissionidunique) {
        Fieldpermission _x = _copy();
        _x.changedFields = changedFields.add("fieldpermissionidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fieldpermission");
        _x.fieldpermissionidunique = fieldpermissionidunique;
        return _x;
    }

    @Property(name="attributelogicalname")
    @JsonIgnore
    public Optional<String> getAttributelogicalname() {
        return Optional.ofNullable(attributelogicalname);
    }

    public Fieldpermission withAttributelogicalname(String attributelogicalname) {
        Fieldpermission _x = _copy();
        _x.changedFields = changedFields.add("attributelogicalname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.fieldpermission");
        _x.attributelogicalname = attributelogicalname;
        return _x;
    }

    public Fieldpermission withUnmappedField(String name, Object value) {
        Fieldpermission _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="FieldPermission_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getFieldPermission_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("FieldPermission_SyncErrors"), RequestHelper.getValue(unmappedFields, "FieldPermission_SyncErrors"));
    }

    @NavigationProperty(name="fieldsecurityprofileid")
    @JsonIgnore
    public FieldsecurityprofileRequest getFieldsecurityprofileid() {
        return new FieldsecurityprofileRequest(contextPath.addSegment("fieldsecurityprofileid"), RequestHelper.getValue(unmappedFields, "fieldsecurityprofileid"));
    }

    @NavigationProperty(name="solution_fieldpermission")
    @JsonIgnore
    public SolutionRequest getSolution_fieldpermission() {
        return new SolutionRequest(contextPath.addSegment("solution_fieldpermission"), RequestHelper.getValue(unmappedFields, "solution_fieldpermission"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Fieldpermission patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Fieldpermission _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Fieldpermission put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Fieldpermission _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Fieldpermission _copy() {
        Fieldpermission _x = new Fieldpermission();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.fieldpermissionid = fieldpermissionid;
        _x.ismanaged = ismanaged;
        _x.componentstate = componentstate;
        _x.canupdate = canupdate;
        _x.overwritetime = overwritetime;
        _x.solutionid = solutionid;
        _x.entityname = entityname;
        _x.canread = canread;
        _x._organizationid_value = _organizationid_value;
        _x.cancreate = cancreate;
        _x._fieldsecurityprofileid_value = _fieldsecurityprofileid_value;
        _x.versionnumber = versionnumber;
        _x.fieldpermissionidunique = fieldpermissionidunique;
        _x.attributelogicalname = attributelogicalname;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Fieldpermission[");
        b.append("fieldpermissionid=");
        b.append(this.fieldpermissionid);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("canupdate=");
        b.append(this.canupdate);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("entityname=");
        b.append(this.entityname);
        b.append(", ");
        b.append("canread=");
        b.append(this.canread);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("cancreate=");
        b.append(this.cancreate);
        b.append(", ");
        b.append("_fieldsecurityprofileid_value=");
        b.append(this._fieldsecurityprofileid_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("fieldpermissionidunique=");
        b.append(this.fieldpermissionidunique);
        b.append(", ");
        b.append("attributelogicalname=");
        b.append(this.attributelogicalname);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
