package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Double;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "requiredcomponentobjectid", 
    "versionnumber", 
    "requiredcomponentparentid", 
    "dependentcomponentbasesolutionid", 
    "dependentcomponenttype", 
    "dependencyid", 
    "dependentcomponentparentid", 
    "_requiredcomponentnodeid_value", 
    "_dependentcomponentnodeid_value", 
    "requiredcomponentbasesolutionid", 
    "dependencytype", 
    "dependentcomponentobjectid", 
    "requiredcomponentintroducedversion", 
    "requiredcomponenttype"})
@JsonInclude(Include.NON_NULL)
public class Dependency extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.dependency";
    }

    @JsonProperty("requiredcomponentobjectid")
    protected UUID requiredcomponentobjectid;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("requiredcomponentparentid")
    protected UUID requiredcomponentparentid;

    @JsonProperty("dependentcomponentbasesolutionid")
    protected UUID dependentcomponentbasesolutionid;

    @JsonProperty("dependentcomponenttype")
    protected Integer dependentcomponenttype;

    @JsonProperty("dependencyid")
    protected UUID dependencyid;

    @JsonProperty("dependentcomponentparentid")
    protected UUID dependentcomponentparentid;

    @JsonProperty("_requiredcomponentnodeid_value")
    protected UUID _requiredcomponentnodeid_value;

    @JsonProperty("_dependentcomponentnodeid_value")
    protected UUID _dependentcomponentnodeid_value;

    @JsonProperty("requiredcomponentbasesolutionid")
    protected UUID requiredcomponentbasesolutionid;

    @JsonProperty("dependencytype")
    protected Integer dependencytype;

    @JsonProperty("dependentcomponentobjectid")
    protected UUID dependentcomponentobjectid;

    @JsonProperty("requiredcomponentintroducedversion")
    protected Double requiredcomponentintroducedversion;

    @JsonProperty("requiredcomponenttype")
    protected Integer requiredcomponenttype;

    protected Dependency() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDependency() {
        return new Builder();
    }

    public static final class Builder {
        private UUID requiredcomponentobjectid;
        private Long versionnumber;
        private UUID requiredcomponentparentid;
        private UUID dependentcomponentbasesolutionid;
        private Integer dependentcomponenttype;
        private UUID dependencyid;
        private UUID dependentcomponentparentid;
        private UUID _requiredcomponentnodeid_value;
        private UUID _dependentcomponentnodeid_value;
        private UUID requiredcomponentbasesolutionid;
        private Integer dependencytype;
        private UUID dependentcomponentobjectid;
        private Double requiredcomponentintroducedversion;
        private Integer requiredcomponenttype;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder requiredcomponentobjectid(UUID requiredcomponentobjectid) {
            this.requiredcomponentobjectid = requiredcomponentobjectid;
            this.changedFields = changedFields.add("requiredcomponentobjectid");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder requiredcomponentparentid(UUID requiredcomponentparentid) {
            this.requiredcomponentparentid = requiredcomponentparentid;
            this.changedFields = changedFields.add("requiredcomponentparentid");
            return this;
        }

        public Builder dependentcomponentbasesolutionid(UUID dependentcomponentbasesolutionid) {
            this.dependentcomponentbasesolutionid = dependentcomponentbasesolutionid;
            this.changedFields = changedFields.add("dependentcomponentbasesolutionid");
            return this;
        }

        public Builder dependentcomponenttype(Integer dependentcomponenttype) {
            this.dependentcomponenttype = dependentcomponenttype;
            this.changedFields = changedFields.add("dependentcomponenttype");
            return this;
        }

        public Builder dependencyid(UUID dependencyid) {
            this.dependencyid = dependencyid;
            this.changedFields = changedFields.add("dependencyid");
            return this;
        }

        public Builder dependentcomponentparentid(UUID dependentcomponentparentid) {
            this.dependentcomponentparentid = dependentcomponentparentid;
            this.changedFields = changedFields.add("dependentcomponentparentid");
            return this;
        }

        public Builder _requiredcomponentnodeid_value(UUID _requiredcomponentnodeid_value) {
            this._requiredcomponentnodeid_value = _requiredcomponentnodeid_value;
            this.changedFields = changedFields.add("_requiredcomponentnodeid_value");
            return this;
        }

        public Builder _dependentcomponentnodeid_value(UUID _dependentcomponentnodeid_value) {
            this._dependentcomponentnodeid_value = _dependentcomponentnodeid_value;
            this.changedFields = changedFields.add("_dependentcomponentnodeid_value");
            return this;
        }

        public Builder requiredcomponentbasesolutionid(UUID requiredcomponentbasesolutionid) {
            this.requiredcomponentbasesolutionid = requiredcomponentbasesolutionid;
            this.changedFields = changedFields.add("requiredcomponentbasesolutionid");
            return this;
        }

        public Builder dependencytype(Integer dependencytype) {
            this.dependencytype = dependencytype;
            this.changedFields = changedFields.add("dependencytype");
            return this;
        }

        public Builder dependentcomponentobjectid(UUID dependentcomponentobjectid) {
            this.dependentcomponentobjectid = dependentcomponentobjectid;
            this.changedFields = changedFields.add("dependentcomponentobjectid");
            return this;
        }

        public Builder requiredcomponentintroducedversion(Double requiredcomponentintroducedversion) {
            this.requiredcomponentintroducedversion = requiredcomponentintroducedversion;
            this.changedFields = changedFields.add("requiredcomponentintroducedversion");
            return this;
        }

        public Builder requiredcomponenttype(Integer requiredcomponenttype) {
            this.requiredcomponenttype = requiredcomponenttype;
            this.changedFields = changedFields.add("requiredcomponenttype");
            return this;
        }

        public Dependency build() {
            Dependency _x = new Dependency();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.dependency";
            _x.requiredcomponentobjectid = requiredcomponentobjectid;
            _x.versionnumber = versionnumber;
            _x.requiredcomponentparentid = requiredcomponentparentid;
            _x.dependentcomponentbasesolutionid = dependentcomponentbasesolutionid;
            _x.dependentcomponenttype = dependentcomponenttype;
            _x.dependencyid = dependencyid;
            _x.dependentcomponentparentid = dependentcomponentparentid;
            _x._requiredcomponentnodeid_value = _requiredcomponentnodeid_value;
            _x._dependentcomponentnodeid_value = _dependentcomponentnodeid_value;
            _x.requiredcomponentbasesolutionid = requiredcomponentbasesolutionid;
            _x.dependencytype = dependencytype;
            _x.dependentcomponentobjectid = dependentcomponentobjectid;
            _x.requiredcomponentintroducedversion = requiredcomponentintroducedversion;
            _x.requiredcomponenttype = requiredcomponenttype;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && dependencyid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(dependencyid, UUID.class));
        }
    }

    @Property(name="requiredcomponentobjectid")
    @JsonIgnore
    public Optional<UUID> getRequiredcomponentobjectid() {
        return Optional.ofNullable(requiredcomponentobjectid);
    }

    public Dependency withRequiredcomponentobjectid(UUID requiredcomponentobjectid) {
        Dependency _x = _copy();
        _x.changedFields = changedFields.add("requiredcomponentobjectid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dependency");
        _x.requiredcomponentobjectid = requiredcomponentobjectid;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Dependency withVersionnumber(Long versionnumber) {
        Dependency _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dependency");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="requiredcomponentparentid")
    @JsonIgnore
    public Optional<UUID> getRequiredcomponentparentid() {
        return Optional.ofNullable(requiredcomponentparentid);
    }

    public Dependency withRequiredcomponentparentid(UUID requiredcomponentparentid) {
        Dependency _x = _copy();
        _x.changedFields = changedFields.add("requiredcomponentparentid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dependency");
        _x.requiredcomponentparentid = requiredcomponentparentid;
        return _x;
    }

    @Property(name="dependentcomponentbasesolutionid")
    @JsonIgnore
    public Optional<UUID> getDependentcomponentbasesolutionid() {
        return Optional.ofNullable(dependentcomponentbasesolutionid);
    }

    public Dependency withDependentcomponentbasesolutionid(UUID dependentcomponentbasesolutionid) {
        Dependency _x = _copy();
        _x.changedFields = changedFields.add("dependentcomponentbasesolutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dependency");
        _x.dependentcomponentbasesolutionid = dependentcomponentbasesolutionid;
        return _x;
    }

    @Property(name="dependentcomponenttype")
    @JsonIgnore
    public Optional<Integer> getDependentcomponenttype() {
        return Optional.ofNullable(dependentcomponenttype);
    }

    public Dependency withDependentcomponenttype(Integer dependentcomponenttype) {
        Dependency _x = _copy();
        _x.changedFields = changedFields.add("dependentcomponenttype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dependency");
        _x.dependentcomponenttype = dependentcomponenttype;
        return _x;
    }

    @Property(name="dependencyid")
    @JsonIgnore
    public Optional<UUID> getDependencyid() {
        return Optional.ofNullable(dependencyid);
    }

    public Dependency withDependencyid(UUID dependencyid) {
        Dependency _x = _copy();
        _x.changedFields = changedFields.add("dependencyid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dependency");
        _x.dependencyid = dependencyid;
        return _x;
    }

    @Property(name="dependentcomponentparentid")
    @JsonIgnore
    public Optional<UUID> getDependentcomponentparentid() {
        return Optional.ofNullable(dependentcomponentparentid);
    }

    public Dependency withDependentcomponentparentid(UUID dependentcomponentparentid) {
        Dependency _x = _copy();
        _x.changedFields = changedFields.add("dependentcomponentparentid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dependency");
        _x.dependentcomponentparentid = dependentcomponentparentid;
        return _x;
    }

    @Property(name="_requiredcomponentnodeid_value")
    @JsonIgnore
    public Optional<UUID> get_requiredcomponentnodeid_value() {
        return Optional.ofNullable(_requiredcomponentnodeid_value);
    }

    public Dependency with_requiredcomponentnodeid_value(UUID _requiredcomponentnodeid_value) {
        Dependency _x = _copy();
        _x.changedFields = changedFields.add("_requiredcomponentnodeid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dependency");
        _x._requiredcomponentnodeid_value = _requiredcomponentnodeid_value;
        return _x;
    }

    @Property(name="_dependentcomponentnodeid_value")
    @JsonIgnore
    public Optional<UUID> get_dependentcomponentnodeid_value() {
        return Optional.ofNullable(_dependentcomponentnodeid_value);
    }

    public Dependency with_dependentcomponentnodeid_value(UUID _dependentcomponentnodeid_value) {
        Dependency _x = _copy();
        _x.changedFields = changedFields.add("_dependentcomponentnodeid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dependency");
        _x._dependentcomponentnodeid_value = _dependentcomponentnodeid_value;
        return _x;
    }

    @Property(name="requiredcomponentbasesolutionid")
    @JsonIgnore
    public Optional<UUID> getRequiredcomponentbasesolutionid() {
        return Optional.ofNullable(requiredcomponentbasesolutionid);
    }

    public Dependency withRequiredcomponentbasesolutionid(UUID requiredcomponentbasesolutionid) {
        Dependency _x = _copy();
        _x.changedFields = changedFields.add("requiredcomponentbasesolutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dependency");
        _x.requiredcomponentbasesolutionid = requiredcomponentbasesolutionid;
        return _x;
    }

    @Property(name="dependencytype")
    @JsonIgnore
    public Optional<Integer> getDependencytype() {
        return Optional.ofNullable(dependencytype);
    }

    public Dependency withDependencytype(Integer dependencytype) {
        Dependency _x = _copy();
        _x.changedFields = changedFields.add("dependencytype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dependency");
        _x.dependencytype = dependencytype;
        return _x;
    }

    @Property(name="dependentcomponentobjectid")
    @JsonIgnore
    public Optional<UUID> getDependentcomponentobjectid() {
        return Optional.ofNullable(dependentcomponentobjectid);
    }

    public Dependency withDependentcomponentobjectid(UUID dependentcomponentobjectid) {
        Dependency _x = _copy();
        _x.changedFields = changedFields.add("dependentcomponentobjectid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dependency");
        _x.dependentcomponentobjectid = dependentcomponentobjectid;
        return _x;
    }

    @Property(name="requiredcomponentintroducedversion")
    @JsonIgnore
    public Optional<Double> getRequiredcomponentintroducedversion() {
        return Optional.ofNullable(requiredcomponentintroducedversion);
    }

    public Dependency withRequiredcomponentintroducedversion(Double requiredcomponentintroducedversion) {
        Dependency _x = _copy();
        _x.changedFields = changedFields.add("requiredcomponentintroducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dependency");
        _x.requiredcomponentintroducedversion = requiredcomponentintroducedversion;
        return _x;
    }

    @Property(name="requiredcomponenttype")
    @JsonIgnore
    public Optional<Integer> getRequiredcomponenttype() {
        return Optional.ofNullable(requiredcomponenttype);
    }

    public Dependency withRequiredcomponenttype(Integer requiredcomponenttype) {
        Dependency _x = _copy();
        _x.changedFields = changedFields.add("requiredcomponenttype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dependency");
        _x.requiredcomponenttype = requiredcomponenttype;
        return _x;
    }

    public Dependency withUnmappedField(String name, Object value) {
        Dependency _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Dependency patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Dependency _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Dependency put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Dependency _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Dependency _copy() {
        Dependency _x = new Dependency();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.requiredcomponentobjectid = requiredcomponentobjectid;
        _x.versionnumber = versionnumber;
        _x.requiredcomponentparentid = requiredcomponentparentid;
        _x.dependentcomponentbasesolutionid = dependentcomponentbasesolutionid;
        _x.dependentcomponenttype = dependentcomponenttype;
        _x.dependencyid = dependencyid;
        _x.dependentcomponentparentid = dependentcomponentparentid;
        _x._requiredcomponentnodeid_value = _requiredcomponentnodeid_value;
        _x._dependentcomponentnodeid_value = _dependentcomponentnodeid_value;
        _x.requiredcomponentbasesolutionid = requiredcomponentbasesolutionid;
        _x.dependencytype = dependencytype;
        _x.dependentcomponentobjectid = dependentcomponentobjectid;
        _x.requiredcomponentintroducedversion = requiredcomponentintroducedversion;
        _x.requiredcomponenttype = requiredcomponenttype;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Dependency[");
        b.append("requiredcomponentobjectid=");
        b.append(this.requiredcomponentobjectid);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("requiredcomponentparentid=");
        b.append(this.requiredcomponentparentid);
        b.append(", ");
        b.append("dependentcomponentbasesolutionid=");
        b.append(this.dependentcomponentbasesolutionid);
        b.append(", ");
        b.append("dependentcomponenttype=");
        b.append(this.dependentcomponenttype);
        b.append(", ");
        b.append("dependencyid=");
        b.append(this.dependencyid);
        b.append(", ");
        b.append("dependentcomponentparentid=");
        b.append(this.dependentcomponentparentid);
        b.append(", ");
        b.append("_requiredcomponentnodeid_value=");
        b.append(this._requiredcomponentnodeid_value);
        b.append(", ");
        b.append("_dependentcomponentnodeid_value=");
        b.append(this._dependentcomponentnodeid_value);
        b.append(", ");
        b.append("requiredcomponentbasesolutionid=");
        b.append(this.requiredcomponentbasesolutionid);
        b.append(", ");
        b.append("dependencytype=");
        b.append(this.dependencytype);
        b.append(", ");
        b.append("dependentcomponentobjectid=");
        b.append(this.dependentcomponentobjectid);
        b.append(", ");
        b.append("requiredcomponentintroducedversion=");
        b.append(this.requiredcomponentintroducedversion);
        b.append(", ");
        b.append("requiredcomponenttype=");
        b.append(this.requiredcomponenttype);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
