package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.request.CustomcontrolRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_organizationid_value", 
    "version", 
    "webresourceid", 
    "componentstate", 
    "versionnumber", 
    "customcontrolresourceid", 
    "versionrequirement", 
    "_modifiedonbehalfby_value", 
    "solutionid", 
    "overwritetime", 
    "modifiedon", 
    "_createdby_value", 
    "introducedversion", 
    "customcontrolresourceidunique", 
    "createdon", 
    "name", 
    "ismanaged", 
    "_createdonbehalfby_value", 
    "_modifiedby_value", 
    "customcontrolid"})
@JsonInclude(Include.NON_NULL)
public class Customcontrolresource extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.customcontrolresource";
    }

    @JsonProperty("_organizationid_value")
    protected UUID _organizationid_value;

    @JsonProperty("version")
    protected String version;

    @JsonProperty("webresourceid")
    protected UUID webresourceid;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("customcontrolresourceid")
    protected UUID customcontrolresourceid;

    @JsonProperty("versionrequirement")
    protected String versionrequirement;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("customcontrolresourceidunique")
    protected UUID customcontrolresourceidunique;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("customcontrolid")
    protected UUID customcontrolid;

    protected Customcontrolresource() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCustomcontrolresource() {
        return new Builder();
    }

    public static final class Builder {
        private UUID _organizationid_value;
        private String version;
        private UUID webresourceid;
        private Integer componentstate;
        private Long versionnumber;
        private UUID customcontrolresourceid;
        private String versionrequirement;
        private UUID _modifiedonbehalfby_value;
        private UUID solutionid;
        private OffsetDateTime overwritetime;
        private OffsetDateTime modifiedon;
        private UUID _createdby_value;
        private String introducedversion;
        private UUID customcontrolresourceidunique;
        private OffsetDateTime createdon;
        private String name;
        private Boolean ismanaged;
        private UUID _createdonbehalfby_value;
        private UUID _modifiedby_value;
        private UUID customcontrolid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _organizationid_value(UUID _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder webresourceid(UUID webresourceid) {
            this.webresourceid = webresourceid;
            this.changedFields = changedFields.add("webresourceid");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder customcontrolresourceid(UUID customcontrolresourceid) {
            this.customcontrolresourceid = customcontrolresourceid;
            this.changedFields = changedFields.add("customcontrolresourceid");
            return this;
        }

        public Builder versionrequirement(String versionrequirement) {
            this.versionrequirement = versionrequirement;
            this.changedFields = changedFields.add("versionrequirement");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder customcontrolresourceidunique(UUID customcontrolresourceidunique) {
            this.customcontrolresourceidunique = customcontrolresourceidunique;
            this.changedFields = changedFields.add("customcontrolresourceidunique");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder customcontrolid(UUID customcontrolid) {
            this.customcontrolid = customcontrolid;
            this.changedFields = changedFields.add("customcontrolid");
            return this;
        }

        public Customcontrolresource build() {
            Customcontrolresource _x = new Customcontrolresource();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.customcontrolresource";
            _x._organizationid_value = _organizationid_value;
            _x.version = version;
            _x.webresourceid = webresourceid;
            _x.componentstate = componentstate;
            _x.versionnumber = versionnumber;
            _x.customcontrolresourceid = customcontrolresourceid;
            _x.versionrequirement = versionrequirement;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.solutionid = solutionid;
            _x.overwritetime = overwritetime;
            _x.modifiedon = modifiedon;
            _x._createdby_value = _createdby_value;
            _x.introducedversion = introducedversion;
            _x.customcontrolresourceidunique = customcontrolresourceidunique;
            _x.createdon = createdon;
            _x.name = name;
            _x.ismanaged = ismanaged;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._modifiedby_value = _modifiedby_value;
            _x.customcontrolid = customcontrolid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && customcontrolresourceid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(customcontrolresourceid, UUID.class));
        }
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<UUID> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Customcontrolresource with_organizationid_value(UUID _organizationid_value) {
        Customcontrolresource _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrolresource");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    public Customcontrolresource withVersion(String version) {
        Customcontrolresource _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrolresource");
        _x.version = version;
        return _x;
    }

    @Property(name="webresourceid")
    @JsonIgnore
    public Optional<UUID> getWebresourceid() {
        return Optional.ofNullable(webresourceid);
    }

    public Customcontrolresource withWebresourceid(UUID webresourceid) {
        Customcontrolresource _x = _copy();
        _x.changedFields = changedFields.add("webresourceid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrolresource");
        _x.webresourceid = webresourceid;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Customcontrolresource withComponentstate(Integer componentstate) {
        Customcontrolresource _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrolresource");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Customcontrolresource withVersionnumber(Long versionnumber) {
        Customcontrolresource _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrolresource");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="customcontrolresourceid")
    @JsonIgnore
    public Optional<UUID> getCustomcontrolresourceid() {
        return Optional.ofNullable(customcontrolresourceid);
    }

    public Customcontrolresource withCustomcontrolresourceid(UUID customcontrolresourceid) {
        Customcontrolresource _x = _copy();
        _x.changedFields = changedFields.add("customcontrolresourceid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrolresource");
        _x.customcontrolresourceid = customcontrolresourceid;
        return _x;
    }

    @Property(name="versionrequirement")
    @JsonIgnore
    public Optional<String> getVersionrequirement() {
        return Optional.ofNullable(versionrequirement);
    }

    public Customcontrolresource withVersionrequirement(String versionrequirement) {
        Customcontrolresource _x = _copy();
        _x.changedFields = changedFields.add("versionrequirement");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrolresource");
        _x.versionrequirement = versionrequirement;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Customcontrolresource with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Customcontrolresource _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrolresource");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Customcontrolresource withSolutionid(UUID solutionid) {
        Customcontrolresource _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrolresource");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Customcontrolresource withOverwritetime(OffsetDateTime overwritetime) {
        Customcontrolresource _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrolresource");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Customcontrolresource withModifiedon(OffsetDateTime modifiedon) {
        Customcontrolresource _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrolresource");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Customcontrolresource with_createdby_value(UUID _createdby_value) {
        Customcontrolresource _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrolresource");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Customcontrolresource withIntroducedversion(String introducedversion) {
        Customcontrolresource _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrolresource");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="customcontrolresourceidunique")
    @JsonIgnore
    public Optional<UUID> getCustomcontrolresourceidunique() {
        return Optional.ofNullable(customcontrolresourceidunique);
    }

    public Customcontrolresource withCustomcontrolresourceidunique(UUID customcontrolresourceidunique) {
        Customcontrolresource _x = _copy();
        _x.changedFields = changedFields.add("customcontrolresourceidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrolresource");
        _x.customcontrolresourceidunique = customcontrolresourceidunique;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Customcontrolresource withCreatedon(OffsetDateTime createdon) {
        Customcontrolresource _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrolresource");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Customcontrolresource withName(String name) {
        Customcontrolresource _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrolresource");
        _x.name = name;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Customcontrolresource withIsmanaged(Boolean ismanaged) {
        Customcontrolresource _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrolresource");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Customcontrolresource with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Customcontrolresource _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrolresource");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Customcontrolresource with_modifiedby_value(UUID _modifiedby_value) {
        Customcontrolresource _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrolresource");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="customcontrolid")
    @JsonIgnore
    public Optional<UUID> getCustomcontrolid() {
        return Optional.ofNullable(customcontrolid);
    }

    public Customcontrolresource withCustomcontrolid(UUID customcontrolid) {
        Customcontrolresource _x = _copy();
        _x.changedFields = changedFields.add("customcontrolid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.customcontrolresource");
        _x.customcontrolid = customcontrolid;
        return _x;
    }

    public Customcontrolresource withUnmappedField(String name, Object value) {
        Customcontrolresource _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="customcontrolid_customcontrol")
    @JsonIgnore
    public CustomcontrolRequest getCustomcontrolid_customcontrol() {
        return new CustomcontrolRequest(contextPath.addSegment("customcontrolid_customcontrol"), RequestHelper.getValue(unmappedFields, "customcontrolid_customcontrol"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Customcontrolresource patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Customcontrolresource _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Customcontrolresource put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Customcontrolresource _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Customcontrolresource _copy() {
        Customcontrolresource _x = new Customcontrolresource();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._organizationid_value = _organizationid_value;
        _x.version = version;
        _x.webresourceid = webresourceid;
        _x.componentstate = componentstate;
        _x.versionnumber = versionnumber;
        _x.customcontrolresourceid = customcontrolresourceid;
        _x.versionrequirement = versionrequirement;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.solutionid = solutionid;
        _x.overwritetime = overwritetime;
        _x.modifiedon = modifiedon;
        _x._createdby_value = _createdby_value;
        _x.introducedversion = introducedversion;
        _x.customcontrolresourceidunique = customcontrolresourceidunique;
        _x.createdon = createdon;
        _x.name = name;
        _x.ismanaged = ismanaged;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._modifiedby_value = _modifiedby_value;
        _x.customcontrolid = customcontrolid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Customcontrolresource[");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("webresourceid=");
        b.append(this.webresourceid);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("customcontrolresourceid=");
        b.append(this.customcontrolresourceid);
        b.append(", ");
        b.append("versionrequirement=");
        b.append(this.versionrequirement);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("customcontrolresourceidunique=");
        b.append(this.customcontrolresourceidunique);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("customcontrolid=");
        b.append(this.customcontrolid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
