package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.request.OrganizationRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "versionnumber", 
    "_organizationid_value", 
    "complexcontrolid", 
    "ismanaged", 
    "version", 
    "name", 
    "componentstate", 
    "type", 
    "overwritetime", 
    "complexcontrolxml", 
    "introducedversion", 
    "complexcontrolidunique", 
    "solutionid", 
    "description"})
@JsonInclude(Include.NON_NULL)
public class Complexcontrol extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.complexcontrol";
    }

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_organizationid_value")
    protected UUID _organizationid_value;

    @JsonProperty("complexcontrolid")
    protected UUID complexcontrolid;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("version")
    protected Integer version;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("type")
    protected Integer type;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("complexcontrolxml")
    protected String complexcontrolxml;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("complexcontrolidunique")
    protected UUID complexcontrolidunique;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("description")
    protected String description;

    protected Complexcontrol() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderComplexcontrol() {
        return new Builder();
    }

    public static final class Builder {
        private Long versionnumber;
        private UUID _organizationid_value;
        private UUID complexcontrolid;
        private Boolean ismanaged;
        private Integer version;
        private String name;
        private Integer componentstate;
        private Integer type;
        private OffsetDateTime overwritetime;
        private String complexcontrolxml;
        private String introducedversion;
        private UUID complexcontrolidunique;
        private UUID solutionid;
        private String description;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _organizationid_value(UUID _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder complexcontrolid(UUID complexcontrolid) {
            this.complexcontrolid = complexcontrolid;
            this.changedFields = changedFields.add("complexcontrolid");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder type(Integer type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder complexcontrolxml(String complexcontrolxml) {
            this.complexcontrolxml = complexcontrolxml;
            this.changedFields = changedFields.add("complexcontrolxml");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder complexcontrolidunique(UUID complexcontrolidunique) {
            this.complexcontrolidunique = complexcontrolidunique;
            this.changedFields = changedFields.add("complexcontrolidunique");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Complexcontrol build() {
            Complexcontrol _x = new Complexcontrol();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.complexcontrol";
            _x.versionnumber = versionnumber;
            _x._organizationid_value = _organizationid_value;
            _x.complexcontrolid = complexcontrolid;
            _x.ismanaged = ismanaged;
            _x.version = version;
            _x.name = name;
            _x.componentstate = componentstate;
            _x.type = type;
            _x.overwritetime = overwritetime;
            _x.complexcontrolxml = complexcontrolxml;
            _x.introducedversion = introducedversion;
            _x.complexcontrolidunique = complexcontrolidunique;
            _x.solutionid = solutionid;
            _x.description = description;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && complexcontrolid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(complexcontrolid, UUID.class));
        }
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Complexcontrol withVersionnumber(Long versionnumber) {
        Complexcontrol _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.complexcontrol");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<UUID> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Complexcontrol with_organizationid_value(UUID _organizationid_value) {
        Complexcontrol _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.complexcontrol");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="complexcontrolid")
    @JsonIgnore
    public Optional<UUID> getComplexcontrolid() {
        return Optional.ofNullable(complexcontrolid);
    }

    public Complexcontrol withComplexcontrolid(UUID complexcontrolid) {
        Complexcontrol _x = _copy();
        _x.changedFields = changedFields.add("complexcontrolid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.complexcontrol");
        _x.complexcontrolid = complexcontrolid;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Complexcontrol withIsmanaged(Boolean ismanaged) {
        Complexcontrol _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.complexcontrol");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="version")
    @JsonIgnore
    public Optional<Integer> getVersion() {
        return Optional.ofNullable(version);
    }

    public Complexcontrol withVersion(Integer version) {
        Complexcontrol _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.complexcontrol");
        _x.version = version;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Complexcontrol withName(String name) {
        Complexcontrol _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.complexcontrol");
        _x.name = name;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Complexcontrol withComponentstate(Integer componentstate) {
        Complexcontrol _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.complexcontrol");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<Integer> getType() {
        return Optional.ofNullable(type);
    }

    public Complexcontrol withType(Integer type) {
        Complexcontrol _x = _copy();
        _x.changedFields = changedFields.add("type");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.complexcontrol");
        _x.type = type;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Complexcontrol withOverwritetime(OffsetDateTime overwritetime) {
        Complexcontrol _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.complexcontrol");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="complexcontrolxml")
    @JsonIgnore
    public Optional<String> getComplexcontrolxml() {
        return Optional.ofNullable(complexcontrolxml);
    }

    public Complexcontrol withComplexcontrolxml(String complexcontrolxml) {
        Complexcontrol _x = _copy();
        _x.changedFields = changedFields.add("complexcontrolxml");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.complexcontrol");
        _x.complexcontrolxml = complexcontrolxml;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Complexcontrol withIntroducedversion(String introducedversion) {
        Complexcontrol _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.complexcontrol");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="complexcontrolidunique")
    @JsonIgnore
    public Optional<UUID> getComplexcontrolidunique() {
        return Optional.ofNullable(complexcontrolidunique);
    }

    public Complexcontrol withComplexcontrolidunique(UUID complexcontrolidunique) {
        Complexcontrol _x = _copy();
        _x.changedFields = changedFields.add("complexcontrolidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.complexcontrol");
        _x.complexcontrolidunique = complexcontrolidunique;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Complexcontrol withSolutionid(UUID solutionid) {
        Complexcontrol _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.complexcontrol");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Complexcontrol withDescription(String description) {
        Complexcontrol _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.complexcontrol");
        _x.description = description;
        return _x;
    }

    public Complexcontrol withUnmappedField(String name, Object value) {
        Complexcontrol _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Complexcontrol patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Complexcontrol _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Complexcontrol put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Complexcontrol _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Complexcontrol _copy() {
        Complexcontrol _x = new Complexcontrol();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.versionnumber = versionnumber;
        _x._organizationid_value = _organizationid_value;
        _x.complexcontrolid = complexcontrolid;
        _x.ismanaged = ismanaged;
        _x.version = version;
        _x.name = name;
        _x.componentstate = componentstate;
        _x.type = type;
        _x.overwritetime = overwritetime;
        _x.complexcontrolxml = complexcontrolxml;
        _x.introducedversion = introducedversion;
        _x.complexcontrolidunique = complexcontrolidunique;
        _x.solutionid = solutionid;
        _x.description = description;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Complexcontrol[");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("complexcontrolid=");
        b.append(this.complexcontrolid);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("complexcontrolxml=");
        b.append(this.complexcontrolxml);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("complexcontrolidunique=");
        b.append(this.complexcontrolidunique);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
