package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.ExpandCalendarResponse;
import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BusinessunitCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.CalendarCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.CalendarruleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.OrganizationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SlaCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SlaitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SystemuserCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.CalendarRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "name", 
    "_modifiedonbehalfby_value", 
    "type", 
    "primaryuserid", 
    "_createdonbehalfby_value", 
    "_businessunitid_value", 
    "description", 
    "versionnumber", 
    "createdon", 
    "modifiedon", 
    "_holidayschedulecalendarid_value", 
    "calendarid", 
    "_createdby_value", 
    "isshared", 
    "_organizationid_value", 
    "_modifiedby_value"})
@JsonInclude(Include.NON_NULL)
public class Calendar extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.calendar";
    }

    @JsonProperty("name")
    protected String name;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("type")
    protected Integer type;

    @JsonProperty("primaryuserid")
    protected UUID primaryuserid;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("_businessunitid_value")
    protected UUID _businessunitid_value;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_holidayschedulecalendarid_value")
    protected UUID _holidayschedulecalendarid_value;

    @JsonProperty("calendarid")
    protected UUID calendarid;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("isshared")
    protected Boolean isshared;

    @JsonProperty("_organizationid_value")
    protected UUID _organizationid_value;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    protected Calendar() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCalendar() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private UUID _modifiedonbehalfby_value;
        private Integer type;
        private UUID primaryuserid;
        private UUID _createdonbehalfby_value;
        private UUID _businessunitid_value;
        private String description;
        private Long versionnumber;
        private OffsetDateTime createdon;
        private OffsetDateTime modifiedon;
        private UUID _holidayschedulecalendarid_value;
        private UUID calendarid;
        private UUID _createdby_value;
        private Boolean isshared;
        private UUID _organizationid_value;
        private UUID _modifiedby_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder type(Integer type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder primaryuserid(UUID primaryuserid) {
            this.primaryuserid = primaryuserid;
            this.changedFields = changedFields.add("primaryuserid");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _businessunitid_value(UUID _businessunitid_value) {
            this._businessunitid_value = _businessunitid_value;
            this.changedFields = changedFields.add("_businessunitid_value");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _holidayschedulecalendarid_value(UUID _holidayschedulecalendarid_value) {
            this._holidayschedulecalendarid_value = _holidayschedulecalendarid_value;
            this.changedFields = changedFields.add("_holidayschedulecalendarid_value");
            return this;
        }

        public Builder calendarid(UUID calendarid) {
            this.calendarid = calendarid;
            this.changedFields = changedFields.add("calendarid");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder isshared(Boolean isshared) {
            this.isshared = isshared;
            this.changedFields = changedFields.add("isshared");
            return this;
        }

        public Builder _organizationid_value(UUID _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Calendar build() {
            Calendar _x = new Calendar();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.calendar";
            _x.name = name;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.type = type;
            _x.primaryuserid = primaryuserid;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._businessunitid_value = _businessunitid_value;
            _x.description = description;
            _x.versionnumber = versionnumber;
            _x.createdon = createdon;
            _x.modifiedon = modifiedon;
            _x._holidayschedulecalendarid_value = _holidayschedulecalendarid_value;
            _x.calendarid = calendarid;
            _x._createdby_value = _createdby_value;
            _x.isshared = isshared;
            _x._organizationid_value = _organizationid_value;
            _x._modifiedby_value = _modifiedby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && calendarid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(calendarid, UUID.class));
        }
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Calendar withName(String name) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendar");
        _x.name = name;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Calendar with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendar");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<Integer> getType() {
        return Optional.ofNullable(type);
    }

    public Calendar withType(Integer type) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("type");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendar");
        _x.type = type;
        return _x;
    }

    @Property(name="primaryuserid")
    @JsonIgnore
    public Optional<UUID> getPrimaryuserid() {
        return Optional.ofNullable(primaryuserid);
    }

    public Calendar withPrimaryuserid(UUID primaryuserid) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("primaryuserid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendar");
        _x.primaryuserid = primaryuserid;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Calendar with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendar");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_businessunitid_value")
    @JsonIgnore
    public Optional<UUID> get_businessunitid_value() {
        return Optional.ofNullable(_businessunitid_value);
    }

    public Calendar with_businessunitid_value(UUID _businessunitid_value) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("_businessunitid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendar");
        _x._businessunitid_value = _businessunitid_value;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Calendar withDescription(String description) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendar");
        _x.description = description;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Calendar withVersionnumber(Long versionnumber) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendar");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Calendar withCreatedon(OffsetDateTime createdon) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendar");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Calendar withModifiedon(OffsetDateTime modifiedon) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendar");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_holidayschedulecalendarid_value")
    @JsonIgnore
    public Optional<UUID> get_holidayschedulecalendarid_value() {
        return Optional.ofNullable(_holidayschedulecalendarid_value);
    }

    public Calendar with_holidayschedulecalendarid_value(UUID _holidayschedulecalendarid_value) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("_holidayschedulecalendarid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendar");
        _x._holidayschedulecalendarid_value = _holidayschedulecalendarid_value;
        return _x;
    }

    @Property(name="calendarid")
    @JsonIgnore
    public Optional<UUID> getCalendarid() {
        return Optional.ofNullable(calendarid);
    }

    public Calendar withCalendarid(UUID calendarid) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("calendarid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendar");
        _x.calendarid = calendarid;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Calendar with_createdby_value(UUID _createdby_value) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendar");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="isshared")
    @JsonIgnore
    public Optional<Boolean> getIsshared() {
        return Optional.ofNullable(isshared);
    }

    public Calendar withIsshared(Boolean isshared) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("isshared");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendar");
        _x.isshared = isshared;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<UUID> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Calendar with_organizationid_value(UUID _organizationid_value) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendar");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Calendar with_modifiedby_value(UUID _modifiedby_value) {
        Calendar _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.calendar");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    public Calendar withUnmappedField(String name, Object value) {
        Calendar _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="calendar_calendar_rules")
    @JsonIgnore
    public CalendarruleCollectionRequest getCalendar_calendar_rules() {
        return new CalendarruleCollectionRequest(
                        contextPath.addSegment("calendar_calendar_rules"), RequestHelper.getValue(unmappedFields, "calendar_calendar_rules"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="Calendar_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getCalendar_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("Calendar_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "Calendar_BulkDeleteFailures"));
    }

    @NavigationProperty(name="slabase_businesshoursid")
    @JsonIgnore
    public SlaCollectionRequest getSlabase_businesshoursid() {
        return new SlaCollectionRequest(
                        contextPath.addSegment("slabase_businesshoursid"), RequestHelper.getValue(unmappedFields, "slabase_businesshoursid"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="calendar_organization")
    @JsonIgnore
    public OrganizationCollectionRequest getCalendar_organization() {
        return new OrganizationCollectionRequest(
                        contextPath.addSegment("calendar_organization"), RequestHelper.getValue(unmappedFields, "calendar_organization"));
    }

    @NavigationProperty(name="businessunitid")
    @JsonIgnore
    public BusinessunitRequest getBusinessunitid() {
        return new BusinessunitRequest(contextPath.addSegment("businessunitid"), RequestHelper.getValue(unmappedFields, "businessunitid"));
    }

    @NavigationProperty(name="BusinessUnit_Calendar")
    @JsonIgnore
    public BusinessunitCollectionRequest getBusinessUnit_Calendar() {
        return new BusinessunitCollectionRequest(
                        contextPath.addSegment("BusinessUnit_Calendar"), RequestHelper.getValue(unmappedFields, "BusinessUnit_Calendar"));
    }

    @NavigationProperty(name="Calendar_Annotation")
    @JsonIgnore
    public AnnotationCollectionRequest getCalendar_Annotation() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("Calendar_Annotation"), RequestHelper.getValue(unmappedFields, "Calendar_Annotation"));
    }

    @NavigationProperty(name="holidayschedulecalendarid")
    @JsonIgnore
    public CalendarRequest getHolidayschedulecalendarid() {
        return new CalendarRequest(contextPath.addSegment("holidayschedulecalendarid"), RequestHelper.getValue(unmappedFields, "holidayschedulecalendarid"));
    }

    @NavigationProperty(name="calendar_customercalendar_holidaycalendar")
    @JsonIgnore
    public CalendarCollectionRequest getCalendar_customercalendar_holidaycalendar() {
        return new CalendarCollectionRequest(
                        contextPath.addSegment("calendar_customercalendar_holidaycalendar"), RequestHelper.getValue(unmappedFields, "calendar_customercalendar_holidaycalendar"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="calendar_system_users")
    @JsonIgnore
    public SystemuserCollectionRequest getCalendar_system_users() {
        return new SystemuserCollectionRequest(
                        contextPath.addSegment("calendar_system_users"), RequestHelper.getValue(unmappedFields, "calendar_system_users"));
    }

    @NavigationProperty(name="Calendar_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getCalendar_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Calendar_AsyncOperations"), RequestHelper.getValue(unmappedFields, "Calendar_AsyncOperations"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="inner_calendar_calendar_rules")
    @JsonIgnore
    public CalendarruleCollectionRequest getInner_calendar_calendar_rules() {
        return new CalendarruleCollectionRequest(
                        contextPath.addSegment("inner_calendar_calendar_rules"), RequestHelper.getValue(unmappedFields, "inner_calendar_calendar_rules"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="calendar_slaitem")
    @JsonIgnore
    public SlaitemCollectionRequest getCalendar_slaitem() {
        return new SlaitemCollectionRequest(
                        contextPath.addSegment("calendar_slaitem"), RequestHelper.getValue(unmappedFields, "calendar_slaitem"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Calendar patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Calendar _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Calendar put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Calendar _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Calendar _copy() {
        Calendar _x = new Calendar();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.name = name;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.type = type;
        _x.primaryuserid = primaryuserid;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._businessunitid_value = _businessunitid_value;
        _x.description = description;
        _x.versionnumber = versionnumber;
        _x.createdon = createdon;
        _x.modifiedon = modifiedon;
        _x._holidayschedulecalendarid_value = _holidayschedulecalendarid_value;
        _x.calendarid = calendarid;
        _x._createdby_value = _createdby_value;
        _x.isshared = isshared;
        _x._organizationid_value = _organizationid_value;
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Function(name = "ExpandCalendar")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<ExpandCalendarResponse> expandCalendar(OffsetDateTime start, OffsetDateTime end) {
        Preconditions.checkNotNull(start, "start cannot be null");
        Preconditions.checkNotNull(end, "end cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Start", "Edm.DateTimeOffset", start)
            .put("End", "Edm.DateTimeOffset", end)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<ExpandCalendarResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ExpandCalendar"), ExpandCalendarResponse.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Calendar[");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("primaryuserid=");
        b.append(this.primaryuserid);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_businessunitid_value=");
        b.append(this._businessunitid_value);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_holidayschedulecalendarid_value=");
        b.append(this._holidayschedulecalendarid_value);
        b.append(", ");
        b.append("calendarid=");
        b.append(this.calendarid);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("isshared=");
        b.append(this.isshared);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
