package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_createdby_value", 
    "nextrun", 
    "_modifiedonbehalfby_value", 
    "createdon", 
    "_asyncoperationid_value", 
    "bulkdeleteoperationid", 
    "successcount", 
    "_owninguser_value", 
    "_modifiedby_value", 
    "failurecount", 
    "processingqeindex", 
    "utcconversiontimezonecode", 
    "timezoneruleversionnumber", 
    "name", 
    "_owningbusinessunit_value", 
    "statecode", 
    "_ownerid_value", 
    "isrecurring", 
    "statuscode", 
    "_createdonbehalfby_value", 
    "modifiedon", 
    "orderedquerysetxml"})
@JsonInclude(Include.NON_NULL)
public class Bulkdeleteoperation extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.bulkdeleteoperation";
    }

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("nextrun")
    protected OffsetDateTime nextrun;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_asyncoperationid_value")
    protected UUID _asyncoperationid_value;

    @JsonProperty("bulkdeleteoperationid")
    protected UUID bulkdeleteoperationid;

    @JsonProperty("successcount")
    protected Integer successcount;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("failurecount")
    protected Integer failurecount;

    @JsonProperty("processingqeindex")
    protected Integer processingqeindex;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("isrecurring")
    protected Boolean isrecurring;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("orderedquerysetxml")
    protected String orderedquerysetxml;

    protected Bulkdeleteoperation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderBulkdeleteoperation() {
        return new Builder();
    }

    public static final class Builder {
        private UUID _createdby_value;
        private OffsetDateTime nextrun;
        private UUID _modifiedonbehalfby_value;
        private OffsetDateTime createdon;
        private UUID _asyncoperationid_value;
        private UUID bulkdeleteoperationid;
        private Integer successcount;
        private UUID _owninguser_value;
        private UUID _modifiedby_value;
        private Integer failurecount;
        private Integer processingqeindex;
        private Integer utcconversiontimezonecode;
        private Integer timezoneruleversionnumber;
        private String name;
        private UUID _owningbusinessunit_value;
        private Integer statecode;
        private UUID _ownerid_value;
        private Boolean isrecurring;
        private Integer statuscode;
        private UUID _createdonbehalfby_value;
        private OffsetDateTime modifiedon;
        private String orderedquerysetxml;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder nextrun(OffsetDateTime nextrun) {
            this.nextrun = nextrun;
            this.changedFields = changedFields.add("nextrun");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _asyncoperationid_value(UUID _asyncoperationid_value) {
            this._asyncoperationid_value = _asyncoperationid_value;
            this.changedFields = changedFields.add("_asyncoperationid_value");
            return this;
        }

        public Builder bulkdeleteoperationid(UUID bulkdeleteoperationid) {
            this.bulkdeleteoperationid = bulkdeleteoperationid;
            this.changedFields = changedFields.add("bulkdeleteoperationid");
            return this;
        }

        public Builder successcount(Integer successcount) {
            this.successcount = successcount;
            this.changedFields = changedFields.add("successcount");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder failurecount(Integer failurecount) {
            this.failurecount = failurecount;
            this.changedFields = changedFields.add("failurecount");
            return this;
        }

        public Builder processingqeindex(Integer processingqeindex) {
            this.processingqeindex = processingqeindex;
            this.changedFields = changedFields.add("processingqeindex");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder isrecurring(Boolean isrecurring) {
            this.isrecurring = isrecurring;
            this.changedFields = changedFields.add("isrecurring");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder orderedquerysetxml(String orderedquerysetxml) {
            this.orderedquerysetxml = orderedquerysetxml;
            this.changedFields = changedFields.add("orderedquerysetxml");
            return this;
        }

        public Bulkdeleteoperation build() {
            Bulkdeleteoperation _x = new Bulkdeleteoperation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.bulkdeleteoperation";
            _x._createdby_value = _createdby_value;
            _x.nextrun = nextrun;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.createdon = createdon;
            _x._asyncoperationid_value = _asyncoperationid_value;
            _x.bulkdeleteoperationid = bulkdeleteoperationid;
            _x.successcount = successcount;
            _x._owninguser_value = _owninguser_value;
            _x._modifiedby_value = _modifiedby_value;
            _x.failurecount = failurecount;
            _x.processingqeindex = processingqeindex;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.name = name;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.statecode = statecode;
            _x._ownerid_value = _ownerid_value;
            _x.isrecurring = isrecurring;
            _x.statuscode = statuscode;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.modifiedon = modifiedon;
            _x.orderedquerysetxml = orderedquerysetxml;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && bulkdeleteoperationid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(bulkdeleteoperationid, UUID.class));
        }
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Bulkdeleteoperation with_createdby_value(UUID _createdby_value) {
        Bulkdeleteoperation _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeleteoperation");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="nextrun")
    @JsonIgnore
    public Optional<OffsetDateTime> getNextrun() {
        return Optional.ofNullable(nextrun);
    }

    public Bulkdeleteoperation withNextrun(OffsetDateTime nextrun) {
        Bulkdeleteoperation _x = _copy();
        _x.changedFields = changedFields.add("nextrun");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeleteoperation");
        _x.nextrun = nextrun;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Bulkdeleteoperation with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Bulkdeleteoperation _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeleteoperation");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Bulkdeleteoperation withCreatedon(OffsetDateTime createdon) {
        Bulkdeleteoperation _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeleteoperation");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_asyncoperationid_value")
    @JsonIgnore
    public Optional<UUID> get_asyncoperationid_value() {
        return Optional.ofNullable(_asyncoperationid_value);
    }

    public Bulkdeleteoperation with_asyncoperationid_value(UUID _asyncoperationid_value) {
        Bulkdeleteoperation _x = _copy();
        _x.changedFields = changedFields.add("_asyncoperationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeleteoperation");
        _x._asyncoperationid_value = _asyncoperationid_value;
        return _x;
    }

    @Property(name="bulkdeleteoperationid")
    @JsonIgnore
    public Optional<UUID> getBulkdeleteoperationid() {
        return Optional.ofNullable(bulkdeleteoperationid);
    }

    public Bulkdeleteoperation withBulkdeleteoperationid(UUID bulkdeleteoperationid) {
        Bulkdeleteoperation _x = _copy();
        _x.changedFields = changedFields.add("bulkdeleteoperationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeleteoperation");
        _x.bulkdeleteoperationid = bulkdeleteoperationid;
        return _x;
    }

    @Property(name="successcount")
    @JsonIgnore
    public Optional<Integer> getSuccesscount() {
        return Optional.ofNullable(successcount);
    }

    public Bulkdeleteoperation withSuccesscount(Integer successcount) {
        Bulkdeleteoperation _x = _copy();
        _x.changedFields = changedFields.add("successcount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeleteoperation");
        _x.successcount = successcount;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Bulkdeleteoperation with_owninguser_value(UUID _owninguser_value) {
        Bulkdeleteoperation _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeleteoperation");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Bulkdeleteoperation with_modifiedby_value(UUID _modifiedby_value) {
        Bulkdeleteoperation _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeleteoperation");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="failurecount")
    @JsonIgnore
    public Optional<Integer> getFailurecount() {
        return Optional.ofNullable(failurecount);
    }

    public Bulkdeleteoperation withFailurecount(Integer failurecount) {
        Bulkdeleteoperation _x = _copy();
        _x.changedFields = changedFields.add("failurecount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeleteoperation");
        _x.failurecount = failurecount;
        return _x;
    }

    @Property(name="processingqeindex")
    @JsonIgnore
    public Optional<Integer> getProcessingqeindex() {
        return Optional.ofNullable(processingqeindex);
    }

    public Bulkdeleteoperation withProcessingqeindex(Integer processingqeindex) {
        Bulkdeleteoperation _x = _copy();
        _x.changedFields = changedFields.add("processingqeindex");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeleteoperation");
        _x.processingqeindex = processingqeindex;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Bulkdeleteoperation withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Bulkdeleteoperation _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeleteoperation");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Bulkdeleteoperation withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Bulkdeleteoperation _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeleteoperation");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Bulkdeleteoperation withName(String name) {
        Bulkdeleteoperation _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeleteoperation");
        _x.name = name;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Bulkdeleteoperation with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Bulkdeleteoperation _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeleteoperation");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Bulkdeleteoperation withStatecode(Integer statecode) {
        Bulkdeleteoperation _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeleteoperation");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Bulkdeleteoperation with_ownerid_value(UUID _ownerid_value) {
        Bulkdeleteoperation _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeleteoperation");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="isrecurring")
    @JsonIgnore
    public Optional<Boolean> getIsrecurring() {
        return Optional.ofNullable(isrecurring);
    }

    public Bulkdeleteoperation withIsrecurring(Boolean isrecurring) {
        Bulkdeleteoperation _x = _copy();
        _x.changedFields = changedFields.add("isrecurring");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeleteoperation");
        _x.isrecurring = isrecurring;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Bulkdeleteoperation withStatuscode(Integer statuscode) {
        Bulkdeleteoperation _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeleteoperation");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Bulkdeleteoperation with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Bulkdeleteoperation _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeleteoperation");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Bulkdeleteoperation withModifiedon(OffsetDateTime modifiedon) {
        Bulkdeleteoperation _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeleteoperation");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="orderedquerysetxml")
    @JsonIgnore
    public Optional<String> getOrderedquerysetxml() {
        return Optional.ofNullable(orderedquerysetxml);
    }

    public Bulkdeleteoperation withOrderedquerysetxml(String orderedquerysetxml) {
        Bulkdeleteoperation _x = _copy();
        _x.changedFields = changedFields.add("orderedquerysetxml");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.bulkdeleteoperation");
        _x.orderedquerysetxml = orderedquerysetxml;
        return _x;
    }

    public Bulkdeleteoperation withUnmappedField(String name, Object value) {
        Bulkdeleteoperation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="asyncoperationid")
    @JsonIgnore
    public AsyncoperationRequest getAsyncoperationid() {
        return new AsyncoperationRequest(contextPath.addSegment("asyncoperationid"), RequestHelper.getValue(unmappedFields, "asyncoperationid"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="BulkDeleteOperation_BulkDeleteFailure")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getBulkDeleteOperation_BulkDeleteFailure() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("BulkDeleteOperation_BulkDeleteFailure"), RequestHelper.getValue(unmappedFields, "BulkDeleteOperation_BulkDeleteFailure"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Bulkdeleteoperation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Bulkdeleteoperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Bulkdeleteoperation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Bulkdeleteoperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Bulkdeleteoperation _copy() {
        Bulkdeleteoperation _x = new Bulkdeleteoperation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._createdby_value = _createdby_value;
        _x.nextrun = nextrun;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.createdon = createdon;
        _x._asyncoperationid_value = _asyncoperationid_value;
        _x.bulkdeleteoperationid = bulkdeleteoperationid;
        _x.successcount = successcount;
        _x._owninguser_value = _owninguser_value;
        _x._modifiedby_value = _modifiedby_value;
        _x.failurecount = failurecount;
        _x.processingqeindex = processingqeindex;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.name = name;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.statecode = statecode;
        _x._ownerid_value = _ownerid_value;
        _x.isrecurring = isrecurring;
        _x.statuscode = statuscode;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.modifiedon = modifiedon;
        _x.orderedquerysetxml = orderedquerysetxml;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Bulkdeleteoperation[");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("nextrun=");
        b.append(this.nextrun);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_asyncoperationid_value=");
        b.append(this._asyncoperationid_value);
        b.append(", ");
        b.append("bulkdeleteoperationid=");
        b.append(this.bulkdeleteoperationid);
        b.append(", ");
        b.append("successcount=");
        b.append(this.successcount);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("failurecount=");
        b.append(this.failurecount);
        b.append(", ");
        b.append("processingqeindex=");
        b.append(this.processingqeindex);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("isrecurring=");
        b.append(this.isrecurring);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("orderedquerysetxml=");
        b.append(this.orderedquerysetxml);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
