package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.AccountRequest;
import microsoft.dynamics.crm.entity.request.AppointmentRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.CalendarRequest;
import microsoft.dynamics.crm.entity.request.ContactRequest;
import microsoft.dynamics.crm.entity.request.DuplicateruleRequest;
import microsoft.dynamics.crm.entity.request.EmailRequest;
import microsoft.dynamics.crm.entity.request.EmailserverprofileRequest;
import microsoft.dynamics.crm.entity.request.FaxRequest;
import microsoft.dynamics.crm.entity.request.GoalRequest;
import microsoft.dynamics.crm.entity.request.KbarticleRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleRequest;
import microsoft.dynamics.crm.entity.request.KnowledgebaserecordRequest;
import microsoft.dynamics.crm.entity.request.LetterRequest;
import microsoft.dynamics.crm.entity.request.MailboxRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aifptrainingdocumentRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aimodelRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodimageRequest;
import microsoft.dynamics.crm.entity.request.PhonecallRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.RecurringappointmentmasterRequest;
import microsoft.dynamics.crm.entity.request.SlaRequest;
import microsoft.dynamics.crm.entity.request.SocialactivityRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TaskRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.entity.request.WorkflowRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "importsequencenumber", 
    "_modifiedby_value", 
    "_owningbusinessunit_value", 
    "notetext", 
    "_objectid_value", 
    "objecttypecode", 
    "createdon", 
    "dummyregarding", 
    "dummyfilename", 
    "annotationid", 
    "mimetype", 
    "_createdonbehalfby_value", 
    "_createdby_value", 
    "prefix", 
    "modifiedon", 
    "_ownerid_value", 
    "_modifiedonbehalfby_value", 
    "langid", 
    "documentbody", 
    "documentbody_binary", 
    "isdocument", 
    "_owningteam_value", 
    "versionnumber", 
    "filesize", 
    "_owninguser_value", 
    "stepid", 
    "filename", 
    "overriddencreatedon", 
    "subject"})
@JsonInclude(Include.NON_NULL)
public class Annotation extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.annotation";
    }

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("notetext")
    protected String notetext;

    @JsonProperty("_objectid_value")
    protected UUID _objectid_value;

    @JsonProperty("objecttypecode")
    protected String objecttypecode;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("dummyregarding")
    protected String dummyregarding;

    @JsonProperty("dummyfilename")
    protected String dummyfilename;

    @JsonProperty("annotationid")
    protected UUID annotationid;

    @JsonProperty("mimetype")
    protected String mimetype;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("prefix")
    protected String prefix;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("langid")
    protected String langid;

    @JsonProperty("documentbody")
    protected String documentbody;

    @JsonProperty("documentbody_binary")
    protected byte[] documentbody_binary;

    @JsonProperty("isdocument")
    protected Boolean isdocument;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("filesize")
    protected Integer filesize;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("stepid")
    protected String stepid;

    @JsonProperty("filename")
    protected String filename;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("subject")
    protected String subject;

    protected Annotation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAnnotation() {
        return new Builder();
    }

    public static final class Builder {
        private Integer importsequencenumber;
        private UUID _modifiedby_value;
        private UUID _owningbusinessunit_value;
        private String notetext;
        private UUID _objectid_value;
        private String objecttypecode;
        private OffsetDateTime createdon;
        private String dummyregarding;
        private String dummyfilename;
        private UUID annotationid;
        private String mimetype;
        private UUID _createdonbehalfby_value;
        private UUID _createdby_value;
        private String prefix;
        private OffsetDateTime modifiedon;
        private UUID _ownerid_value;
        private UUID _modifiedonbehalfby_value;
        private String langid;
        private String documentbody;
        private byte[] documentbody_binary;
        private Boolean isdocument;
        private UUID _owningteam_value;
        private Long versionnumber;
        private Integer filesize;
        private UUID _owninguser_value;
        private String stepid;
        private String filename;
        private OffsetDateTime overriddencreatedon;
        private String subject;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder notetext(String notetext) {
            this.notetext = notetext;
            this.changedFields = changedFields.add("notetext");
            return this;
        }

        public Builder _objectid_value(UUID _objectid_value) {
            this._objectid_value = _objectid_value;
            this.changedFields = changedFields.add("_objectid_value");
            return this;
        }

        public Builder objecttypecode(String objecttypecode) {
            this.objecttypecode = objecttypecode;
            this.changedFields = changedFields.add("objecttypecode");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder dummyregarding(String dummyregarding) {
            this.dummyregarding = dummyregarding;
            this.changedFields = changedFields.add("dummyregarding");
            return this;
        }

        public Builder dummyfilename(String dummyfilename) {
            this.dummyfilename = dummyfilename;
            this.changedFields = changedFields.add("dummyfilename");
            return this;
        }

        public Builder annotationid(UUID annotationid) {
            this.annotationid = annotationid;
            this.changedFields = changedFields.add("annotationid");
            return this;
        }

        public Builder mimetype(String mimetype) {
            this.mimetype = mimetype;
            this.changedFields = changedFields.add("mimetype");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            this.changedFields = changedFields.add("prefix");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder langid(String langid) {
            this.langid = langid;
            this.changedFields = changedFields.add("langid");
            return this;
        }

        public Builder documentbody(String documentbody) {
            this.documentbody = documentbody;
            this.changedFields = changedFields.add("documentbody");
            return this;
        }

        public Builder documentbody_binary(byte[] documentbody_binary) {
            this.documentbody_binary = documentbody_binary;
            this.changedFields = changedFields.add("documentbody_binary");
            return this;
        }

        public Builder isdocument(Boolean isdocument) {
            this.isdocument = isdocument;
            this.changedFields = changedFields.add("isdocument");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder filesize(Integer filesize) {
            this.filesize = filesize;
            this.changedFields = changedFields.add("filesize");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder stepid(String stepid) {
            this.stepid = stepid;
            this.changedFields = changedFields.add("stepid");
            return this;
        }

        public Builder filename(String filename) {
            this.filename = filename;
            this.changedFields = changedFields.add("filename");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            this.changedFields = changedFields.add("subject");
            return this;
        }

        public Annotation build() {
            Annotation _x = new Annotation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.annotation";
            _x.importsequencenumber = importsequencenumber;
            _x._modifiedby_value = _modifiedby_value;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.notetext = notetext;
            _x._objectid_value = _objectid_value;
            _x.objecttypecode = objecttypecode;
            _x.createdon = createdon;
            _x.dummyregarding = dummyregarding;
            _x.dummyfilename = dummyfilename;
            _x.annotationid = annotationid;
            _x.mimetype = mimetype;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._createdby_value = _createdby_value;
            _x.prefix = prefix;
            _x.modifiedon = modifiedon;
            _x._ownerid_value = _ownerid_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.langid = langid;
            _x.documentbody = documentbody;
            _x.documentbody_binary = documentbody_binary;
            _x.isdocument = isdocument;
            _x._owningteam_value = _owningteam_value;
            _x.versionnumber = versionnumber;
            _x.filesize = filesize;
            _x._owninguser_value = _owninguser_value;
            _x.stepid = stepid;
            _x.filename = filename;
            _x.overriddencreatedon = overriddencreatedon;
            _x.subject = subject;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && annotationid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(annotationid, UUID.class));
        }
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Annotation withImportsequencenumber(Integer importsequencenumber) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Annotation with_modifiedby_value(UUID _modifiedby_value) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Annotation with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="notetext")
    @JsonIgnore
    public Optional<String> getNotetext() {
        return Optional.ofNullable(notetext);
    }

    public Annotation withNotetext(String notetext) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("notetext");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x.notetext = notetext;
        return _x;
    }

    @Property(name="_objectid_value")
    @JsonIgnore
    public Optional<UUID> get_objectid_value() {
        return Optional.ofNullable(_objectid_value);
    }

    public Annotation with_objectid_value(UUID _objectid_value) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("_objectid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x._objectid_value = _objectid_value;
        return _x;
    }

    @Property(name="objecttypecode")
    @JsonIgnore
    public Optional<String> getObjecttypecode() {
        return Optional.ofNullable(objecttypecode);
    }

    public Annotation withObjecttypecode(String objecttypecode) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("objecttypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x.objecttypecode = objecttypecode;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Annotation withCreatedon(OffsetDateTime createdon) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="dummyregarding")
    @JsonIgnore
    public Optional<String> getDummyregarding() {
        return Optional.ofNullable(dummyregarding);
    }

    public Annotation withDummyregarding(String dummyregarding) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("dummyregarding");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x.dummyregarding = dummyregarding;
        return _x;
    }

    @Property(name="dummyfilename")
    @JsonIgnore
    public Optional<String> getDummyfilename() {
        return Optional.ofNullable(dummyfilename);
    }

    public Annotation withDummyfilename(String dummyfilename) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("dummyfilename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x.dummyfilename = dummyfilename;
        return _x;
    }

    @Property(name="annotationid")
    @JsonIgnore
    public Optional<UUID> getAnnotationid() {
        return Optional.ofNullable(annotationid);
    }

    public Annotation withAnnotationid(UUID annotationid) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("annotationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x.annotationid = annotationid;
        return _x;
    }

    @Property(name="mimetype")
    @JsonIgnore
    public Optional<String> getMimetype() {
        return Optional.ofNullable(mimetype);
    }

    public Annotation withMimetype(String mimetype) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("mimetype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x.mimetype = mimetype;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Annotation with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Annotation with_createdby_value(UUID _createdby_value) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="prefix")
    @JsonIgnore
    public Optional<String> getPrefix() {
        return Optional.ofNullable(prefix);
    }

    public Annotation withPrefix(String prefix) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("prefix");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x.prefix = prefix;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Annotation withModifiedon(OffsetDateTime modifiedon) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Annotation with_ownerid_value(UUID _ownerid_value) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Annotation with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="langid")
    @JsonIgnore
    public Optional<String> getLangid() {
        return Optional.ofNullable(langid);
    }

    public Annotation withLangid(String langid) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("langid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x.langid = langid;
        return _x;
    }

    @Property(name="documentbody")
    @JsonIgnore
    public Optional<String> getDocumentbody() {
        return Optional.ofNullable(documentbody);
    }

    public Annotation withDocumentbody(String documentbody) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("documentbody");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x.documentbody = documentbody;
        return _x;
    }

    @Property(name="documentbody_binary")
    @JsonIgnore
    public Optional<byte[]> getDocumentbody_binary() {
        return Optional.ofNullable(documentbody_binary);
    }

    public Annotation withDocumentbody_binary(byte[] documentbody_binary) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("documentbody_binary");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x.documentbody_binary = documentbody_binary;
        return _x;
    }

    @Property(name="isdocument")
    @JsonIgnore
    public Optional<Boolean> getIsdocument() {
        return Optional.ofNullable(isdocument);
    }

    public Annotation withIsdocument(Boolean isdocument) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("isdocument");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x.isdocument = isdocument;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Annotation with_owningteam_value(UUID _owningteam_value) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Annotation withVersionnumber(Long versionnumber) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="filesize")
    @JsonIgnore
    public Optional<Integer> getFilesize() {
        return Optional.ofNullable(filesize);
    }

    public Annotation withFilesize(Integer filesize) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("filesize");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x.filesize = filesize;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Annotation with_owninguser_value(UUID _owninguser_value) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="stepid")
    @JsonIgnore
    public Optional<String> getStepid() {
        return Optional.ofNullable(stepid);
    }

    public Annotation withStepid(String stepid) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("stepid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x.stepid = stepid;
        return _x;
    }

    @Property(name="filename")
    @JsonIgnore
    public Optional<String> getFilename() {
        return Optional.ofNullable(filename);
    }

    public Annotation withFilename(String filename) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("filename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x.filename = filename;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Annotation withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="subject")
    @JsonIgnore
    public Optional<String> getSubject() {
        return Optional.ofNullable(subject);
    }

    public Annotation withSubject(String subject) {
        Annotation _x = _copy();
        _x.changedFields = changedFields.add("subject");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annotation");
        _x.subject = subject;
        return _x;
    }

    public Annotation withUnmappedField(String name, Object value) {
        Annotation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="objectid_knowledgearticle")
    @JsonIgnore
    public KnowledgearticleRequest getObjectid_knowledgearticle() {
        return new KnowledgearticleRequest(contextPath.addSegment("objectid_knowledgearticle"), RequestHelper.getValue(unmappedFields, "objectid_knowledgearticle"));
    }

    @NavigationProperty(name="objectid_knowledgebaserecord")
    @JsonIgnore
    public KnowledgebaserecordRequest getObjectid_knowledgebaserecord() {
        return new KnowledgebaserecordRequest(contextPath.addSegment("objectid_knowledgebaserecord"), RequestHelper.getValue(unmappedFields, "objectid_knowledgebaserecord"));
    }

    @NavigationProperty(name="objectid_account")
    @JsonIgnore
    public AccountRequest getObjectid_account() {
        return new AccountRequest(contextPath.addSegment("objectid_account"), RequestHelper.getValue(unmappedFields, "objectid_account"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="objectid_kbarticle")
    @JsonIgnore
    public KbarticleRequest getObjectid_kbarticle() {
        return new KbarticleRequest(contextPath.addSegment("objectid_kbarticle"), RequestHelper.getValue(unmappedFields, "objectid_kbarticle"));
    }

    @NavigationProperty(name="objectid_appointment")
    @JsonIgnore
    public AppointmentRequest getObjectid_appointment() {
        return new AppointmentRequest(contextPath.addSegment("objectid_appointment"), RequestHelper.getValue(unmappedFields, "objectid_appointment"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="Annotation_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getAnnotation_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("Annotation_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "Annotation_BulkDeleteFailures"));
    }

    @NavigationProperty(name="objectid_sla")
    @JsonIgnore
    public SlaRequest getObjectid_sla() {
        return new SlaRequest(contextPath.addSegment("objectid_sla"), RequestHelper.getValue(unmappedFields, "objectid_sla"));
    }

    @NavigationProperty(name="objectid_calendar")
    @JsonIgnore
    public CalendarRequest getObjectid_calendar() {
        return new CalendarRequest(contextPath.addSegment("objectid_calendar"), RequestHelper.getValue(unmappedFields, "objectid_calendar"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="objectid_fax")
    @JsonIgnore
    public FaxRequest getObjectid_fax() {
        return new FaxRequest(contextPath.addSegment("objectid_fax"), RequestHelper.getValue(unmappedFields, "objectid_fax"));
    }

    @NavigationProperty(name="objectid_contact")
    @JsonIgnore
    public ContactRequest getObjectid_contact() {
        return new ContactRequest(contextPath.addSegment("objectid_contact"), RequestHelper.getValue(unmappedFields, "objectid_contact"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="objectid_letter")
    @JsonIgnore
    public LetterRequest getObjectid_letter() {
        return new LetterRequest(contextPath.addSegment("objectid_letter"), RequestHelper.getValue(unmappedFields, "objectid_letter"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="objectid_goal")
    @JsonIgnore
    public GoalRequest getObjectid_goal() {
        return new GoalRequest(contextPath.addSegment("objectid_goal"), RequestHelper.getValue(unmappedFields, "objectid_goal"));
    }

    @NavigationProperty(name="objectid_task")
    @JsonIgnore
    public TaskRequest getObjectid_task() {
        return new TaskRequest(contextPath.addSegment("objectid_task"), RequestHelper.getValue(unmappedFields, "objectid_task"));
    }

    @NavigationProperty(name="objectid_email")
    @JsonIgnore
    public EmailRequest getObjectid_email() {
        return new EmailRequest(contextPath.addSegment("objectid_email"), RequestHelper.getValue(unmappedFields, "objectid_email"));
    }

    @NavigationProperty(name="objectid_workflow")
    @JsonIgnore
    public WorkflowRequest getObjectid_workflow() {
        return new WorkflowRequest(contextPath.addSegment("objectid_workflow"), RequestHelper.getValue(unmappedFields, "objectid_workflow"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="Annotation_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getAnnotation_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Annotation_AsyncOperations"), RequestHelper.getValue(unmappedFields, "Annotation_AsyncOperations"));
    }

    @NavigationProperty(name="Annotation_ProcessSessions")
    @JsonIgnore
    public ProcesssessionCollectionRequest getAnnotation_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("Annotation_ProcessSessions"), RequestHelper.getValue(unmappedFields, "Annotation_ProcessSessions"));
    }

    @NavigationProperty(name="objectid_mailbox")
    @JsonIgnore
    public MailboxRequest getObjectid_mailbox() {
        return new MailboxRequest(contextPath.addSegment("objectid_mailbox"), RequestHelper.getValue(unmappedFields, "objectid_mailbox"));
    }

    @NavigationProperty(name="objectid_socialactivity")
    @JsonIgnore
    public SocialactivityRequest getObjectid_socialactivity() {
        return new SocialactivityRequest(contextPath.addSegment("objectid_socialactivity"), RequestHelper.getValue(unmappedFields, "objectid_socialactivity"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="objectid_duplicaterule")
    @JsonIgnore
    public DuplicateruleRequest getObjectid_duplicaterule() {
        return new DuplicateruleRequest(contextPath.addSegment("objectid_duplicaterule"), RequestHelper.getValue(unmappedFields, "objectid_duplicaterule"));
    }

    @NavigationProperty(name="Annotation_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getAnnotation_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Annotation_SyncErrors"), RequestHelper.getValue(unmappedFields, "Annotation_SyncErrors"));
    }

    @NavigationProperty(name="objectid_phonecall")
    @JsonIgnore
    public PhonecallRequest getObjectid_phonecall() {
        return new PhonecallRequest(contextPath.addSegment("objectid_phonecall"), RequestHelper.getValue(unmappedFields, "objectid_phonecall"));
    }

    @NavigationProperty(name="objectid_emailserverprofile")
    @JsonIgnore
    public EmailserverprofileRequest getObjectid_emailserverprofile() {
        return new EmailserverprofileRequest(contextPath.addSegment("objectid_emailserverprofile"), RequestHelper.getValue(unmappedFields, "objectid_emailserverprofile"));
    }

    @NavigationProperty(name="objectid_recurringappointmentmaster")
    @JsonIgnore
    public RecurringappointmentmasterRequest getObjectid_recurringappointmentmaster() {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("objectid_recurringappointmentmaster"), RequestHelper.getValue(unmappedFields, "objectid_recurringappointmentmaster"));
    }

    @NavigationProperty(name="objectid_msdyn_aimodel")
    @JsonIgnore
    public Msdyn_aimodelRequest getObjectid_msdyn_aimodel() {
        return new Msdyn_aimodelRequest(contextPath.addSegment("objectid_msdyn_aimodel"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_aimodel"));
    }

    @NavigationProperty(name="objectid_msdyn_aifptrainingdocument")
    @JsonIgnore
    public Msdyn_aifptrainingdocumentRequest getObjectid_msdyn_aifptrainingdocument() {
        return new Msdyn_aifptrainingdocumentRequest(contextPath.addSegment("objectid_msdyn_aifptrainingdocument"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_aifptrainingdocument"));
    }

    @NavigationProperty(name="objectid_msdyn_aiodimage")
    @JsonIgnore
    public Msdyn_aiodimageRequest getObjectid_msdyn_aiodimage() {
        return new Msdyn_aiodimageRequest(contextPath.addSegment("objectid_msdyn_aiodimage"), RequestHelper.getValue(unmappedFields, "objectid_msdyn_aiodimage"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Annotation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Annotation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Annotation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Annotation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Annotation _copy() {
        Annotation _x = new Annotation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.importsequencenumber = importsequencenumber;
        _x._modifiedby_value = _modifiedby_value;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.notetext = notetext;
        _x._objectid_value = _objectid_value;
        _x.objecttypecode = objecttypecode;
        _x.createdon = createdon;
        _x.dummyregarding = dummyregarding;
        _x.dummyfilename = dummyfilename;
        _x.annotationid = annotationid;
        _x.mimetype = mimetype;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._createdby_value = _createdby_value;
        _x.prefix = prefix;
        _x.modifiedon = modifiedon;
        _x._ownerid_value = _ownerid_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.langid = langid;
        _x.documentbody = documentbody;
        _x.documentbody_binary = documentbody_binary;
        _x.isdocument = isdocument;
        _x._owningteam_value = _owningteam_value;
        _x.versionnumber = versionnumber;
        _x.filesize = filesize;
        _x._owninguser_value = _owninguser_value;
        _x.stepid = stepid;
        _x.filename = filename;
        _x.overriddencreatedon = overriddencreatedon;
        _x.subject = subject;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Annotation[");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("notetext=");
        b.append(this.notetext);
        b.append(", ");
        b.append("_objectid_value=");
        b.append(this._objectid_value);
        b.append(", ");
        b.append("objecttypecode=");
        b.append(this.objecttypecode);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("dummyregarding=");
        b.append(this.dummyregarding);
        b.append(", ");
        b.append("dummyfilename=");
        b.append(this.dummyfilename);
        b.append(", ");
        b.append("annotationid=");
        b.append(this.annotationid);
        b.append(", ");
        b.append("mimetype=");
        b.append(this.mimetype);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("prefix=");
        b.append(this.prefix);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("langid=");
        b.append(this.langid);
        b.append(", ");
        b.append("documentbody=");
        b.append(this.documentbody);
        b.append(", ");
        b.append("documentbody_binary=");
        b.append(this.documentbody_binary);
        b.append(", ");
        b.append("isdocument=");
        b.append(this.isdocument);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("filesize=");
        b.append(this.filesize);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("stepid=");
        b.append(this.stepid);
        b.append(", ");
        b.append("filename=");
        b.append(this.filename);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("subject=");
        b.append(this.subject);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
