package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "BusinessUnitId", 
    "UserId", 
    "OrganizationId"})
@JsonInclude(Include.NON_NULL)
public class WhoAmIResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("BusinessUnitId")
    protected UUID businessUnitId;

    @JsonProperty("UserId")
    protected UUID userId;

    @JsonProperty("OrganizationId")
    protected UUID organizationId;

    protected WhoAmIResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.WhoAmIResponse";
    }

    @Property(name="BusinessUnitId")
    @JsonIgnore
    public Optional<UUID> getBusinessUnitId() {
        return Optional.ofNullable(businessUnitId);
    }

    public WhoAmIResponse withBusinessUnitId(UUID businessUnitId) {
        WhoAmIResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.WhoAmIResponse");
        _x.businessUnitId = businessUnitId;
        return _x;
    }

    @Property(name="UserId")
    @JsonIgnore
    public Optional<UUID> getUserId() {
        return Optional.ofNullable(userId);
    }

    public WhoAmIResponse withUserId(UUID userId) {
        WhoAmIResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.WhoAmIResponse");
        _x.userId = userId;
        return _x;
    }

    @Property(name="OrganizationId")
    @JsonIgnore
    public Optional<UUID> getOrganizationId() {
        return Optional.ofNullable(organizationId);
    }

    public WhoAmIResponse withOrganizationId(UUID organizationId) {
        WhoAmIResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.WhoAmIResponse");
        _x.organizationId = organizationId;
        return _x;
    }

    public WhoAmIResponse withUnmappedField(String name, Object value) {
        WhoAmIResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private UUID businessUnitId;
        private UUID userId;
        private UUID organizationId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder businessUnitId(UUID businessUnitId) {
            this.businessUnitId = businessUnitId;
            this.changedFields = changedFields.add("BusinessUnitId");
            return this;
        }

        public Builder userId(UUID userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("UserId");
            return this;
        }

        public Builder organizationId(UUID organizationId) {
            this.organizationId = organizationId;
            this.changedFields = changedFields.add("OrganizationId");
            return this;
        }

        public WhoAmIResponse build() {
            WhoAmIResponse _x = new WhoAmIResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.WhoAmIResponse";
            _x.businessUnitId = businessUnitId;
            _x.userId = userId;
            _x.organizationId = organizationId;
            return _x;
        }
    }

    private WhoAmIResponse _copy() {
        WhoAmIResponse _x = new WhoAmIResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.businessUnitId = businessUnitId;
        _x.userId = userId;
        _x.organizationId = organizationId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WhoAmIResponse[");
        b.append("BusinessUnitId=");
        b.append(this.businessUnitId);
        b.append(", ");
        b.append("UserId=");
        b.append(this.userId);
        b.append(", ");
        b.append("OrganizationId=");
        b.append(this.organizationId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
