package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "DefaultStatus", 
    "InvariantName"})
@JsonInclude(Include.NON_NULL)
public class StateOptionMetadata extends OptionMetadata implements ODataType {

    @JsonProperty("DefaultStatus")
    protected Integer defaultStatus;

    @JsonProperty("InvariantName")
    protected String invariantName;

    protected StateOptionMetadata() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.StateOptionMetadata";
    }

    @Property(name="DefaultStatus")
    @JsonIgnore
    public Optional<Integer> getDefaultStatus() {
        return Optional.ofNullable(defaultStatus);
    }

    public StateOptionMetadata withDefaultStatus(Integer defaultStatus) {
        StateOptionMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.StateOptionMetadata");
        _x.defaultStatus = defaultStatus;
        return _x;
    }

    @Property(name="InvariantName")
    @JsonIgnore
    public Optional<String> getInvariantName() {
        return Optional.ofNullable(invariantName);
    }

    public StateOptionMetadata withInvariantName(String invariantName) {
        StateOptionMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.StateOptionMetadata");
        _x.invariantName = invariantName;
        return _x;
    }

    public StateOptionMetadata withUnmappedField(String name, Object value) {
        StateOptionMetadata _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderStateOptionMetadata() {
        return new Builder();
    }

    public static final class Builder {
        private Integer value;
        private Label label;
        private Label description;
        private String color;
        private Boolean isManaged;
        private String externalValue;
        private List<Integer> parentValues;
        private String parentValuesNextLink;
        private UUID metadataId;
        private Boolean hasChanged;
        private Integer defaultStatus;
        private String invariantName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder value(Integer value) {
            this.value = value;
            this.changedFields = changedFields.add("Value");
            return this;
        }

        public Builder label(Label label) {
            this.label = label;
            this.changedFields = changedFields.add("Label");
            return this;
        }

        public Builder description(Label description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder color(String color) {
            this.color = color;
            this.changedFields = changedFields.add("Color");
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.isManaged = isManaged;
            this.changedFields = changedFields.add("IsManaged");
            return this;
        }

        public Builder externalValue(String externalValue) {
            this.externalValue = externalValue;
            this.changedFields = changedFields.add("ExternalValue");
            return this;
        }

        public Builder parentValues(List<Integer> parentValues) {
            this.parentValues = parentValues;
            this.changedFields = changedFields.add("ParentValues");
            return this;
        }

        public Builder parentValues(Integer... parentValues) {
            return parentValues(Arrays.asList(parentValues));
        }

        public Builder parentValuesNextLink(String parentValuesNextLink) {
            this.parentValuesNextLink = parentValuesNextLink;
            this.changedFields = changedFields.add("ParentValues");
            return this;
        }

        public Builder metadataId(UUID metadataId) {
            this.metadataId = metadataId;
            this.changedFields = changedFields.add("MetadataId");
            return this;
        }

        public Builder hasChanged(Boolean hasChanged) {
            this.hasChanged = hasChanged;
            this.changedFields = changedFields.add("HasChanged");
            return this;
        }

        public Builder defaultStatus(Integer defaultStatus) {
            this.defaultStatus = defaultStatus;
            this.changedFields = changedFields.add("DefaultStatus");
            return this;
        }

        public Builder invariantName(String invariantName) {
            this.invariantName = invariantName;
            this.changedFields = changedFields.add("InvariantName");
            return this;
        }

        public StateOptionMetadata build() {
            StateOptionMetadata _x = new StateOptionMetadata();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.StateOptionMetadata";
            _x.value = value;
            _x.label = label;
            _x.description = description;
            _x.color = color;
            _x.isManaged = isManaged;
            _x.externalValue = externalValue;
            _x.parentValues = parentValues;
            _x.parentValuesNextLink = parentValuesNextLink;
            _x.metadataId = metadataId;
            _x.hasChanged = hasChanged;
            _x.defaultStatus = defaultStatus;
            _x.invariantName = invariantName;
            return _x;
        }
    }

    private StateOptionMetadata _copy() {
        StateOptionMetadata _x = new StateOptionMetadata();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.value = value;
        _x.label = label;
        _x.description = description;
        _x.color = color;
        _x.isManaged = isManaged;
        _x.externalValue = externalValue;
        _x.parentValues = parentValues;
        _x.metadataId = metadataId;
        _x.hasChanged = hasChanged;
        _x.defaultStatus = defaultStatus;
        _x.invariantName = invariantName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("StateOptionMetadata[");
        b.append("Value=");
        b.append(this.value);
        b.append(", ");
        b.append("Label=");
        b.append(this.label);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("Color=");
        b.append(this.color);
        b.append(", ");
        b.append("IsManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("ExternalValue=");
        b.append(this.externalValue);
        b.append(", ");
        b.append("ParentValues=");
        b.append(this.parentValues);
        b.append(", ");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("HasChanged=");
        b.append(this.hasChanged);
        b.append(", ");
        b.append("DefaultStatus=");
        b.append(this.defaultStatus);
        b.append(", ");
        b.append("InvariantName=");
        b.append(this.invariantName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
