package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import microsoft.dynamics.crm.enums.SolutionValidationResultType;

@JsonPropertyOrder({
    "@odata.type", 
    "SolutionValidationResultType", 
    "Message", 
    "ErrorCode", 
    "AdditionalInfo"})
@JsonInclude(Include.NON_NULL)
public class SolutionValidationResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("SolutionValidationResultType")
    protected SolutionValidationResultType solutionValidationResultType;

    @JsonProperty("Message")
    protected String message;

    @JsonProperty("ErrorCode")
    protected Integer errorCode;

    @JsonProperty("AdditionalInfo")
    protected String additionalInfo;

    protected SolutionValidationResult() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.SolutionValidationResult";
    }

    @Property(name="SolutionValidationResultType")
    @JsonIgnore
    public Optional<SolutionValidationResultType> getSolutionValidationResultType() {
        return Optional.ofNullable(solutionValidationResultType);
    }

    public SolutionValidationResult withSolutionValidationResultType(SolutionValidationResultType solutionValidationResultType) {
        SolutionValidationResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SolutionValidationResult");
        _x.solutionValidationResultType = solutionValidationResultType;
        return _x;
    }

    @Property(name="Message")
    @JsonIgnore
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    public SolutionValidationResult withMessage(String message) {
        SolutionValidationResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SolutionValidationResult");
        _x.message = message;
        return _x;
    }

    @Property(name="ErrorCode")
    @JsonIgnore
    public Optional<Integer> getErrorCode() {
        return Optional.ofNullable(errorCode);
    }

    public SolutionValidationResult withErrorCode(Integer errorCode) {
        SolutionValidationResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SolutionValidationResult");
        _x.errorCode = errorCode;
        return _x;
    }

    @Property(name="AdditionalInfo")
    @JsonIgnore
    public Optional<String> getAdditionalInfo() {
        return Optional.ofNullable(additionalInfo);
    }

    public SolutionValidationResult withAdditionalInfo(String additionalInfo) {
        SolutionValidationResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SolutionValidationResult");
        _x.additionalInfo = additionalInfo;
        return _x;
    }

    public SolutionValidationResult withUnmappedField(String name, Object value) {
        SolutionValidationResult _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private SolutionValidationResultType solutionValidationResultType;
        private String message;
        private Integer errorCode;
        private String additionalInfo;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder solutionValidationResultType(SolutionValidationResultType solutionValidationResultType) {
            this.solutionValidationResultType = solutionValidationResultType;
            this.changedFields = changedFields.add("SolutionValidationResultType");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.changedFields = changedFields.add("Message");
            return this;
        }

        public Builder errorCode(Integer errorCode) {
            this.errorCode = errorCode;
            this.changedFields = changedFields.add("ErrorCode");
            return this;
        }

        public Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            this.changedFields = changedFields.add("AdditionalInfo");
            return this;
        }

        public SolutionValidationResult build() {
            SolutionValidationResult _x = new SolutionValidationResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.SolutionValidationResult";
            _x.solutionValidationResultType = solutionValidationResultType;
            _x.message = message;
            _x.errorCode = errorCode;
            _x.additionalInfo = additionalInfo;
            return _x;
        }
    }

    private SolutionValidationResult _copy() {
        SolutionValidationResult _x = new SolutionValidationResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.solutionValidationResultType = solutionValidationResultType;
        _x.message = message;
        _x.errorCode = errorCode;
        _x.additionalInfo = additionalInfo;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SolutionValidationResult[");
        b.append("SolutionValidationResultType=");
        b.append(this.solutionValidationResultType);
        b.append(", ");
        b.append("Message=");
        b.append(this.message);
        b.append(", ");
        b.append("ErrorCode=");
        b.append(this.errorCode);
        b.append(", ");
        b.append("AdditionalInfo=");
        b.append(this.additionalInfo);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
