package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "ServerVersionStamp", 
    "DeletedMetadata", 
    "EntityMetadata"})
@JsonInclude(Include.NON_NULL)
public class RetrieveMetadataChangesResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ServerVersionStamp")
    protected String serverVersionStamp;

    @JsonProperty("DeletedMetadata")
    protected DeletedMetadataCollection deletedMetadata;

    @JsonProperty("EntityMetadata")
    protected List<ComplexEntityMetadata> entityMetadata;

    @JsonProperty("EntityMetadata@nextLink")
    protected String entityMetadataNextLink;

    protected RetrieveMetadataChangesResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.RetrieveMetadataChangesResponse";
    }

    @Property(name="ServerVersionStamp")
    @JsonIgnore
    public Optional<String> getServerVersionStamp() {
        return Optional.ofNullable(serverVersionStamp);
    }

    public RetrieveMetadataChangesResponse withServerVersionStamp(String serverVersionStamp) {
        RetrieveMetadataChangesResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.RetrieveMetadataChangesResponse");
        _x.serverVersionStamp = serverVersionStamp;
        return _x;
    }

    @Property(name="DeletedMetadata")
    @JsonIgnore
    public Optional<DeletedMetadataCollection> getDeletedMetadata() {
        return Optional.ofNullable(deletedMetadata);
    }

    public RetrieveMetadataChangesResponse withDeletedMetadata(DeletedMetadataCollection deletedMetadata) {
        RetrieveMetadataChangesResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.RetrieveMetadataChangesResponse");
        _x.deletedMetadata = deletedMetadata;
        return _x;
    }

    @Property(name="EntityMetadata")
    @JsonIgnore
    public CollectionPage<ComplexEntityMetadata> getEntityMetadata() {
        return new CollectionPage<ComplexEntityMetadata>(contextPath, ComplexEntityMetadata.class, this.entityMetadata, Optional.ofNullable(entityMetadataNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="EntityMetadata")
    @JsonIgnore
    public CollectionPage<ComplexEntityMetadata> getEntityMetadata(HttpRequestOptions options) {
        return new CollectionPage<ComplexEntityMetadata>(contextPath, ComplexEntityMetadata.class, this.entityMetadata, Optional.ofNullable(entityMetadataNextLink), Collections.emptyList(), options);
    }

    public RetrieveMetadataChangesResponse withUnmappedField(String name, Object value) {
        RetrieveMetadataChangesResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String serverVersionStamp;
        private DeletedMetadataCollection deletedMetadata;
        private List<ComplexEntityMetadata> entityMetadata;
        private String entityMetadataNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder serverVersionStamp(String serverVersionStamp) {
            this.serverVersionStamp = serverVersionStamp;
            this.changedFields = changedFields.add("ServerVersionStamp");
            return this;
        }

        public Builder deletedMetadata(DeletedMetadataCollection deletedMetadata) {
            this.deletedMetadata = deletedMetadata;
            this.changedFields = changedFields.add("DeletedMetadata");
            return this;
        }

        public Builder entityMetadata(List<ComplexEntityMetadata> entityMetadata) {
            this.entityMetadata = entityMetadata;
            this.changedFields = changedFields.add("EntityMetadata");
            return this;
        }

        public Builder entityMetadata(ComplexEntityMetadata... entityMetadata) {
            return entityMetadata(Arrays.asList(entityMetadata));
        }

        public Builder entityMetadataNextLink(String entityMetadataNextLink) {
            this.entityMetadataNextLink = entityMetadataNextLink;
            this.changedFields = changedFields.add("EntityMetadata");
            return this;
        }

        public RetrieveMetadataChangesResponse build() {
            RetrieveMetadataChangesResponse _x = new RetrieveMetadataChangesResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.RetrieveMetadataChangesResponse";
            _x.serverVersionStamp = serverVersionStamp;
            _x.deletedMetadata = deletedMetadata;
            _x.entityMetadata = entityMetadata;
            _x.entityMetadataNextLink = entityMetadataNextLink;
            return _x;
        }
    }

    private RetrieveMetadataChangesResponse _copy() {
        RetrieveMetadataChangesResponse _x = new RetrieveMetadataChangesResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.serverVersionStamp = serverVersionStamp;
        _x.deletedMetadata = deletedMetadata;
        _x.entityMetadata = entityMetadata;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RetrieveMetadataChangesResponse[");
        b.append("ServerVersionStamp=");
        b.append(this.serverVersionStamp);
        b.append(", ");
        b.append("DeletedMetadata=");
        b.append(this.deletedMetadata);
        b.append(", ");
        b.append("EntityMetadata=");
        b.append(this.entityMetadata);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
