package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.dynamics.crm.enums.OrganizationType;

@JsonPropertyOrder({
    "@odata.type", 
    "InstanceType", 
    "Solutions"})
@JsonInclude(Include.NON_NULL)
public class OrganizationInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("InstanceType")
    protected OrganizationType instanceType;

    @JsonProperty("Solutions")
    protected List<Solution> solutions;

    @JsonProperty("Solutions@nextLink")
    protected String solutionsNextLink;

    protected OrganizationInfo() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.OrganizationInfo";
    }

    @Property(name="InstanceType")
    @JsonIgnore
    public Optional<OrganizationType> getInstanceType() {
        return Optional.ofNullable(instanceType);
    }

    public OrganizationInfo withInstanceType(OrganizationType instanceType) {
        OrganizationInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OrganizationInfo");
        _x.instanceType = instanceType;
        return _x;
    }

    @Property(name="Solutions")
    @JsonIgnore
    public CollectionPage<Solution> getSolutions() {
        return new CollectionPage<Solution>(contextPath, Solution.class, this.solutions, Optional.ofNullable(solutionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Solutions")
    @JsonIgnore
    public CollectionPage<Solution> getSolutions(HttpRequestOptions options) {
        return new CollectionPage<Solution>(contextPath, Solution.class, this.solutions, Optional.ofNullable(solutionsNextLink), Collections.emptyList(), options);
    }

    public OrganizationInfo withUnmappedField(String name, Object value) {
        OrganizationInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OrganizationType instanceType;
        private List<Solution> solutions;
        private String solutionsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder instanceType(OrganizationType instanceType) {
            this.instanceType = instanceType;
            this.changedFields = changedFields.add("InstanceType");
            return this;
        }

        public Builder solutions(List<Solution> solutions) {
            this.solutions = solutions;
            this.changedFields = changedFields.add("Solutions");
            return this;
        }

        public Builder solutions(Solution... solutions) {
            return solutions(Arrays.asList(solutions));
        }

        public Builder solutionsNextLink(String solutionsNextLink) {
            this.solutionsNextLink = solutionsNextLink;
            this.changedFields = changedFields.add("Solutions");
            return this;
        }

        public OrganizationInfo build() {
            OrganizationInfo _x = new OrganizationInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.OrganizationInfo";
            _x.instanceType = instanceType;
            _x.solutions = solutions;
            _x.solutionsNextLink = solutionsNextLink;
            return _x;
        }
    }

    private OrganizationInfo _copy() {
        OrganizationInfo _x = new OrganizationInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.instanceType = instanceType;
        _x.solutions = solutions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OrganizationInfo[");
        b.append("InstanceType=");
        b.append(this.instanceType);
        b.append(", ");
        b.append("Solutions=");
        b.append(this.solutions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
