package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.enums.OrganizationState;

@JsonPropertyOrder({
    "@odata.type", 
    "OrganizationId", 
    "FriendlyName", 
    "OrganizationVersion", 
    "EnvironmentId", 
    "Geo", 
    "TenantId", 
    "UrlName", 
    "UniqueName", 
    "Endpoints", 
    "State"})
@JsonInclude(Include.NON_NULL)
public class OrganizationDetail implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("OrganizationId")
    protected UUID organizationId;

    @JsonProperty("FriendlyName")
    protected String friendlyName;

    @JsonProperty("OrganizationVersion")
    protected String organizationVersion;

    @JsonProperty("EnvironmentId")
    protected String environmentId;

    @JsonProperty("Geo")
    protected String geo;

    @JsonProperty("TenantId")
    protected String tenantId;

    @JsonProperty("UrlName")
    protected String urlName;

    @JsonProperty("UniqueName")
    protected String uniqueName;

    @JsonProperty("Endpoints")
    protected EndpointCollection endpoints;

    @JsonProperty("State")
    protected OrganizationState state;

    protected OrganizationDetail() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.OrganizationDetail";
    }

    @Property(name="OrganizationId")
    @JsonIgnore
    public Optional<UUID> getOrganizationId() {
        return Optional.ofNullable(organizationId);
    }

    public OrganizationDetail withOrganizationId(UUID organizationId) {
        OrganizationDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OrganizationDetail");
        _x.organizationId = organizationId;
        return _x;
    }

    @Property(name="FriendlyName")
    @JsonIgnore
    public Optional<String> getFriendlyName() {
        return Optional.ofNullable(friendlyName);
    }

    public OrganizationDetail withFriendlyName(String friendlyName) {
        OrganizationDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OrganizationDetail");
        _x.friendlyName = friendlyName;
        return _x;
    }

    @Property(name="OrganizationVersion")
    @JsonIgnore
    public Optional<String> getOrganizationVersion() {
        return Optional.ofNullable(organizationVersion);
    }

    public OrganizationDetail withOrganizationVersion(String organizationVersion) {
        OrganizationDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OrganizationDetail");
        _x.organizationVersion = organizationVersion;
        return _x;
    }

    @Property(name="EnvironmentId")
    @JsonIgnore
    public Optional<String> getEnvironmentId() {
        return Optional.ofNullable(environmentId);
    }

    public OrganizationDetail withEnvironmentId(String environmentId) {
        OrganizationDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OrganizationDetail");
        _x.environmentId = environmentId;
        return _x;
    }

    @Property(name="Geo")
    @JsonIgnore
    public Optional<String> getGeo() {
        return Optional.ofNullable(geo);
    }

    public OrganizationDetail withGeo(String geo) {
        OrganizationDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OrganizationDetail");
        _x.geo = geo;
        return _x;
    }

    @Property(name="TenantId")
    @JsonIgnore
    public Optional<String> getTenantId() {
        return Optional.ofNullable(tenantId);
    }

    public OrganizationDetail withTenantId(String tenantId) {
        OrganizationDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OrganizationDetail");
        _x.tenantId = tenantId;
        return _x;
    }

    @Property(name="UrlName")
    @JsonIgnore
    public Optional<String> getUrlName() {
        return Optional.ofNullable(urlName);
    }

    public OrganizationDetail withUrlName(String urlName) {
        OrganizationDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OrganizationDetail");
        _x.urlName = urlName;
        return _x;
    }

    @Property(name="UniqueName")
    @JsonIgnore
    public Optional<String> getUniqueName() {
        return Optional.ofNullable(uniqueName);
    }

    public OrganizationDetail withUniqueName(String uniqueName) {
        OrganizationDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OrganizationDetail");
        _x.uniqueName = uniqueName;
        return _x;
    }

    @Property(name="Endpoints")
    @JsonIgnore
    public Optional<EndpointCollection> getEndpoints() {
        return Optional.ofNullable(endpoints);
    }

    public OrganizationDetail withEndpoints(EndpointCollection endpoints) {
        OrganizationDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OrganizationDetail");
        _x.endpoints = endpoints;
        return _x;
    }

    @Property(name="State")
    @JsonIgnore
    public Optional<OrganizationState> getState() {
        return Optional.ofNullable(state);
    }

    public OrganizationDetail withState(OrganizationState state) {
        OrganizationDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OrganizationDetail");
        _x.state = state;
        return _x;
    }

    public OrganizationDetail withUnmappedField(String name, Object value) {
        OrganizationDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private UUID organizationId;
        private String friendlyName;
        private String organizationVersion;
        private String environmentId;
        private String geo;
        private String tenantId;
        private String urlName;
        private String uniqueName;
        private EndpointCollection endpoints;
        private OrganizationState state;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder organizationId(UUID organizationId) {
            this.organizationId = organizationId;
            this.changedFields = changedFields.add("OrganizationId");
            return this;
        }

        public Builder friendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
            this.changedFields = changedFields.add("FriendlyName");
            return this;
        }

        public Builder organizationVersion(String organizationVersion) {
            this.organizationVersion = organizationVersion;
            this.changedFields = changedFields.add("OrganizationVersion");
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            this.changedFields = changedFields.add("EnvironmentId");
            return this;
        }

        public Builder geo(String geo) {
            this.geo = geo;
            this.changedFields = changedFields.add("Geo");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.changedFields = changedFields.add("TenantId");
            return this;
        }

        public Builder urlName(String urlName) {
            this.urlName = urlName;
            this.changedFields = changedFields.add("UrlName");
            return this;
        }

        public Builder uniqueName(String uniqueName) {
            this.uniqueName = uniqueName;
            this.changedFields = changedFields.add("UniqueName");
            return this;
        }

        public Builder endpoints(EndpointCollection endpoints) {
            this.endpoints = endpoints;
            this.changedFields = changedFields.add("Endpoints");
            return this;
        }

        public Builder state(OrganizationState state) {
            this.state = state;
            this.changedFields = changedFields.add("State");
            return this;
        }

        public OrganizationDetail build() {
            OrganizationDetail _x = new OrganizationDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.OrganizationDetail";
            _x.organizationId = organizationId;
            _x.friendlyName = friendlyName;
            _x.organizationVersion = organizationVersion;
            _x.environmentId = environmentId;
            _x.geo = geo;
            _x.tenantId = tenantId;
            _x.urlName = urlName;
            _x.uniqueName = uniqueName;
            _x.endpoints = endpoints;
            _x.state = state;
            return _x;
        }
    }

    private OrganizationDetail _copy() {
        OrganizationDetail _x = new OrganizationDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.organizationId = organizationId;
        _x.friendlyName = friendlyName;
        _x.organizationVersion = organizationVersion;
        _x.environmentId = environmentId;
        _x.geo = geo;
        _x.tenantId = tenantId;
        _x.urlName = urlName;
        _x.uniqueName = uniqueName;
        _x.endpoints = endpoints;
        _x.state = state;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OrganizationDetail[");
        b.append("OrganizationId=");
        b.append(this.organizationId);
        b.append(", ");
        b.append("FriendlyName=");
        b.append(this.friendlyName);
        b.append(", ");
        b.append("OrganizationVersion=");
        b.append(this.organizationVersion);
        b.append(", ");
        b.append("EnvironmentId=");
        b.append(this.environmentId);
        b.append(", ");
        b.append("Geo=");
        b.append(this.geo);
        b.append(", ");
        b.append("TenantId=");
        b.append(this.tenantId);
        b.append(", ");
        b.append("UrlName=");
        b.append(this.urlName);
        b.append(", ");
        b.append("UniqueName=");
        b.append(this.uniqueName);
        b.append(", ");
        b.append("Endpoints=");
        b.append(this.endpoints);
        b.append(", ");
        b.append("State=");
        b.append(this.state);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
