package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "LocalizedLabels", 
    "UserLocalizedLabel"})
@JsonInclude(Include.NON_NULL)
public class Label implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("LocalizedLabels")
    protected List<LocalizedLabel> localizedLabels;

    @JsonProperty("LocalizedLabels@nextLink")
    protected String localizedLabelsNextLink;

    @JsonProperty("UserLocalizedLabel")
    protected LocalizedLabel userLocalizedLabel;

    protected Label() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.Label";
    }

    @Property(name="LocalizedLabels")
    @JsonIgnore
    public CollectionPage<LocalizedLabel> getLocalizedLabels() {
        return new CollectionPage<LocalizedLabel>(contextPath, LocalizedLabel.class, this.localizedLabels, Optional.ofNullable(localizedLabelsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="LocalizedLabels")
    @JsonIgnore
    public CollectionPage<LocalizedLabel> getLocalizedLabels(HttpRequestOptions options) {
        return new CollectionPage<LocalizedLabel>(contextPath, LocalizedLabel.class, this.localizedLabels, Optional.ofNullable(localizedLabelsNextLink), Collections.emptyList(), options);
    }

    @Property(name="UserLocalizedLabel")
    @JsonIgnore
    public Optional<LocalizedLabel> getUserLocalizedLabel() {
        return Optional.ofNullable(userLocalizedLabel);
    }

    public Label withUserLocalizedLabel(LocalizedLabel userLocalizedLabel) {
        Label _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.Label");
        _x.userLocalizedLabel = userLocalizedLabel;
        return _x;
    }

    public Label withUnmappedField(String name, Object value) {
        Label _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<LocalizedLabel> localizedLabels;
        private String localizedLabelsNextLink;
        private LocalizedLabel userLocalizedLabel;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder localizedLabels(List<LocalizedLabel> localizedLabels) {
            this.localizedLabels = localizedLabels;
            this.changedFields = changedFields.add("LocalizedLabels");
            return this;
        }

        public Builder localizedLabels(LocalizedLabel... localizedLabels) {
            return localizedLabels(Arrays.asList(localizedLabels));
        }

        public Builder localizedLabelsNextLink(String localizedLabelsNextLink) {
            this.localizedLabelsNextLink = localizedLabelsNextLink;
            this.changedFields = changedFields.add("LocalizedLabels");
            return this;
        }

        public Builder userLocalizedLabel(LocalizedLabel userLocalizedLabel) {
            this.userLocalizedLabel = userLocalizedLabel;
            this.changedFields = changedFields.add("UserLocalizedLabel");
            return this;
        }

        public Label build() {
            Label _x = new Label();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.Label";
            _x.localizedLabels = localizedLabels;
            _x.localizedLabelsNextLink = localizedLabelsNextLink;
            _x.userLocalizedLabel = userLocalizedLabel;
            return _x;
        }
    }

    private Label _copy() {
        Label _x = new Label();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.localizedLabels = localizedLabels;
        _x.userLocalizedLabel = userLocalizedLabel;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Label[");
        b.append("LocalizedLabels=");
        b.append(this.localizedLabels);
        b.append(", ");
        b.append("UserLocalizedLabel=");
        b.append(this.userLocalizedLabel);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
