package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "ispaienabled", 
    "templates", 
    "arePreviewScenarioEnabled", 
    "paigastatus", 
    "isdatamodelv2enabled"})
@JsonInclude(Include.NON_NULL)
public class IsPaiEnabledResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ispaienabled")
    protected Boolean ispaienabled;

    @JsonProperty("templates")
    protected String templates;

    @JsonProperty("arePreviewScenarioEnabled")
    protected Boolean arePreviewScenarioEnabled;

    @JsonProperty("paigastatus")
    protected Boolean paigastatus;

    @JsonProperty("isdatamodelv2enabled")
    protected Boolean isdatamodelv2enabled;

    protected IsPaiEnabledResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.IsPaiEnabledResponse";
    }

    @Property(name="ispaienabled")
    @JsonIgnore
    public Optional<Boolean> getIspaienabled() {
        return Optional.ofNullable(ispaienabled);
    }

    public IsPaiEnabledResponse withIspaienabled(Boolean ispaienabled) {
        IsPaiEnabledResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.IsPaiEnabledResponse");
        _x.ispaienabled = ispaienabled;
        return _x;
    }

    @Property(name="templates")
    @JsonIgnore
    public Optional<String> getTemplates() {
        return Optional.ofNullable(templates);
    }

    public IsPaiEnabledResponse withTemplates(String templates) {
        IsPaiEnabledResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.IsPaiEnabledResponse");
        _x.templates = templates;
        return _x;
    }

    @Property(name="arePreviewScenarioEnabled")
    @JsonIgnore
    public Optional<Boolean> getArePreviewScenarioEnabled() {
        return Optional.ofNullable(arePreviewScenarioEnabled);
    }

    public IsPaiEnabledResponse withArePreviewScenarioEnabled(Boolean arePreviewScenarioEnabled) {
        IsPaiEnabledResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.IsPaiEnabledResponse");
        _x.arePreviewScenarioEnabled = arePreviewScenarioEnabled;
        return _x;
    }

    @Property(name="paigastatus")
    @JsonIgnore
    public Optional<Boolean> getPaigastatus() {
        return Optional.ofNullable(paigastatus);
    }

    public IsPaiEnabledResponse withPaigastatus(Boolean paigastatus) {
        IsPaiEnabledResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.IsPaiEnabledResponse");
        _x.paigastatus = paigastatus;
        return _x;
    }

    @Property(name="isdatamodelv2enabled")
    @JsonIgnore
    public Optional<Boolean> getIsdatamodelv2enabled() {
        return Optional.ofNullable(isdatamodelv2enabled);
    }

    public IsPaiEnabledResponse withIsdatamodelv2enabled(Boolean isdatamodelv2enabled) {
        IsPaiEnabledResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.IsPaiEnabledResponse");
        _x.isdatamodelv2enabled = isdatamodelv2enabled;
        return _x;
    }

    public IsPaiEnabledResponse withUnmappedField(String name, Object value) {
        IsPaiEnabledResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean ispaienabled;
        private String templates;
        private Boolean arePreviewScenarioEnabled;
        private Boolean paigastatus;
        private Boolean isdatamodelv2enabled;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder ispaienabled(Boolean ispaienabled) {
            this.ispaienabled = ispaienabled;
            this.changedFields = changedFields.add("ispaienabled");
            return this;
        }

        public Builder templates(String templates) {
            this.templates = templates;
            this.changedFields = changedFields.add("templates");
            return this;
        }

        public Builder arePreviewScenarioEnabled(Boolean arePreviewScenarioEnabled) {
            this.arePreviewScenarioEnabled = arePreviewScenarioEnabled;
            this.changedFields = changedFields.add("arePreviewScenarioEnabled");
            return this;
        }

        public Builder paigastatus(Boolean paigastatus) {
            this.paigastatus = paigastatus;
            this.changedFields = changedFields.add("paigastatus");
            return this;
        }

        public Builder isdatamodelv2enabled(Boolean isdatamodelv2enabled) {
            this.isdatamodelv2enabled = isdatamodelv2enabled;
            this.changedFields = changedFields.add("isdatamodelv2enabled");
            return this;
        }

        public IsPaiEnabledResponse build() {
            IsPaiEnabledResponse _x = new IsPaiEnabledResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.IsPaiEnabledResponse";
            _x.ispaienabled = ispaienabled;
            _x.templates = templates;
            _x.arePreviewScenarioEnabled = arePreviewScenarioEnabled;
            _x.paigastatus = paigastatus;
            _x.isdatamodelv2enabled = isdatamodelv2enabled;
            return _x;
        }
    }

    private IsPaiEnabledResponse _copy() {
        IsPaiEnabledResponse _x = new IsPaiEnabledResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.ispaienabled = ispaienabled;
        _x.templates = templates;
        _x.arePreviewScenarioEnabled = arePreviewScenarioEnabled;
        _x.paigastatus = paigastatus;
        _x.isdatamodelv2enabled = isdatamodelv2enabled;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IsPaiEnabledResponse[");
        b.append("ispaienabled=");
        b.append(this.ispaienabled);
        b.append(", ");
        b.append("templates=");
        b.append(this.templates);
        b.append(", ");
        b.append("arePreviewScenarioEnabled=");
        b.append(this.arePreviewScenarioEnabled);
        b.append(", ");
        b.append("paigastatus=");
        b.append(this.paigastatus);
        b.append(", ");
        b.append("isdatamodelv2enabled=");
        b.append(this.isdatamodelv2enabled);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
