package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "LabelQuery", 
    "AttributeQuery", 
    "RelationshipQuery", 
    "KeyQuery", 
    "Criteria", 
    "Properties"})
@JsonInclude(Include.NON_NULL)
public class EntityQueryExpression implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("LabelQuery")
    protected LabelQueryExpression labelQuery;

    @JsonProperty("AttributeQuery")
    protected AttributeQueryExpression attributeQuery;

    @JsonProperty("RelationshipQuery")
    protected RelationshipQueryExpression relationshipQuery;

    @JsonProperty("KeyQuery")
    protected EntityKeyQueryExpression keyQuery;

    @JsonProperty("Criteria")
    protected MetadataFilterExpression criteria;

    @JsonProperty("Properties")
    protected MetadataPropertiesExpression properties;

    protected EntityQueryExpression() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.EntityQueryExpression";
    }

    @Property(name="LabelQuery")
    @JsonIgnore
    public Optional<LabelQueryExpression> getLabelQuery() {
        return Optional.ofNullable(labelQuery);
    }

    public EntityQueryExpression withLabelQuery(LabelQueryExpression labelQuery) {
        EntityQueryExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityQueryExpression");
        _x.labelQuery = labelQuery;
        return _x;
    }

    @Property(name="AttributeQuery")
    @JsonIgnore
    public Optional<AttributeQueryExpression> getAttributeQuery() {
        return Optional.ofNullable(attributeQuery);
    }

    public EntityQueryExpression withAttributeQuery(AttributeQueryExpression attributeQuery) {
        EntityQueryExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityQueryExpression");
        _x.attributeQuery = attributeQuery;
        return _x;
    }

    @Property(name="RelationshipQuery")
    @JsonIgnore
    public Optional<RelationshipQueryExpression> getRelationshipQuery() {
        return Optional.ofNullable(relationshipQuery);
    }

    public EntityQueryExpression withRelationshipQuery(RelationshipQueryExpression relationshipQuery) {
        EntityQueryExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityQueryExpression");
        _x.relationshipQuery = relationshipQuery;
        return _x;
    }

    @Property(name="KeyQuery")
    @JsonIgnore
    public Optional<EntityKeyQueryExpression> getKeyQuery() {
        return Optional.ofNullable(keyQuery);
    }

    public EntityQueryExpression withKeyQuery(EntityKeyQueryExpression keyQuery) {
        EntityQueryExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityQueryExpression");
        _x.keyQuery = keyQuery;
        return _x;
    }

    @Property(name="Criteria")
    @JsonIgnore
    public Optional<MetadataFilterExpression> getCriteria() {
        return Optional.ofNullable(criteria);
    }

    public EntityQueryExpression withCriteria(MetadataFilterExpression criteria) {
        EntityQueryExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityQueryExpression");
        _x.criteria = criteria;
        return _x;
    }

    @Property(name="Properties")
    @JsonIgnore
    public Optional<MetadataPropertiesExpression> getProperties() {
        return Optional.ofNullable(properties);
    }

    public EntityQueryExpression withProperties(MetadataPropertiesExpression properties) {
        EntityQueryExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityQueryExpression");
        _x.properties = properties;
        return _x;
    }

    public EntityQueryExpression withUnmappedField(String name, Object value) {
        EntityQueryExpression _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private LabelQueryExpression labelQuery;
        private AttributeQueryExpression attributeQuery;
        private RelationshipQueryExpression relationshipQuery;
        private EntityKeyQueryExpression keyQuery;
        private MetadataFilterExpression criteria;
        private MetadataPropertiesExpression properties;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder labelQuery(LabelQueryExpression labelQuery) {
            this.labelQuery = labelQuery;
            this.changedFields = changedFields.add("LabelQuery");
            return this;
        }

        public Builder attributeQuery(AttributeQueryExpression attributeQuery) {
            this.attributeQuery = attributeQuery;
            this.changedFields = changedFields.add("AttributeQuery");
            return this;
        }

        public Builder relationshipQuery(RelationshipQueryExpression relationshipQuery) {
            this.relationshipQuery = relationshipQuery;
            this.changedFields = changedFields.add("RelationshipQuery");
            return this;
        }

        public Builder keyQuery(EntityKeyQueryExpression keyQuery) {
            this.keyQuery = keyQuery;
            this.changedFields = changedFields.add("KeyQuery");
            return this;
        }

        public Builder criteria(MetadataFilterExpression criteria) {
            this.criteria = criteria;
            this.changedFields = changedFields.add("Criteria");
            return this;
        }

        public Builder properties(MetadataPropertiesExpression properties) {
            this.properties = properties;
            this.changedFields = changedFields.add("Properties");
            return this;
        }

        public EntityQueryExpression build() {
            EntityQueryExpression _x = new EntityQueryExpression();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.EntityQueryExpression";
            _x.labelQuery = labelQuery;
            _x.attributeQuery = attributeQuery;
            _x.relationshipQuery = relationshipQuery;
            _x.keyQuery = keyQuery;
            _x.criteria = criteria;
            _x.properties = properties;
            return _x;
        }
    }

    private EntityQueryExpression _copy() {
        EntityQueryExpression _x = new EntityQueryExpression();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.labelQuery = labelQuery;
        _x.attributeQuery = attributeQuery;
        _x.relationshipQuery = relationshipQuery;
        _x.keyQuery = keyQuery;
        _x.criteria = criteria;
        _x.properties = properties;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EntityQueryExpression[");
        b.append("LabelQuery=");
        b.append(this.labelQuery);
        b.append(", ");
        b.append("AttributeQuery=");
        b.append(this.attributeQuery);
        b.append(", ");
        b.append("RelationshipQuery=");
        b.append(this.relationshipQuery);
        b.append(", ");
        b.append("KeyQuery=");
        b.append(this.keyQuery);
        b.append(", ");
        b.append("Criteria=");
        b.append(this.criteria);
        b.append(", ");
        b.append("Properties=");
        b.append(this.properties);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
