package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "IntersectEntity", 
    "FromEntityAttribute", 
    "ToEntityAttribute", 
    "IntersectPrimaryAttribute", 
    "IntersectRelatedAttribute"})
@JsonInclude(Include.NON_NULL)
public class DependentManyToManyRelationshipMetadata implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("IntersectEntity")
    protected String intersectEntity;

    @JsonProperty("FromEntityAttribute")
    protected String fromEntityAttribute;

    @JsonProperty("ToEntityAttribute")
    protected String toEntityAttribute;

    @JsonProperty("IntersectPrimaryAttribute")
    protected String intersectPrimaryAttribute;

    @JsonProperty("IntersectRelatedAttribute")
    protected String intersectRelatedAttribute;

    protected DependentManyToManyRelationshipMetadata() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.DependentManyToManyRelationshipMetadata";
    }

    @Property(name="IntersectEntity")
    @JsonIgnore
    public Optional<String> getIntersectEntity() {
        return Optional.ofNullable(intersectEntity);
    }

    public DependentManyToManyRelationshipMetadata withIntersectEntity(String intersectEntity) {
        DependentManyToManyRelationshipMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentManyToManyRelationshipMetadata");
        _x.intersectEntity = intersectEntity;
        return _x;
    }

    @Property(name="FromEntityAttribute")
    @JsonIgnore
    public Optional<String> getFromEntityAttribute() {
        return Optional.ofNullable(fromEntityAttribute);
    }

    public DependentManyToManyRelationshipMetadata withFromEntityAttribute(String fromEntityAttribute) {
        DependentManyToManyRelationshipMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentManyToManyRelationshipMetadata");
        _x.fromEntityAttribute = fromEntityAttribute;
        return _x;
    }

    @Property(name="ToEntityAttribute")
    @JsonIgnore
    public Optional<String> getToEntityAttribute() {
        return Optional.ofNullable(toEntityAttribute);
    }

    public DependentManyToManyRelationshipMetadata withToEntityAttribute(String toEntityAttribute) {
        DependentManyToManyRelationshipMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentManyToManyRelationshipMetadata");
        _x.toEntityAttribute = toEntityAttribute;
        return _x;
    }

    @Property(name="IntersectPrimaryAttribute")
    @JsonIgnore
    public Optional<String> getIntersectPrimaryAttribute() {
        return Optional.ofNullable(intersectPrimaryAttribute);
    }

    public DependentManyToManyRelationshipMetadata withIntersectPrimaryAttribute(String intersectPrimaryAttribute) {
        DependentManyToManyRelationshipMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentManyToManyRelationshipMetadata");
        _x.intersectPrimaryAttribute = intersectPrimaryAttribute;
        return _x;
    }

    @Property(name="IntersectRelatedAttribute")
    @JsonIgnore
    public Optional<String> getIntersectRelatedAttribute() {
        return Optional.ofNullable(intersectRelatedAttribute);
    }

    public DependentManyToManyRelationshipMetadata withIntersectRelatedAttribute(String intersectRelatedAttribute) {
        DependentManyToManyRelationshipMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentManyToManyRelationshipMetadata");
        _x.intersectRelatedAttribute = intersectRelatedAttribute;
        return _x;
    }

    public DependentManyToManyRelationshipMetadata withUnmappedField(String name, Object value) {
        DependentManyToManyRelationshipMetadata _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String intersectEntity;
        private String fromEntityAttribute;
        private String toEntityAttribute;
        private String intersectPrimaryAttribute;
        private String intersectRelatedAttribute;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder intersectEntity(String intersectEntity) {
            this.intersectEntity = intersectEntity;
            this.changedFields = changedFields.add("IntersectEntity");
            return this;
        }

        public Builder fromEntityAttribute(String fromEntityAttribute) {
            this.fromEntityAttribute = fromEntityAttribute;
            this.changedFields = changedFields.add("FromEntityAttribute");
            return this;
        }

        public Builder toEntityAttribute(String toEntityAttribute) {
            this.toEntityAttribute = toEntityAttribute;
            this.changedFields = changedFields.add("ToEntityAttribute");
            return this;
        }

        public Builder intersectPrimaryAttribute(String intersectPrimaryAttribute) {
            this.intersectPrimaryAttribute = intersectPrimaryAttribute;
            this.changedFields = changedFields.add("IntersectPrimaryAttribute");
            return this;
        }

        public Builder intersectRelatedAttribute(String intersectRelatedAttribute) {
            this.intersectRelatedAttribute = intersectRelatedAttribute;
            this.changedFields = changedFields.add("IntersectRelatedAttribute");
            return this;
        }

        public DependentManyToManyRelationshipMetadata build() {
            DependentManyToManyRelationshipMetadata _x = new DependentManyToManyRelationshipMetadata();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.DependentManyToManyRelationshipMetadata";
            _x.intersectEntity = intersectEntity;
            _x.fromEntityAttribute = fromEntityAttribute;
            _x.toEntityAttribute = toEntityAttribute;
            _x.intersectPrimaryAttribute = intersectPrimaryAttribute;
            _x.intersectRelatedAttribute = intersectRelatedAttribute;
            return _x;
        }
    }

    private DependentManyToManyRelationshipMetadata _copy() {
        DependentManyToManyRelationshipMetadata _x = new DependentManyToManyRelationshipMetadata();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.intersectEntity = intersectEntity;
        _x.fromEntityAttribute = fromEntityAttribute;
        _x.toEntityAttribute = toEntityAttribute;
        _x.intersectPrimaryAttribute = intersectPrimaryAttribute;
        _x.intersectRelatedAttribute = intersectRelatedAttribute;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DependentManyToManyRelationshipMetadata[");
        b.append("IntersectEntity=");
        b.append(this.intersectEntity);
        b.append(", ");
        b.append("FromEntityAttribute=");
        b.append(this.fromEntityAttribute);
        b.append(", ");
        b.append("ToEntityAttribute=");
        b.append(this.toEntityAttribute);
        b.append(", ");
        b.append("IntersectPrimaryAttribute=");
        b.append(this.intersectPrimaryAttribute);
        b.append(", ");
        b.append("IntersectRelatedAttribute=");
        b.append(this.intersectRelatedAttribute);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
