package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "Criteria", 
    "Properties"})
@JsonInclude(Include.NON_NULL)
public class AttributeQueryExpression implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Criteria")
    protected MetadataFilterExpression criteria;

    @JsonProperty("Properties")
    protected MetadataPropertiesExpression properties;

    protected AttributeQueryExpression() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AttributeQueryExpression";
    }

    @Property(name="Criteria")
    @JsonIgnore
    public Optional<MetadataFilterExpression> getCriteria() {
        return Optional.ofNullable(criteria);
    }

    public AttributeQueryExpression withCriteria(MetadataFilterExpression criteria) {
        AttributeQueryExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeQueryExpression");
        _x.criteria = criteria;
        return _x;
    }

    @Property(name="Properties")
    @JsonIgnore
    public Optional<MetadataPropertiesExpression> getProperties() {
        return Optional.ofNullable(properties);
    }

    public AttributeQueryExpression withProperties(MetadataPropertiesExpression properties) {
        AttributeQueryExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributeQueryExpression");
        _x.properties = properties;
        return _x;
    }

    public AttributeQueryExpression withUnmappedField(String name, Object value) {
        AttributeQueryExpression _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private MetadataFilterExpression criteria;
        private MetadataPropertiesExpression properties;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder criteria(MetadataFilterExpression criteria) {
            this.criteria = criteria;
            this.changedFields = changedFields.add("Criteria");
            return this;
        }

        public Builder properties(MetadataPropertiesExpression properties) {
            this.properties = properties;
            this.changedFields = changedFields.add("Properties");
            return this;
        }

        public AttributeQueryExpression build() {
            AttributeQueryExpression _x = new AttributeQueryExpression();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.AttributeQueryExpression";
            _x.criteria = criteria;
            _x.properties = properties;
            return _x;
        }
    }

    private AttributeQueryExpression _copy() {
        AttributeQueryExpression _x = new AttributeQueryExpression();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.criteria = criteria;
        _x.properties = properties;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AttributeQueryExpression[");
        b.append("Criteria=");
        b.append(this.criteria);
        b.append(", ");
        b.append("Properties=");
        b.append(this.properties);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
