package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "AttributeId", 
    "CanCreate", 
    "CanRead", 
    "CanUpdate"})
@JsonInclude(Include.NON_NULL)
public class AttributePrivilege implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AttributeId")
    protected UUID attributeId;

    @JsonProperty("CanCreate")
    protected Integer canCreate;

    @JsonProperty("CanRead")
    protected Integer canRead;

    @JsonProperty("CanUpdate")
    protected Integer canUpdate;

    protected AttributePrivilege() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AttributePrivilege";
    }

    @Property(name="AttributeId")
    @JsonIgnore
    public Optional<UUID> getAttributeId() {
        return Optional.ofNullable(attributeId);
    }

    public AttributePrivilege withAttributeId(UUID attributeId) {
        AttributePrivilege _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributePrivilege");
        _x.attributeId = attributeId;
        return _x;
    }

    @Property(name="CanCreate")
    @JsonIgnore
    public Optional<Integer> getCanCreate() {
        return Optional.ofNullable(canCreate);
    }

    public AttributePrivilege withCanCreate(Integer canCreate) {
        AttributePrivilege _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributePrivilege");
        _x.canCreate = canCreate;
        return _x;
    }

    @Property(name="CanRead")
    @JsonIgnore
    public Optional<Integer> getCanRead() {
        return Optional.ofNullable(canRead);
    }

    public AttributePrivilege withCanRead(Integer canRead) {
        AttributePrivilege _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributePrivilege");
        _x.canRead = canRead;
        return _x;
    }

    @Property(name="CanUpdate")
    @JsonIgnore
    public Optional<Integer> getCanUpdate() {
        return Optional.ofNullable(canUpdate);
    }

    public AttributePrivilege withCanUpdate(Integer canUpdate) {
        AttributePrivilege _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AttributePrivilege");
        _x.canUpdate = canUpdate;
        return _x;
    }

    public AttributePrivilege withUnmappedField(String name, Object value) {
        AttributePrivilege _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private UUID attributeId;
        private Integer canCreate;
        private Integer canRead;
        private Integer canUpdate;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder attributeId(UUID attributeId) {
            this.attributeId = attributeId;
            this.changedFields = changedFields.add("AttributeId");
            return this;
        }

        public Builder canCreate(Integer canCreate) {
            this.canCreate = canCreate;
            this.changedFields = changedFields.add("CanCreate");
            return this;
        }

        public Builder canRead(Integer canRead) {
            this.canRead = canRead;
            this.changedFields = changedFields.add("CanRead");
            return this;
        }

        public Builder canUpdate(Integer canUpdate) {
            this.canUpdate = canUpdate;
            this.changedFields = changedFields.add("CanUpdate");
            return this;
        }

        public AttributePrivilege build() {
            AttributePrivilege _x = new AttributePrivilege();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.AttributePrivilege";
            _x.attributeId = attributeId;
            _x.canCreate = canCreate;
            _x.canRead = canRead;
            _x.canUpdate = canUpdate;
            return _x;
        }
    }

    private AttributePrivilege _copy() {
        AttributePrivilege _x = new AttributePrivilege();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.attributeId = attributeId;
        _x.canCreate = canCreate;
        _x.canRead = canRead;
        _x.canUpdate = canUpdate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AttributePrivilege[");
        b.append("AttributeId=");
        b.append(this.attributeId);
        b.append(", ");
        b.append("CanCreate=");
        b.append(this.canCreate);
        b.append(", ");
        b.append("CanRead=");
        b.append(this.canRead);
        b.append(", ");
        b.append("CanUpdate=");
        b.append(this.canUpdate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
