package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "AppModuleDetails"})
@JsonInclude(Include.NON_NULL)
public class AppModuleDetailsCollection implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AppModuleDetails")
    protected List<AppModuleDetails> appModuleDetails;

    @JsonProperty("AppModuleDetails@nextLink")
    protected String appModuleDetailsNextLink;

    protected AppModuleDetailsCollection() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AppModuleDetailsCollection";
    }

    @Property(name="AppModuleDetails")
    @JsonIgnore
    public CollectionPage<AppModuleDetails> getAppModuleDetails() {
        return new CollectionPage<AppModuleDetails>(contextPath, AppModuleDetails.class, this.appModuleDetails, Optional.ofNullable(appModuleDetailsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="AppModuleDetails")
    @JsonIgnore
    public CollectionPage<AppModuleDetails> getAppModuleDetails(HttpRequestOptions options) {
        return new CollectionPage<AppModuleDetails>(contextPath, AppModuleDetails.class, this.appModuleDetails, Optional.ofNullable(appModuleDetailsNextLink), Collections.emptyList(), options);
    }

    public AppModuleDetailsCollection withUnmappedField(String name, Object value) {
        AppModuleDetailsCollection _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<AppModuleDetails> appModuleDetails;
        private String appModuleDetailsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder appModuleDetails(List<AppModuleDetails> appModuleDetails) {
            this.appModuleDetails = appModuleDetails;
            this.changedFields = changedFields.add("AppModuleDetails");
            return this;
        }

        public Builder appModuleDetails(AppModuleDetails... appModuleDetails) {
            return appModuleDetails(Arrays.asList(appModuleDetails));
        }

        public Builder appModuleDetailsNextLink(String appModuleDetailsNextLink) {
            this.appModuleDetailsNextLink = appModuleDetailsNextLink;
            this.changedFields = changedFields.add("AppModuleDetails");
            return this;
        }

        public AppModuleDetailsCollection build() {
            AppModuleDetailsCollection _x = new AppModuleDetailsCollection();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.AppModuleDetailsCollection";
            _x.appModuleDetails = appModuleDetails;
            _x.appModuleDetailsNextLink = appModuleDetailsNextLink;
            return _x;
        }
    }

    private AppModuleDetailsCollection _copy() {
        AppModuleDetailsCollection _x = new AppModuleDetailsCollection();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.appModuleDetails = appModuleDetails;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppModuleDetailsCollection[");
        b.append("AppModuleDetails=");
        b.append(this.appModuleDetails);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
