/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder(value={"@odata.type", "Id", "DisplayName", "EntityName"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ResourceInfo
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="Id")
    protected UUID id;
    @JsonProperty(value="DisplayName")
    protected String displayName;
    @JsonProperty(value="EntityName")
    protected String entityName;

    protected ResourceInfo() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ResourceInfo";
    }

    @Property(name="Id")
    @JsonIgnore
    public Optional<UUID> getId() {
        return Optional.ofNullable(this.id);
    }

    public ResourceInfo withId(UUID id) {
        ResourceInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ResourceInfo");
        _x.id = id;
        return _x;
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(this.displayName);
    }

    public ResourceInfo withDisplayName(String displayName) {
        ResourceInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ResourceInfo");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="EntityName")
    @JsonIgnore
    public Optional<String> getEntityName() {
        return Optional.ofNullable(this.entityName);
    }

    public ResourceInfo withEntityName(String entityName) {
        ResourceInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ResourceInfo");
        _x.entityName = entityName;
        return _x;
    }

    public ResourceInfo withUnmappedField(String name, Object value) {
        ResourceInfo _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private ResourceInfo _copy() {
        ResourceInfo _x = new ResourceInfo();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.id = this.id;
        _x.displayName = this.displayName;
        _x.entityName = this.entityName;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ResourceInfo[");
        b.append("Id=");
        b.append(this.id);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("EntityName=");
        b.append(this.entityName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private UUID id;
        private String displayName;
        private String entityName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder id(UUID id) {
            this.id = id;
            this.changedFields = this.changedFields.add("Id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = this.changedFields.add("DisplayName");
            return this;
        }

        public Builder entityName(String entityName) {
            this.entityName = entityName;
            this.changedFields = this.changedFields.add("EntityName");
            return this;
        }

        public ResourceInfo build() {
            ResourceInfo _x = new ResourceInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ResourceInfo";
            _x.id = this.id;
            _x.displayName = this.displayName;
            _x.entityName = this.entityName;
            return _x;
        }
    }
}

