/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;

@JsonPropertyOrder(value={"@odata.type", "ExportTranslationFile"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ExportFieldTranslationResponse
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="ExportTranslationFile")
    protected byte[] exportTranslationFile;

    protected ExportFieldTranslationResponse() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ExportFieldTranslationResponse";
    }

    @Property(name="ExportTranslationFile")
    @JsonIgnore
    public Optional<byte[]> getExportTranslationFile() {
        return Optional.ofNullable(this.exportTranslationFile);
    }

    public ExportFieldTranslationResponse withExportTranslationFile(byte[] exportTranslationFile) {
        ExportFieldTranslationResponse _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ExportFieldTranslationResponse");
        _x.exportTranslationFile = exportTranslationFile;
        return _x;
    }

    public ExportFieldTranslationResponse withUnmappedField(String name, Object value) {
        ExportFieldTranslationResponse _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private ExportFieldTranslationResponse _copy() {
        ExportFieldTranslationResponse _x = new ExportFieldTranslationResponse();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.exportTranslationFile = this.exportTranslationFile;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExportFieldTranslationResponse[");
        b.append("ExportTranslationFile=");
        b.append(this.exportTranslationFile);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private byte[] exportTranslationFile;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder exportTranslationFile(byte[] exportTranslationFile) {
            this.exportTranslationFile = exportTranslationFile;
            this.changedFields = this.changedFields.add("ExportTranslationFile");
            return this;
        }

        public ExportFieldTranslationResponse build() {
            ExportFieldTranslationResponse _x = new ExportFieldTranslationResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ExportFieldTranslationResponse";
            _x.exportTranslationFile = this.exportTranslationFile;
            return _x;
        }
    }
}

