/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.complex.ClientEntityMetadata;

@JsonPropertyOrder(value={"@odata.type", "Entities", "RelationshipNavigationEntities", "OtherMetadata"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ClientMetadataResults
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="Entities")
    protected List<ClientEntityMetadata> entities;
    @JsonProperty(value="Entities@nextLink")
    protected String entitiesNextLink;
    @JsonProperty(value="RelationshipNavigationEntities")
    protected List<ClientEntityMetadata> relationshipNavigationEntities;
    @JsonProperty(value="RelationshipNavigationEntities@nextLink")
    protected String relationshipNavigationEntitiesNextLink;
    @JsonProperty(value="OtherMetadata")
    protected String otherMetadata;

    protected ClientMetadataResults() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ClientMetadataResults";
    }

    @Property(name="Entities")
    @JsonIgnore
    public CollectionPage<ClientEntityMetadata> getEntities() {
        return new CollectionPage(this.contextPath, ClientEntityMetadata.class, this.entities, Optional.ofNullable(this.entitiesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Entities")
    @JsonIgnore
    public CollectionPage<ClientEntityMetadata> getEntities(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, ClientEntityMetadata.class, this.entities, Optional.ofNullable(this.entitiesNextLink), Collections.emptyList(), options);
    }

    @Property(name="RelationshipNavigationEntities")
    @JsonIgnore
    public CollectionPage<ClientEntityMetadata> getRelationshipNavigationEntities() {
        return new CollectionPage(this.contextPath, ClientEntityMetadata.class, this.relationshipNavigationEntities, Optional.ofNullable(this.relationshipNavigationEntitiesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="RelationshipNavigationEntities")
    @JsonIgnore
    public CollectionPage<ClientEntityMetadata> getRelationshipNavigationEntities(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, ClientEntityMetadata.class, this.relationshipNavigationEntities, Optional.ofNullable(this.relationshipNavigationEntitiesNextLink), Collections.emptyList(), options);
    }

    @Property(name="OtherMetadata")
    @JsonIgnore
    public Optional<String> getOtherMetadata() {
        return Optional.ofNullable(this.otherMetadata);
    }

    public ClientMetadataResults withOtherMetadata(String otherMetadata) {
        ClientMetadataResults _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ClientMetadataResults");
        _x.otherMetadata = otherMetadata;
        return _x;
    }

    public ClientMetadataResults withUnmappedField(String name, Object value) {
        ClientMetadataResults _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private ClientMetadataResults _copy() {
        ClientMetadataResults _x = new ClientMetadataResults();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.entities = this.entities;
        _x.relationshipNavigationEntities = this.relationshipNavigationEntities;
        _x.otherMetadata = this.otherMetadata;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ClientMetadataResults[");
        b.append("Entities=");
        b.append(this.entities);
        b.append(", ");
        b.append("RelationshipNavigationEntities=");
        b.append(this.relationshipNavigationEntities);
        b.append(", ");
        b.append("OtherMetadata=");
        b.append(this.otherMetadata);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private List<ClientEntityMetadata> entities;
        private String entitiesNextLink;
        private List<ClientEntityMetadata> relationshipNavigationEntities;
        private String relationshipNavigationEntitiesNextLink;
        private String otherMetadata;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder entities(List<ClientEntityMetadata> entities) {
            this.entities = entities;
            this.changedFields = this.changedFields.add("Entities");
            return this;
        }

        public Builder entities(ClientEntityMetadata ... entities) {
            return this.entities(Arrays.asList(entities));
        }

        public Builder entitiesNextLink(String entitiesNextLink) {
            this.entitiesNextLink = entitiesNextLink;
            this.changedFields = this.changedFields.add("Entities");
            return this;
        }

        public Builder relationshipNavigationEntities(List<ClientEntityMetadata> relationshipNavigationEntities) {
            this.relationshipNavigationEntities = relationshipNavigationEntities;
            this.changedFields = this.changedFields.add("RelationshipNavigationEntities");
            return this;
        }

        public Builder relationshipNavigationEntities(ClientEntityMetadata ... relationshipNavigationEntities) {
            return this.relationshipNavigationEntities(Arrays.asList(relationshipNavigationEntities));
        }

        public Builder relationshipNavigationEntitiesNextLink(String relationshipNavigationEntitiesNextLink) {
            this.relationshipNavigationEntitiesNextLink = relationshipNavigationEntitiesNextLink;
            this.changedFields = this.changedFields.add("RelationshipNavigationEntities");
            return this;
        }

        public Builder otherMetadata(String otherMetadata) {
            this.otherMetadata = otherMetadata;
            this.changedFields = this.changedFields.add("OtherMetadata");
            return this;
        }

        public ClientMetadataResults build() {
            ClientMetadataResults _x = new ClientMetadataResults();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ClientMetadataResults";
            _x.entities = this.entities;
            _x.entitiesNextLink = this.entitiesNextLink;
            _x.relationshipNavigationEntities = this.relationshipNavigationEntities;
            _x.relationshipNavigationEntitiesNextLink = this.relationshipNavigationEntitiesNextLink;
            _x.otherMetadata = this.otherMetadata;
            return _x;
        }
    }
}

