package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.RetrieveAbsoluteAndSiteCollectionUrlResponse;
import microsoft.dynamics.crm.entity.Sharepointdocumentlocation;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SharepointdocumentlocationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class SharepointdocumentlocationRequest extends EntityRequest<Sharepointdocumentlocation> {

    public SharepointdocumentlocationRequest(ContextPath contextPath, Optional<Object> value) {
        super(Sharepointdocumentlocation.class, contextPath, value, false);
    }

    public KnowledgearticleRequest regardingobjectid_knowledgearticle() {
        return new KnowledgearticleRequest(contextPath.addSegment("regardingobjectid_knowledgearticle"), Optional.empty());
    }

    public SystemuserRequest owninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public AccountRequest regardingobjectid_account() {
        return new AccountRequest(contextPath.addSegment("regardingobjectid_account"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest sharepointdocumentlocation_principalobjectattributeaccess(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("sharepointdocumentlocation_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest sharepointdocumentlocation_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("sharepointdocumentlocation_principalobjectattributeaccess"), Optional.empty());
    }

    public SharepointdocumentlocationRequest parentsiteorlocation_sharepointdocumentlocation() {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("parentsiteorlocation_sharepointdocumentlocation"), Optional.empty());
    }

    public SharepointdocumentlocationRequest sharepointdocumentlocation_parent_sharepointdocumentlocation(UUID sharepointdocumentlocationid) {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("sharepointdocumentlocation_parent_sharepointdocumentlocation").addKeys(new NameValue(sharepointdocumentlocationid, UUID.class)), Optional.empty());
    }

    public SharepointdocumentlocationCollectionRequest sharepointdocumentlocation_parent_sharepointdocumentlocation() {
        return new SharepointdocumentlocationCollectionRequest(
                        contextPath.addSegment("sharepointdocumentlocation_parent_sharepointdocumentlocation"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public DuplicaterecordRequest sharePointDocumentLocation_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("SharePointDocumentLocation_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest sharePointDocumentLocation_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("SharePointDocumentLocation_DuplicateBaseRecord"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SharepointsiteRequest parentsiteorlocation_sharepointsite() {
        return new SharepointsiteRequest(contextPath.addSegment("parentsiteorlocation_sharepointsite"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public KbarticleRequest regardingobjectid_kbarticle() {
        return new KbarticleRequest(contextPath.addSegment("regardingobjectid_kbarticle"), Optional.empty());
    }

    public DuplicaterecordRequest sharePointDocumentLocation_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("SharePointDocumentLocation_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest sharePointDocumentLocation_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("SharePointDocumentLocation_DuplicateMatchingRecord"), Optional.empty());
    }

    public ProcesssessionRequest sharePointDocumentLocation_ProcessSessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("SharePointDocumentLocation_ProcessSessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest sharePointDocumentLocation_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("SharePointDocumentLocation_ProcessSessions"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

    public SyncerrorRequest sharePointDocumentLocation_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("SharePointDocumentLocation_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest sharePointDocumentLocation_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("SharePointDocumentLocation_SyncErrors"), Optional.empty());
    }

    public AsyncoperationRequest sharePointDocumentLocation_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("SharePointDocumentLocation_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest sharePointDocumentLocation_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("SharePointDocumentLocation_AsyncOperations"), Optional.empty());
    }

    public Msdyn_knowledgearticletemplateRequest regardingobjectid_msdyn_knowledgearticletemplate() {
        return new Msdyn_knowledgearticletemplateRequest(contextPath.addSegment("regardingobjectid_msdyn_knowledgearticletemplate"), Optional.empty());
    }

    @Function(name = "RetrieveAbsoluteAndSiteCollectionUrl")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveAbsoluteAndSiteCollectionUrlResponse> retrieveAbsoluteAndSiteCollectionUrl() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveAbsoluteAndSiteCollectionUrlResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveAbsoluteAndSiteCollectionUrl"), RetrieveAbsoluteAndSiteCollectionUrlResponse.class, _parameters);
    }

}
