package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Post;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostcommentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostlikeCollectionRequest;

@JsonIgnoreType
public class PostRequest extends EntityRequest<Post> {

    public PostRequest(ContextPath contextPath, Optional<Object> value) {
        super(Post.class, contextPath, value, false);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public AsyncoperationRequest post_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("post_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest post_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("post_AsyncOperations"), Optional.empty());
    }

    public BulkdeletefailureRequest post_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("post_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest post_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("post_BulkDeleteFailures"), Optional.empty());
    }

    public PostregardingRequest postregardingid() {
        return new PostregardingRequest(contextPath.addSegment("postregardingid"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public PostcommentRequest post_Comments(UUID postcommentid) {
        return new PostcommentRequest(contextPath.addSegment("Post_Comments").addKeys(new NameValue(postcommentid, UUID.class)), Optional.empty());
    }

    public PostcommentCollectionRequest post_Comments() {
        return new PostcommentCollectionRequest(
                        contextPath.addSegment("Post_Comments"), Optional.empty());
    }

    public PostlikeRequest post_Likes(UUID postlikeid) {
        return new PostlikeRequest(contextPath.addSegment("Post_Likes").addKeys(new NameValue(postlikeid, UUID.class)), Optional.empty());
    }

    public PostlikeCollectionRequest post_Likes() {
        return new PostlikeCollectionRequest(
                        contextPath.addSegment("Post_Likes"), Optional.empty());
    }

}
