package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Msdyn_analysisresult;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_analysisresultdetailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class Msdyn_analysisresultRequest extends EntityRequest<Msdyn_analysisresult> {

    public Msdyn_analysisresultRequest(ContextPath contextPath, Optional<Object> value) {
        super(Msdyn_analysisresult.class, contextPath, value, false);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest owninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public SyncerrorRequest msdyn_analysisresult_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("msdyn_analysisresult_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest msdyn_analysisresult_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("msdyn_analysisresult_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_analysisresult_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_analysisresult_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_analysisresult_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_analysisresult_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_analysisresult_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_analysisresult_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_analysisresult_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_analysisresult_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest msdyn_analysisresult_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("msdyn_analysisresult_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest msdyn_analysisresult_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("msdyn_analysisresult_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest msdyn_analysisresult_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("msdyn_analysisresult_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest msdyn_analysisresult_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("msdyn_analysisresult_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest msdyn_analysisresult_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("msdyn_analysisresult_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest msdyn_analysisresult_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("msdyn_analysisresult_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest msdyn_analysisresult_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("msdyn_analysisresult_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest msdyn_analysisresult_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("msdyn_analysisresult_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest msdyn_analysisresult_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("msdyn_analysisresult_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest msdyn_analysisresult_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("msdyn_analysisresult_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public Msdyn_analysiscomponentRequest msdyn_AnalysisComponentId() {
        return new Msdyn_analysiscomponentRequest(contextPath.addSegment("msdyn_AnalysisComponentId"), Optional.empty());
    }

    public Msdyn_analysisjobRequest msdyn_AnalysisJobId() {
        return new Msdyn_analysisjobRequest(contextPath.addSegment("msdyn_AnalysisJobId"), Optional.empty());
    }

    public Msdyn_analysisresultdetailRequest msdyn_msdyn_analysisresult_msdyn_analysisresultdetail_AnalysisResult(UUID msdyn_analysisresultdetailid) {
        return new Msdyn_analysisresultdetailRequest(contextPath.addSegment("msdyn_msdyn_analysisresult_msdyn_analysisresultdetail_AnalysisResult").addKeys(new NameValue(msdyn_analysisresultdetailid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisresultdetailCollectionRequest msdyn_msdyn_analysisresult_msdyn_analysisresultdetail_AnalysisResult() {
        return new Msdyn_analysisresultdetailCollectionRequest(
                        contextPath.addSegment("msdyn_msdyn_analysisresult_msdyn_analysisresultdetail_AnalysisResult"), Optional.empty());
    }

}
