package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.GetDistinctValuesImportFileResponse;
import microsoft.dynamics.crm.complex.GetHeaderColumnsImportFileResponse;
import microsoft.dynamics.crm.entity.Importfile;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportdataCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportlogCollectionRequest;

@JsonIgnoreType
public class ImportfileRequest extends EntityRequest<Importfile> {

    public ImportfileRequest(ContextPath contextPath, Optional<Object> value) {
        super(Importfile.class, contextPath, value, false);
    }

    public AsyncoperationRequest importFile_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("ImportFile_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest importFile_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("ImportFile_AsyncOperations"), Optional.empty());
    }

    public BulkdeletefailureRequest importFile_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("ImportFile_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest importFile_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("ImportFile_BulkDeleteFailures"), Optional.empty());
    }

    public TeamRequest recordsownerid_team() {
        return new TeamRequest(contextPath.addSegment("recordsownerid_team"), Optional.empty());
    }

    public SystemuserRequest owninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public ImportdataRequest importFile_ImportData(UUID importdataid) {
        return new ImportdataRequest(contextPath.addSegment("ImportFile_ImportData").addKeys(new NameValue(importdataid, UUID.class)), Optional.empty());
    }

    public ImportdataCollectionRequest importFile_ImportData() {
        return new ImportdataCollectionRequest(
                        contextPath.addSegment("ImportFile_ImportData"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public ImportRequest importid() {
        return new ImportRequest(contextPath.addSegment("importid"), Optional.empty());
    }

    public SystemuserRequest recordsownerid_systemuser() {
        return new SystemuserRequest(contextPath.addSegment("recordsownerid_systemuser"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public ImportlogRequest importLog_ImportFile(UUID importlogid) {
        return new ImportlogRequest(contextPath.addSegment("ImportLog_ImportFile").addKeys(new NameValue(importlogid, UUID.class)), Optional.empty());
    }

    public ImportlogCollectionRequest importLog_ImportFile() {
        return new ImportlogCollectionRequest(
                        contextPath.addSegment("ImportLog_ImportFile"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public ImportmapRequest importmapid() {
        return new ImportmapRequest(contextPath.addSegment("importmapid"), Optional.empty());
    }

    @Function(name = "GetDistinctValuesImportFile")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<GetDistinctValuesImportFileResponse> getDistinctValuesImportFile(Integer columnNumber, Integer pageNumber, Integer recordsPerPage) {
        Preconditions.checkNotNull(columnNumber, "columnNumber cannot be null");
        Preconditions.checkNotNull(pageNumber, "pageNumber cannot be null");
        Preconditions.checkNotNull(recordsPerPage, "recordsPerPage cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("columnNumber", "Edm.Int32", columnNumber)
            .put("pageNumber", "Edm.Int32", pageNumber)
            .put("recordsPerPage", "Edm.Int32", recordsPerPage)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<GetDistinctValuesImportFileResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GetDistinctValuesImportFile"), GetDistinctValuesImportFileResponse.class, _parameters);
    }

    @Function(name = "GetHeaderColumnsImportFile")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<GetHeaderColumnsImportFileResponse> getHeaderColumnsImportFile() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<GetHeaderColumnsImportFileResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GetHeaderColumnsImportFile"), GetHeaderColumnsImportFileResponse.class, _parameters);
    }

}
