package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Entityimageconfig;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class EntityimageconfigRequest extends EntityRequest<Entityimageconfig> {

    public EntityimageconfigRequest(ContextPath contextPath, Optional<Object> value) {
        super(Entityimageconfig.class, contextPath, value, false);
    }

    public SyncerrorRequest entityimageconfig_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("entityimageconfig_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest entityimageconfig_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("entityimageconfig_SyncErrors"), Optional.empty());
    }

    public AsyncoperationRequest entityimageconfig_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("entityimageconfig_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest entityimageconfig_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("entityimageconfig_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest entityimageconfig_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("entityimageconfig_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest entityimageconfig_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("entityimageconfig_MailboxTrackingFolders"), Optional.empty());
    }

    public BulkdeletefailureRequest entityimageconfig_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("entityimageconfig_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest entityimageconfig_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("entityimageconfig_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest entityimageconfig_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("entityimageconfig_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest entityimageconfig_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("entityimageconfig_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

}
