package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Datalakeworkspacepermission;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class DatalakeworkspacepermissionRequest extends EntityRequest<Datalakeworkspacepermission> {

    public DatalakeworkspacepermissionRequest(ContextPath contextPath, Optional<Object> value) {
        super(Datalakeworkspacepermission.class, contextPath, value, false);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public SyncerrorRequest datalakeworkspacepermission_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("datalakeworkspacepermission_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest datalakeworkspacepermission_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("datalakeworkspacepermission_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest datalakeworkspacepermission_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("datalakeworkspacepermission_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest datalakeworkspacepermission_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("datalakeworkspacepermission_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest datalakeworkspacepermission_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("datalakeworkspacepermission_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest datalakeworkspacepermission_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("datalakeworkspacepermission_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest datalakeworkspacepermission_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("datalakeworkspacepermission_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest datalakeworkspacepermission_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("datalakeworkspacepermission_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest datalakeworkspacepermission_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("datalakeworkspacepermission_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest datalakeworkspacepermission_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("datalakeworkspacepermission_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest datalakeworkspacepermission_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("datalakeworkspacepermission_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest datalakeworkspacepermission_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("datalakeworkspacepermission_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest datalakeworkspacepermission_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("datalakeworkspacepermission_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest datalakeworkspacepermission_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("datalakeworkspacepermission_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest datalakeworkspacepermission_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("datalakeworkspacepermission_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest datalakeworkspacepermission_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("datalakeworkspacepermission_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public DatalakeworkspaceRequest workspaceid() {
        return new DatalakeworkspaceRequest(contextPath.addSegment("workspaceid"), Optional.empty());
    }

}
