package microsoft.dynamics.crm.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Socialprofile;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.ConnectionRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SocialactivityRequest;
import microsoft.dynamics.crm.entity.request.SocialprofileRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class SocialprofileCollectionRequest extends CollectionPageEntityRequest<Socialprofile, SocialprofileRequest>{

    protected ContextPath contextPath;

    public SocialprofileCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Socialprofile.class, cp -> new SocialprofileRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DuplicaterecordRequest socialProfile_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("SocialProfile_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest socialProfile_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("SocialProfile_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest socialProfile_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("SocialProfile_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest socialProfile_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("SocialProfile_AsyncOperations"), Optional.empty());
    }

    public ConnectionRequest socialprofile_connections1(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("socialprofile_connections1").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest socialprofile_connections1() {
        return new ConnectionCollectionRequest(contextPath.addSegment("socialprofile_connections1"), Optional.empty());
    }

    public ConnectionRequest socialprofile_connections2(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("socialprofile_connections2").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest socialprofile_connections2() {
        return new ConnectionCollectionRequest(contextPath.addSegment("socialprofile_connections2"), Optional.empty());
    }

    public SyncerrorRequest socialProfile_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("SocialProfile_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest socialProfile_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("SocialProfile_SyncErrors"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest socialprofile_principalobjectattributeaccess(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("socialprofile_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest socialprofile_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("socialprofile_principalobjectattributeaccess"), Optional.empty());
    }

    public SocialactivityRequest socialprofile_SocialActivities(UUID activityid) {
        return new SocialactivityRequest(contextPath.addSegment("Socialprofile_SocialActivities").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public SocialactivityCollectionRequest socialprofile_SocialActivities() {
        return new SocialactivityCollectionRequest(contextPath.addSegment("Socialprofile_SocialActivities"), Optional.empty());
    }

    public ProcesssessionRequest socialProfile_ProcessSessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("SocialProfile_ProcessSessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest socialProfile_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("SocialProfile_ProcessSessions"), Optional.empty());
    }

    public DuplicaterecordRequest socialProfile_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("SocialProfile_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest socialProfile_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("SocialProfile_DuplicateMatchingRecord"), Optional.empty());
    }

    @Action(name = "GenerateSocialProfile")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Socialprofile> generateSocialProfile(Socialprofile entity) {
        Preconditions.checkNotNull(entity, "entity cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Entity", "Microsoft.Dynamics.CRM.socialprofile", entity)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Socialprofile>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GenerateSocialProfile"), Socialprofile.class, _parameters);
    }

}
