package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Slaitem;
import microsoft.dynamics.crm.entity.request.SlaitemRequest;
import microsoft.dynamics.crm.entity.request.SlakpiinstanceRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class SlaitemCollectionRequest extends CollectionPageEntityRequest<Slaitem, SlaitemRequest>{

    protected ContextPath contextPath;

    public SlaitemCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Slaitem.class, cp -> new SlaitemRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest sLAItem_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("SLAItem_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest sLAItem_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("SLAItem_SyncErrors"), Optional.empty());
    }

    public SlakpiinstanceRequest msdyn_slaitem_slakpiinstance(UUID slakpiinstanceid) {
        return new SlakpiinstanceRequest(contextPath.addSegment("msdyn_slaitem_slakpiinstance").addKeys(new NameValue(slakpiinstanceid, UUID.class)), Optional.empty());
    }

    public SlakpiinstanceCollectionRequest msdyn_slaitem_slakpiinstance() {
        return new SlakpiinstanceCollectionRequest(contextPath.addSegment("msdyn_slaitem_slakpiinstance"), Optional.empty());
    }

}
