package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Msdyn_aimodel;
import microsoft.dynamics.crm.entity.request.AnnotationRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetscontainerRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiconfigurationRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aimodelRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class Msdyn_aimodelCollectionRequest extends CollectionPageEntityRequest<Msdyn_aimodel, Msdyn_aimodelRequest>{

    protected ContextPath contextPath;

    public Msdyn_aimodelCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Msdyn_aimodel.class, cp -> new Msdyn_aimodelRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest msdyn_aimodel_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("msdyn_aimodel_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest msdyn_aimodel_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("msdyn_aimodel_SyncErrors"), Optional.empty());
    }

    public AsyncoperationRequest msdyn_aimodel_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("msdyn_aimodel_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest msdyn_aimodel_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("msdyn_aimodel_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest msdyn_aimodel_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("msdyn_aimodel_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest msdyn_aimodel_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("msdyn_aimodel_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest msdyn_aimodel_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("msdyn_aimodel_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest msdyn_aimodel_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("msdyn_aimodel_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest msdyn_aimodel_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("msdyn_aimodel_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest msdyn_aimodel_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("msdyn_aimodel_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest msdyn_aimodel_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("msdyn_aimodel_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest msdyn_aimodel_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("msdyn_aimodel_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public AnnotationRequest msdyn_aimodel_Annotations(UUID annotationid) {
        return new AnnotationRequest(contextPath.addSegment("msdyn_aimodel_Annotations").addKeys(new NameValue(annotationid, UUID.class)), Optional.empty());
    }

    public AnnotationCollectionRequest msdyn_aimodel_Annotations() {
        return new AnnotationCollectionRequest(contextPath.addSegment("msdyn_aimodel_Annotations"), Optional.empty());
    }

    public Msdyn_aiconfigurationRequest msdyn_aimodel_msdyn_aiconfiguration(UUID msdyn_aiconfigurationid) {
        return new Msdyn_aiconfigurationRequest(contextPath.addSegment("msdyn_aimodel_msdyn_aiconfiguration").addKeys(new NameValue(msdyn_aiconfigurationid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiconfigurationCollectionRequest msdyn_aimodel_msdyn_aiconfiguration() {
        return new Msdyn_aiconfigurationCollectionRequest(contextPath.addSegment("msdyn_aimodel_msdyn_aiconfiguration"), Optional.empty());
    }

    public Msdyn_aibdatasetscontainerRequest msdyn_AIBDatasetsContainer_msdyn_AIModelI(UUID msdyn_aibdatasetscontainerid) {
        return new Msdyn_aibdatasetscontainerRequest(contextPath.addSegment("msdyn_AIBDatasetsContainer_msdyn_AIModelI").addKeys(new NameValue(msdyn_aibdatasetscontainerid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetscontainerCollectionRequest msdyn_AIBDatasetsContainer_msdyn_AIModelI() {
        return new Msdyn_aibdatasetscontainerCollectionRequest(contextPath.addSegment("msdyn_AIBDatasetsContainer_msdyn_AIModelI"), Optional.empty());
    }

}
