package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Msdyn_aibdatasetrecord;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetrecordRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class Msdyn_aibdatasetrecordCollectionRequest extends CollectionPageEntityRequest<Msdyn_aibdatasetrecord, Msdyn_aibdatasetrecordRequest>{

    protected ContextPath contextPath;

    public Msdyn_aibdatasetrecordCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Msdyn_aibdatasetrecord.class, cp -> new Msdyn_aibdatasetrecordRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest msdyn_aibdatasetrecord_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("msdyn_aibdatasetrecord_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest msdyn_aibdatasetrecord_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("msdyn_aibdatasetrecord_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_aibdatasetrecord_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_aibdatasetrecord_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_aibdatasetrecord_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("msdyn_aibdatasetrecord_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_aibdatasetrecord_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_aibdatasetrecord_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_aibdatasetrecord_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("msdyn_aibdatasetrecord_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest msdyn_aibdatasetrecord_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("msdyn_aibdatasetrecord_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest msdyn_aibdatasetrecord_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("msdyn_aibdatasetrecord_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest msdyn_aibdatasetrecord_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("msdyn_aibdatasetrecord_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest msdyn_aibdatasetrecord_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("msdyn_aibdatasetrecord_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest msdyn_aibdatasetrecord_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("msdyn_aibdatasetrecord_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest msdyn_aibdatasetrecord_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("msdyn_aibdatasetrecord_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest msdyn_aibdatasetrecord_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("msdyn_aibdatasetrecord_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest msdyn_aibdatasetrecord_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("msdyn_aibdatasetrecord_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest msdyn_aibdatasetrecord_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("msdyn_aibdatasetrecord_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest msdyn_aibdatasetrecord_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("msdyn_aibdatasetrecord_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

}
