package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Monthlyfiscalcalendar;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.MonthlyfiscalcalendarRequest;

public class MonthlyfiscalcalendarCollectionRequest extends CollectionPageEntityRequest<Monthlyfiscalcalendar, MonthlyfiscalcalendarRequest>{

    protected ContextPath contextPath;

    public MonthlyfiscalcalendarCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Monthlyfiscalcalendar.class, cp -> new MonthlyfiscalcalendarRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AsyncoperationRequest monthlyFiscalCalendar_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("MonthlyFiscalCalendar_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest monthlyFiscalCalendar_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("MonthlyFiscalCalendar_AsyncOperations"), Optional.empty());
    }

    public BulkdeletefailureRequest monthlyFiscalCalendar_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("MonthlyFiscalCalendar_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest monthlyFiscalCalendar_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("MonthlyFiscalCalendar_BulkDeleteFailures"), Optional.empty());
    }

}
