package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.entity.request.WebresourceRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_owninguser_value", 
    "_webresourceid_value", 
    "_owningbusinessunit_value", 
    "userqueryvisualizationid", 
    "versionnumber", 
    "presentationdescription", 
    "isdefault", 
    "_ownerid_value", 
    "primaryentitytypecode", 
    "charttype", 
    "_modifiedby_value", 
    "_createdonbehalfby_value", 
    "createdon", 
    "modifiedon", 
    "_createdby_value", 
    "name", 
    "_modifiedonbehalfby_value", 
    "_owningteam_value", 
    "description", 
    "datadescription"})
@JsonInclude(Include.NON_NULL)
public class Userqueryvisualization extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.userqueryvisualization";
    }

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("_webresourceid_value")
    protected UUID _webresourceid_value;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("userqueryvisualizationid")
    protected UUID userqueryvisualizationid;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("presentationdescription")
    protected String presentationdescription;

    @JsonProperty("isdefault")
    protected Boolean isdefault;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("primaryentitytypecode")
    protected String primaryentitytypecode;

    @JsonProperty("charttype")
    protected Integer charttype;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("datadescription")
    protected String datadescription;

    protected Userqueryvisualization() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserqueryvisualization() {
        return new Builder();
    }

    public static final class Builder {
        private UUID _owninguser_value;
        private UUID _webresourceid_value;
        private UUID _owningbusinessunit_value;
        private UUID userqueryvisualizationid;
        private Long versionnumber;
        private String presentationdescription;
        private Boolean isdefault;
        private UUID _ownerid_value;
        private String primaryentitytypecode;
        private Integer charttype;
        private UUID _modifiedby_value;
        private UUID _createdonbehalfby_value;
        private OffsetDateTime createdon;
        private OffsetDateTime modifiedon;
        private UUID _createdby_value;
        private String name;
        private UUID _modifiedonbehalfby_value;
        private UUID _owningteam_value;
        private String description;
        private String datadescription;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder _webresourceid_value(UUID _webresourceid_value) {
            this._webresourceid_value = _webresourceid_value;
            this.changedFields = changedFields.add("_webresourceid_value");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder userqueryvisualizationid(UUID userqueryvisualizationid) {
            this.userqueryvisualizationid = userqueryvisualizationid;
            this.changedFields = changedFields.add("userqueryvisualizationid");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder presentationdescription(String presentationdescription) {
            this.presentationdescription = presentationdescription;
            this.changedFields = changedFields.add("presentationdescription");
            return this;
        }

        public Builder isdefault(Boolean isdefault) {
            this.isdefault = isdefault;
            this.changedFields = changedFields.add("isdefault");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder primaryentitytypecode(String primaryentitytypecode) {
            this.primaryentitytypecode = primaryentitytypecode;
            this.changedFields = changedFields.add("primaryentitytypecode");
            return this;
        }

        public Builder charttype(Integer charttype) {
            this.charttype = charttype;
            this.changedFields = changedFields.add("charttype");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder datadescription(String datadescription) {
            this.datadescription = datadescription;
            this.changedFields = changedFields.add("datadescription");
            return this;
        }

        public Userqueryvisualization build() {
            Userqueryvisualization _x = new Userqueryvisualization();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.userqueryvisualization";
            _x._owninguser_value = _owninguser_value;
            _x._webresourceid_value = _webresourceid_value;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.userqueryvisualizationid = userqueryvisualizationid;
            _x.versionnumber = versionnumber;
            _x.presentationdescription = presentationdescription;
            _x.isdefault = isdefault;
            _x._ownerid_value = _ownerid_value;
            _x.primaryentitytypecode = primaryentitytypecode;
            _x.charttype = charttype;
            _x._modifiedby_value = _modifiedby_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.createdon = createdon;
            _x.modifiedon = modifiedon;
            _x._createdby_value = _createdby_value;
            _x.name = name;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._owningteam_value = _owningteam_value;
            _x.description = description;
            _x.datadescription = datadescription;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && userqueryvisualizationid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(userqueryvisualizationid, UUID.class));
        }
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Userqueryvisualization with_owninguser_value(UUID _owninguser_value) {
        Userqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userqueryvisualization");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="_webresourceid_value")
    @JsonIgnore
    public Optional<UUID> get_webresourceid_value() {
        return Optional.ofNullable(_webresourceid_value);
    }

    public Userqueryvisualization with_webresourceid_value(UUID _webresourceid_value) {
        Userqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("_webresourceid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userqueryvisualization");
        _x._webresourceid_value = _webresourceid_value;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Userqueryvisualization with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Userqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userqueryvisualization");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="userqueryvisualizationid")
    @JsonIgnore
    public Optional<UUID> getUserqueryvisualizationid() {
        return Optional.ofNullable(userqueryvisualizationid);
    }

    public Userqueryvisualization withUserqueryvisualizationid(UUID userqueryvisualizationid) {
        Userqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("userqueryvisualizationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userqueryvisualization");
        _x.userqueryvisualizationid = userqueryvisualizationid;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Userqueryvisualization withVersionnumber(Long versionnumber) {
        Userqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userqueryvisualization");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="presentationdescription")
    @JsonIgnore
    public Optional<String> getPresentationdescription() {
        return Optional.ofNullable(presentationdescription);
    }

    public Userqueryvisualization withPresentationdescription(String presentationdescription) {
        Userqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("presentationdescription");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userqueryvisualization");
        _x.presentationdescription = presentationdescription;
        return _x;
    }

    @Property(name="isdefault")
    @JsonIgnore
    public Optional<Boolean> getIsdefault() {
        return Optional.ofNullable(isdefault);
    }

    public Userqueryvisualization withIsdefault(Boolean isdefault) {
        Userqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("isdefault");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userqueryvisualization");
        _x.isdefault = isdefault;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Userqueryvisualization with_ownerid_value(UUID _ownerid_value) {
        Userqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userqueryvisualization");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="primaryentitytypecode")
    @JsonIgnore
    public Optional<String> getPrimaryentitytypecode() {
        return Optional.ofNullable(primaryentitytypecode);
    }

    public Userqueryvisualization withPrimaryentitytypecode(String primaryentitytypecode) {
        Userqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("primaryentitytypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userqueryvisualization");
        _x.primaryentitytypecode = primaryentitytypecode;
        return _x;
    }

    @Property(name="charttype")
    @JsonIgnore
    public Optional<Integer> getCharttype() {
        return Optional.ofNullable(charttype);
    }

    public Userqueryvisualization withCharttype(Integer charttype) {
        Userqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("charttype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userqueryvisualization");
        _x.charttype = charttype;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Userqueryvisualization with_modifiedby_value(UUID _modifiedby_value) {
        Userqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userqueryvisualization");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Userqueryvisualization with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Userqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userqueryvisualization");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Userqueryvisualization withCreatedon(OffsetDateTime createdon) {
        Userqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userqueryvisualization");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Userqueryvisualization withModifiedon(OffsetDateTime modifiedon) {
        Userqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userqueryvisualization");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Userqueryvisualization with_createdby_value(UUID _createdby_value) {
        Userqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userqueryvisualization");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Userqueryvisualization withName(String name) {
        Userqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userqueryvisualization");
        _x.name = name;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Userqueryvisualization with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Userqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userqueryvisualization");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Userqueryvisualization with_owningteam_value(UUID _owningteam_value) {
        Userqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userqueryvisualization");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Userqueryvisualization withDescription(String description) {
        Userqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userqueryvisualization");
        _x.description = description;
        return _x;
    }

    @Property(name="datadescription")
    @JsonIgnore
    public Optional<String> getDatadescription() {
        return Optional.ofNullable(datadescription);
    }

    public Userqueryvisualization withDatadescription(String datadescription) {
        Userqueryvisualization _x = _copy();
        _x.changedFields = changedFields.add("datadescription");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userqueryvisualization");
        _x.datadescription = datadescription;
        return _x;
    }

    public Userqueryvisualization withUnmappedField(String name, Object value) {
        Userqueryvisualization _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="UserQueryVisualization_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getUserQueryVisualization_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("UserQueryVisualization_SyncErrors"), RequestHelper.getValue(unmappedFields, "UserQueryVisualization_SyncErrors"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="webresourceid")
    @JsonIgnore
    public WebresourceRequest getWebresourceid() {
        return new WebresourceRequest(contextPath.addSegment("webresourceid"), RequestHelper.getValue(unmappedFields, "webresourceid"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Userqueryvisualization patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Userqueryvisualization _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Userqueryvisualization put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Userqueryvisualization _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Userqueryvisualization _copy() {
        Userqueryvisualization _x = new Userqueryvisualization();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._owninguser_value = _owninguser_value;
        _x._webresourceid_value = _webresourceid_value;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.userqueryvisualizationid = userqueryvisualizationid;
        _x.versionnumber = versionnumber;
        _x.presentationdescription = presentationdescription;
        _x.isdefault = isdefault;
        _x._ownerid_value = _ownerid_value;
        _x.primaryentitytypecode = primaryentitytypecode;
        _x.charttype = charttype;
        _x._modifiedby_value = _modifiedby_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.createdon = createdon;
        _x.modifiedon = modifiedon;
        _x._createdby_value = _createdby_value;
        _x.name = name;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._owningteam_value = _owningteam_value;
        _x.description = description;
        _x.datadescription = datadescription;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Userqueryvisualization[");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("_webresourceid_value=");
        b.append(this._webresourceid_value);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("userqueryvisualizationid=");
        b.append(this.userqueryvisualizationid);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("presentationdescription=");
        b.append(this.presentationdescription);
        b.append(", ");
        b.append("isdefault=");
        b.append(this.isdefault);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("primaryentitytypecode=");
        b.append(this.primaryentitytypecode);
        b.append(", ");
        b.append("charttype=");
        b.append(this.charttype);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("datadescription=");
        b.append(this.datadescription);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
