package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "modifiedon", 
    "_modifiedonbehalfby_value", 
    "usermappingid", 
    "_createdonbehalfby_value", 
    "systemuserattributename", 
    "_organizationid_value", 
    "exchangerate", 
    "createdon", 
    "versionnumber", 
    "_transactioncurrencyid_value", 
    "_createdby_value", 
    "claimtype", 
    "partnerapplicationtype", 
    "utcconversiontimezonecode", 
    "timezoneruleversionnumber", 
    "_modifiedby_value"})
@JsonInclude(Include.NON_NULL)
public class Usermapping extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.usermapping";
    }

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("usermappingid")
    protected UUID usermappingid;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("systemuserattributename")
    protected String systemuserattributename;

    @JsonProperty("_organizationid_value")
    protected UUID _organizationid_value;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_transactioncurrencyid_value")
    protected UUID _transactioncurrencyid_value;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("claimtype")
    protected String claimtype;

    @JsonProperty("partnerapplicationtype")
    protected Integer partnerapplicationtype;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    protected Usermapping() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUsermapping() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime modifiedon;
        private UUID _modifiedonbehalfby_value;
        private UUID usermappingid;
        private UUID _createdonbehalfby_value;
        private String systemuserattributename;
        private UUID _organizationid_value;
        private BigDecimal exchangerate;
        private OffsetDateTime createdon;
        private Long versionnumber;
        private UUID _transactioncurrencyid_value;
        private UUID _createdby_value;
        private String claimtype;
        private Integer partnerapplicationtype;
        private Integer utcconversiontimezonecode;
        private Integer timezoneruleversionnumber;
        private UUID _modifiedby_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder usermappingid(UUID usermappingid) {
            this.usermappingid = usermappingid;
            this.changedFields = changedFields.add("usermappingid");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder systemuserattributename(String systemuserattributename) {
            this.systemuserattributename = systemuserattributename;
            this.changedFields = changedFields.add("systemuserattributename");
            return this;
        }

        public Builder _organizationid_value(UUID _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder claimtype(String claimtype) {
            this.claimtype = claimtype;
            this.changedFields = changedFields.add("claimtype");
            return this;
        }

        public Builder partnerapplicationtype(Integer partnerapplicationtype) {
            this.partnerapplicationtype = partnerapplicationtype;
            this.changedFields = changedFields.add("partnerapplicationtype");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Usermapping build() {
            Usermapping _x = new Usermapping();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.usermapping";
            _x.modifiedon = modifiedon;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.usermappingid = usermappingid;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.systemuserattributename = systemuserattributename;
            _x._organizationid_value = _organizationid_value;
            _x.exchangerate = exchangerate;
            _x.createdon = createdon;
            _x.versionnumber = versionnumber;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x._createdby_value = _createdby_value;
            _x.claimtype = claimtype;
            _x.partnerapplicationtype = partnerapplicationtype;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x._modifiedby_value = _modifiedby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && usermappingid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(usermappingid, UUID.class));
        }
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Usermapping withModifiedon(OffsetDateTime modifiedon) {
        Usermapping _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.usermapping");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Usermapping with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Usermapping _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.usermapping");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="usermappingid")
    @JsonIgnore
    public Optional<UUID> getUsermappingid() {
        return Optional.ofNullable(usermappingid);
    }

    public Usermapping withUsermappingid(UUID usermappingid) {
        Usermapping _x = _copy();
        _x.changedFields = changedFields.add("usermappingid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.usermapping");
        _x.usermappingid = usermappingid;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Usermapping with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Usermapping _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.usermapping");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="systemuserattributename")
    @JsonIgnore
    public Optional<String> getSystemuserattributename() {
        return Optional.ofNullable(systemuserattributename);
    }

    public Usermapping withSystemuserattributename(String systemuserattributename) {
        Usermapping _x = _copy();
        _x.changedFields = changedFields.add("systemuserattributename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.usermapping");
        _x.systemuserattributename = systemuserattributename;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<UUID> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Usermapping with_organizationid_value(UUID _organizationid_value) {
        Usermapping _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.usermapping");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Usermapping withExchangerate(BigDecimal exchangerate) {
        Usermapping _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.usermapping");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Usermapping withCreatedon(OffsetDateTime createdon) {
        Usermapping _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.usermapping");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Usermapping withVersionnumber(Long versionnumber) {
        Usermapping _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.usermapping");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_transactioncurrencyid_value")
    @JsonIgnore
    public Optional<UUID> get_transactioncurrencyid_value() {
        return Optional.ofNullable(_transactioncurrencyid_value);
    }

    public Usermapping with_transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
        Usermapping _x = _copy();
        _x.changedFields = changedFields.add("_transactioncurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.usermapping");
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Usermapping with_createdby_value(UUID _createdby_value) {
        Usermapping _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.usermapping");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="claimtype")
    @JsonIgnore
    public Optional<String> getClaimtype() {
        return Optional.ofNullable(claimtype);
    }

    public Usermapping withClaimtype(String claimtype) {
        Usermapping _x = _copy();
        _x.changedFields = changedFields.add("claimtype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.usermapping");
        _x.claimtype = claimtype;
        return _x;
    }

    @Property(name="partnerapplicationtype")
    @JsonIgnore
    public Optional<Integer> getPartnerapplicationtype() {
        return Optional.ofNullable(partnerapplicationtype);
    }

    public Usermapping withPartnerapplicationtype(Integer partnerapplicationtype) {
        Usermapping _x = _copy();
        _x.changedFields = changedFields.add("partnerapplicationtype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.usermapping");
        _x.partnerapplicationtype = partnerapplicationtype;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Usermapping withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Usermapping _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.usermapping");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Usermapping withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Usermapping _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.usermapping");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Usermapping with_modifiedby_value(UUID _modifiedby_value) {
        Usermapping _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.usermapping");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    public Usermapping withUnmappedField(String name, Object value) {
        Usermapping _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="usermapping_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getUsermapping_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("usermapping_AsyncOperations"), RequestHelper.getValue(unmappedFields, "usermapping_AsyncOperations"));
    }

    @NavigationProperty(name="usermapping_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getUsermapping_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("usermapping_ProcessSession"), RequestHelper.getValue(unmappedFields, "usermapping_ProcessSession"));
    }

    @NavigationProperty(name="usermapping_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getUsermapping_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("usermapping_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "usermapping_BulkDeleteFailures"));
    }

    @NavigationProperty(name="transactioncurrencyid")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Usermapping patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Usermapping _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Usermapping put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Usermapping _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Usermapping _copy() {
        Usermapping _x = new Usermapping();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.modifiedon = modifiedon;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.usermappingid = usermappingid;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.systemuserattributename = systemuserattributename;
        _x._organizationid_value = _organizationid_value;
        _x.exchangerate = exchangerate;
        _x.createdon = createdon;
        _x.versionnumber = versionnumber;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x._createdby_value = _createdby_value;
        _x.claimtype = claimtype;
        _x.partnerapplicationtype = partnerapplicationtype;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Usermapping[");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("usermappingid=");
        b.append(this.usermappingid);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("systemuserattributename=");
        b.append(this.systemuserattributename);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("claimtype=");
        b.append(this.claimtype);
        b.append(", ");
        b.append("partnerapplicationtype=");
        b.append(this.partnerapplicationtype);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
