package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.LookupmappingCollectionRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TransformationmappingRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_transformationmappingid_value", 
    "overwritetime", 
    "parametersequence", 
    "parameterarrayindex", 
    "_modifiedby_value", 
    "introducedversion", 
    "componentstate", 
    "data", 
    "ismanaged", 
    "modifiedon", 
    "datatypecode", 
    "transformationparametermappingidunique", 
    "_createdonbehalfby_value", 
    "_modifiedonbehalfby_value", 
    "_createdby_value", 
    "solutionid", 
    "parametertypecode", 
    "createdon", 
    "transformationparametermappingid"})
@JsonInclude(Include.NON_NULL)
public class Transformationparametermapping extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.transformationparametermapping";
    }

    @JsonProperty("_transformationmappingid_value")
    protected UUID _transformationmappingid_value;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("parametersequence")
    protected Integer parametersequence;

    @JsonProperty("parameterarrayindex")
    protected Integer parameterarrayindex;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("data")
    protected String data;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("datatypecode")
    protected Integer datatypecode;

    @JsonProperty("transformationparametermappingidunique")
    protected UUID transformationparametermappingidunique;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("parametertypecode")
    protected Integer parametertypecode;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("transformationparametermappingid")
    protected UUID transformationparametermappingid;

    protected Transformationparametermapping() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTransformationparametermapping() {
        return new Builder();
    }

    public static final class Builder {
        private UUID _transformationmappingid_value;
        private OffsetDateTime overwritetime;
        private Integer parametersequence;
        private Integer parameterarrayindex;
        private UUID _modifiedby_value;
        private String introducedversion;
        private Integer componentstate;
        private String data;
        private Boolean ismanaged;
        private OffsetDateTime modifiedon;
        private Integer datatypecode;
        private UUID transformationparametermappingidunique;
        private UUID _createdonbehalfby_value;
        private UUID _modifiedonbehalfby_value;
        private UUID _createdby_value;
        private UUID solutionid;
        private Integer parametertypecode;
        private OffsetDateTime createdon;
        private UUID transformationparametermappingid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _transformationmappingid_value(UUID _transformationmappingid_value) {
            this._transformationmappingid_value = _transformationmappingid_value;
            this.changedFields = changedFields.add("_transformationmappingid_value");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder parametersequence(Integer parametersequence) {
            this.parametersequence = parametersequence;
            this.changedFields = changedFields.add("parametersequence");
            return this;
        }

        public Builder parameterarrayindex(Integer parameterarrayindex) {
            this.parameterarrayindex = parameterarrayindex;
            this.changedFields = changedFields.add("parameterarrayindex");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder data(String data) {
            this.data = data;
            this.changedFields = changedFields.add("data");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder datatypecode(Integer datatypecode) {
            this.datatypecode = datatypecode;
            this.changedFields = changedFields.add("datatypecode");
            return this;
        }

        public Builder transformationparametermappingidunique(UUID transformationparametermappingidunique) {
            this.transformationparametermappingidunique = transformationparametermappingidunique;
            this.changedFields = changedFields.add("transformationparametermappingidunique");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder parametertypecode(Integer parametertypecode) {
            this.parametertypecode = parametertypecode;
            this.changedFields = changedFields.add("parametertypecode");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder transformationparametermappingid(UUID transformationparametermappingid) {
            this.transformationparametermappingid = transformationparametermappingid;
            this.changedFields = changedFields.add("transformationparametermappingid");
            return this;
        }

        public Transformationparametermapping build() {
            Transformationparametermapping _x = new Transformationparametermapping();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.transformationparametermapping";
            _x._transformationmappingid_value = _transformationmappingid_value;
            _x.overwritetime = overwritetime;
            _x.parametersequence = parametersequence;
            _x.parameterarrayindex = parameterarrayindex;
            _x._modifiedby_value = _modifiedby_value;
            _x.introducedversion = introducedversion;
            _x.componentstate = componentstate;
            _x.data = data;
            _x.ismanaged = ismanaged;
            _x.modifiedon = modifiedon;
            _x.datatypecode = datatypecode;
            _x.transformationparametermappingidunique = transformationparametermappingidunique;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._createdby_value = _createdby_value;
            _x.solutionid = solutionid;
            _x.parametertypecode = parametertypecode;
            _x.createdon = createdon;
            _x.transformationparametermappingid = transformationparametermappingid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && transformationparametermappingid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(transformationparametermappingid, UUID.class));
        }
    }

    @Property(name="_transformationmappingid_value")
    @JsonIgnore
    public Optional<UUID> get_transformationmappingid_value() {
        return Optional.ofNullable(_transformationmappingid_value);
    }

    public Transformationparametermapping with_transformationmappingid_value(UUID _transformationmappingid_value) {
        Transformationparametermapping _x = _copy();
        _x.changedFields = changedFields.add("_transformationmappingid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationparametermapping");
        _x._transformationmappingid_value = _transformationmappingid_value;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Transformationparametermapping withOverwritetime(OffsetDateTime overwritetime) {
        Transformationparametermapping _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationparametermapping");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="parametersequence")
    @JsonIgnore
    public Optional<Integer> getParametersequence() {
        return Optional.ofNullable(parametersequence);
    }

    public Transformationparametermapping withParametersequence(Integer parametersequence) {
        Transformationparametermapping _x = _copy();
        _x.changedFields = changedFields.add("parametersequence");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationparametermapping");
        _x.parametersequence = parametersequence;
        return _x;
    }

    @Property(name="parameterarrayindex")
    @JsonIgnore
    public Optional<Integer> getParameterarrayindex() {
        return Optional.ofNullable(parameterarrayindex);
    }

    public Transformationparametermapping withParameterarrayindex(Integer parameterarrayindex) {
        Transformationparametermapping _x = _copy();
        _x.changedFields = changedFields.add("parameterarrayindex");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationparametermapping");
        _x.parameterarrayindex = parameterarrayindex;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Transformationparametermapping with_modifiedby_value(UUID _modifiedby_value) {
        Transformationparametermapping _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationparametermapping");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Transformationparametermapping withIntroducedversion(String introducedversion) {
        Transformationparametermapping _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationparametermapping");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Transformationparametermapping withComponentstate(Integer componentstate) {
        Transformationparametermapping _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationparametermapping");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="data")
    @JsonIgnore
    public Optional<String> getData() {
        return Optional.ofNullable(data);
    }

    public Transformationparametermapping withData(String data) {
        Transformationparametermapping _x = _copy();
        _x.changedFields = changedFields.add("data");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationparametermapping");
        _x.data = data;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Transformationparametermapping withIsmanaged(Boolean ismanaged) {
        Transformationparametermapping _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationparametermapping");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Transformationparametermapping withModifiedon(OffsetDateTime modifiedon) {
        Transformationparametermapping _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationparametermapping");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="datatypecode")
    @JsonIgnore
    public Optional<Integer> getDatatypecode() {
        return Optional.ofNullable(datatypecode);
    }

    public Transformationparametermapping withDatatypecode(Integer datatypecode) {
        Transformationparametermapping _x = _copy();
        _x.changedFields = changedFields.add("datatypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationparametermapping");
        _x.datatypecode = datatypecode;
        return _x;
    }

    @Property(name="transformationparametermappingidunique")
    @JsonIgnore
    public Optional<UUID> getTransformationparametermappingidunique() {
        return Optional.ofNullable(transformationparametermappingidunique);
    }

    public Transformationparametermapping withTransformationparametermappingidunique(UUID transformationparametermappingidunique) {
        Transformationparametermapping _x = _copy();
        _x.changedFields = changedFields.add("transformationparametermappingidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationparametermapping");
        _x.transformationparametermappingidunique = transformationparametermappingidunique;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Transformationparametermapping with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Transformationparametermapping _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationparametermapping");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Transformationparametermapping with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Transformationparametermapping _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationparametermapping");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Transformationparametermapping with_createdby_value(UUID _createdby_value) {
        Transformationparametermapping _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationparametermapping");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Transformationparametermapping withSolutionid(UUID solutionid) {
        Transformationparametermapping _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationparametermapping");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="parametertypecode")
    @JsonIgnore
    public Optional<Integer> getParametertypecode() {
        return Optional.ofNullable(parametertypecode);
    }

    public Transformationparametermapping withParametertypecode(Integer parametertypecode) {
        Transformationparametermapping _x = _copy();
        _x.changedFields = changedFields.add("parametertypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationparametermapping");
        _x.parametertypecode = parametertypecode;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Transformationparametermapping withCreatedon(OffsetDateTime createdon) {
        Transformationparametermapping _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationparametermapping");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="transformationparametermappingid")
    @JsonIgnore
    public Optional<UUID> getTransformationparametermappingid() {
        return Optional.ofNullable(transformationparametermappingid);
    }

    public Transformationparametermapping withTransformationparametermappingid(UUID transformationparametermappingid) {
        Transformationparametermapping _x = _copy();
        _x.changedFields = changedFields.add("transformationparametermappingid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationparametermapping");
        _x.transformationparametermappingid = transformationparametermappingid;
        return _x;
    }

    public Transformationparametermapping withUnmappedField(String name, Object value) {
        Transformationparametermapping _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="transformationmappingid")
    @JsonIgnore
    public TransformationmappingRequest getTransformationmappingid() {
        return new TransformationmappingRequest(contextPath.addSegment("transformationmappingid"), RequestHelper.getValue(unmappedFields, "transformationmappingid"));
    }

    @NavigationProperty(name="LookUpMapping_TransformationParameterMapping")
    @JsonIgnore
    public LookupmappingCollectionRequest getLookUpMapping_TransformationParameterMapping() {
        return new LookupmappingCollectionRequest(
                        contextPath.addSegment("LookUpMapping_TransformationParameterMapping"), RequestHelper.getValue(unmappedFields, "LookUpMapping_TransformationParameterMapping"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Transformationparametermapping patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Transformationparametermapping _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Transformationparametermapping put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Transformationparametermapping _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Transformationparametermapping _copy() {
        Transformationparametermapping _x = new Transformationparametermapping();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._transformationmappingid_value = _transformationmappingid_value;
        _x.overwritetime = overwritetime;
        _x.parametersequence = parametersequence;
        _x.parameterarrayindex = parameterarrayindex;
        _x._modifiedby_value = _modifiedby_value;
        _x.introducedversion = introducedversion;
        _x.componentstate = componentstate;
        _x.data = data;
        _x.ismanaged = ismanaged;
        _x.modifiedon = modifiedon;
        _x.datatypecode = datatypecode;
        _x.transformationparametermappingidunique = transformationparametermappingidunique;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._createdby_value = _createdby_value;
        _x.solutionid = solutionid;
        _x.parametertypecode = parametertypecode;
        _x.createdon = createdon;
        _x.transformationparametermappingid = transformationparametermappingid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Transformationparametermapping[");
        b.append("_transformationmappingid_value=");
        b.append(this._transformationmappingid_value);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("parametersequence=");
        b.append(this.parametersequence);
        b.append(", ");
        b.append("parameterarrayindex=");
        b.append(this.parameterarrayindex);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("data=");
        b.append(this.data);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("datatypecode=");
        b.append(this.datatypecode);
        b.append(", ");
        b.append("transformationparametermappingidunique=");
        b.append(this.transformationparametermappingidunique);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("parametertypecode=");
        b.append(this.parametertypecode);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("transformationparametermappingid=");
        b.append(this.transformationparametermappingid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
